/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CollectionTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.DoubleTag;
import net.momirealms.craftengine.libraries.nbt.FloatTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.ShortTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private final List<Tag> list;

    public ListTag(List<Tag> list) {
        this.list = list;
    }

    public ListTag() {
        this.list = new ArrayList<Tag>();
    }

    public static Tag tryUnwrap(CompoundTag tag) {
        Tag tag1;
        if (tag.size() == 1 && (tag1 = tag.get("")) != null) {
            return tag1;
        }
        return tag;
    }

    private static boolean isWrapper(CompoundTag tag) {
        return tag.size() == 1 && tag.containsKey("");
    }

    public static Tag wrapIfNeeded(byte elementType, Tag tag) {
        CompoundTag compoundTag;
        if (elementType != 10) {
            return tag;
        }
        return tag instanceof CompoundTag && !ListTag.isWrapper(compoundTag = (CompoundTag)tag) ? compoundTag : ListTag.wrapElement(tag);
    }

    private static CompoundTag wrapElement(Tag tag) {
        return new CompoundTag(Map.of("", tag));
    }

    @Override
    public Tag get(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Tag set(int index, Tag tag) {
        return this.list.set(index, tag);
    }

    @Override
    public void add(int index, Tag tag) {
        this.list.add(index, tag);
    }

    @Override
    public Tag remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean setTag(int index, Tag tag) {
        this.list.set(index, tag);
        return true;
    }

    @Override
    public boolean addTag(int index, Tag tag) {
        this.list.add(index, tag);
        return true;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        byte type = this.identifyRawElementType();
        output.writeByte(type);
        output.writeInt(this.list.size());
        for (Tag tag : this.list) {
            ListTag.wrapIfNeeded(type, tag).write(output);
        }
    }

    public void addAndUnwrap(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.add(ListTag.tryUnwrap(compoundTag));
        } else {
            this.add(tag);
        }
    }

    public byte identifyRawElementType() {
        byte type = 0;
        for (Tag tag : this.list) {
            byte id = tag.getId();
            if (type == 0) {
                type = id;
                continue;
            }
            if (type == id) continue;
            return 10;
        }
        return type;
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.LIST;
    }

    @Override
    public ListTag copy() {
        return new ListTag(new ArrayList<Tag>(this.list));
    }

    @Override
    public ListTag deepClone() {
        ArrayList<Tag> list = new ArrayList<Tag>(this.list.size());
        for (Tag tag : this.list) {
            list.add(tag.deepClone());
        }
        return new ListTag(list);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitList(this);
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        return this.getTypedValue(index, 8, Tag::getAsString, defaultValue);
    }

    public float getFloat(int index) {
        return this.getFloat(index, 0.0f);
    }

    public float getFloat(int index, float defaultValue) {
        return this.getTypedValue(index, 5, t -> Float.valueOf(((FloatTag)t).getAsFloat()), Float.valueOf(defaultValue)).floatValue();
    }

    public double getDouble(int index) {
        return this.getDouble(index, 0.0);
    }

    public double getDouble(int index, double defaultValue) {
        return this.getTypedValue(index, 6, t -> ((DoubleTag)t).getAsDouble(), defaultValue);
    }

    public long[] getLongArray(int index) {
        return this.getLongArray(index, null);
    }

    public long[] getLongArray(int index, long[] defaultValue) {
        return this.getTypedValue(index, 12, t -> ((LongArrayTag)t).getAsLongArray(), defaultValue);
    }

    public int[] getIntArray(int index) {
        return this.getIntArray(index, null);
    }

    public int[] getIntArray(int index, int[] defaultValue) {
        return this.getTypedValue(index, 11, t -> ((IntArrayTag)t).getAsIntArray(), defaultValue);
    }

    public int getInt(int index) {
        return this.getInt(index, 0);
    }

    public int getInt(int index, int defaultValue) {
        return this.getTypedValue(index, 3, t -> ((IntTag)t).getAsInt(), defaultValue);
    }

    public short getShort(int index) {
        return this.getShort(index, (short)0);
    }

    public short getShort(int index, short defaultValue) {
        return this.getTypedValue(index, 2, t -> ((ShortTag)t).getAsShort(), defaultValue);
    }

    public byte getByte(int index) {
        return this.getByte(index, (byte)0);
    }

    public byte getByte(int index, byte defaultValue) {
        return this.getTypedValue(index, 1, t -> ((ByteTag)t).getAsByte(), defaultValue);
    }

    public long getLong(int index) {
        return this.getLong(index, 0L);
    }

    public long getLong(int index, long defaultValue) {
        return this.getTypedValue(index, 4, t -> ((LongTag)t).getAsLong(), defaultValue);
    }

    public ListTag getList(int index) {
        return this.getList(index, null);
    }

    public ListTag getList(int index, ListTag defaultValue) {
        return this.getTypedValue(index, 9, t -> (ListTag)t, defaultValue);
    }

    public CompoundTag getCompound(int index) {
        return this.getCompound(index, null);
    }

    public CompoundTag getCompound(int index, CompoundTag defaultValue) {
        return this.getTypedValue(index, 10, t -> (CompoundTag)t, defaultValue);
    }

    private <T> T getTypedValue(int index, int expectedId, Function<Tag, T> extractor, T defaultValue) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == expectedId) {
            return extractor.apply(tag);
        }
        return defaultValue;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTag)) {
            return false;
        }
        ListTag tags = (ListTag)o;
        return Objects.equals(this.list, tags.list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

