/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.momirealms.craftengine.libraries.nbt.ByteArrayTag;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.DoubleTag;
import net.momirealms.craftengine.libraries.nbt.EndTag;
import net.momirealms.craftengine.libraries.nbt.FloatTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.ShortTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.util.UUIDUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBT {
    private NBT() {
    }

    public static ByteTag createByte(byte b2) {
        return new ByteTag(b2);
    }

    public static ByteTag createBoolean(boolean b2) {
        return new ByteTag(b2);
    }

    public static ShortTag createShort(short s) {
        return new ShortTag(s);
    }

    public static IntTag createInt(int i) {
        return new IntTag(i);
    }

    public static LongTag createLong(long l) {
        return new LongTag(l);
    }

    public static FloatTag createFloat(float f2) {
        return new FloatTag(f2);
    }

    public static DoubleTag createDouble(double d2) {
        return new DoubleTag(d2);
    }

    public static StringTag createString(String s) {
        return new StringTag(s);
    }

    public static IntArrayTag createIntArray(int[] a2) {
        return new IntArrayTag(a2);
    }

    public static IntArrayTag createUUID(UUID uuid) {
        return new IntArrayTag(UUIDUtil.uuidToIntArray(uuid));
    }

    public static ByteArrayTag createByteArray(byte[] b2) {
        return new ByteArrayTag(b2);
    }

    public static LongArrayTag createLongArray(long[] a2) {
        return new LongArrayTag(a2);
    }

    public static CompoundTag createCompound(Map<String, Tag> tags) {
        return new CompoundTag(tags);
    }

    public static CompoundTag createCompound() {
        return new CompoundTag();
    }

    public static ListTag createList() {
        return new ListTag();
    }

    public static ListTag createList(List<Tag> tags) {
        return new ListTag(tags);
    }

    public static Tag readUnnamedTag(DataInput input, boolean named) throws IOException {
        byte typeId = input.readByte();
        if (typeId == 0) {
            return EndTag.INSTANCE;
        }
        if (named) {
            StringTag.skipString(input);
        }
        try {
            return TagTypes.typeById(typeId).read(input, 0);
        }
        catch (IOException ioException) {
            throw new IOException(ioException);
        }
    }

    public static void writeUnnamedTag(Tag tag, DataOutput output, boolean named) throws IOException {
        output.writeByte(tag.getId());
        if (tag.getId() != 0) {
            if (named) {
                output.writeUTF("");
            }
            tag.write(output);
        }
    }

    public static CompoundTag readCompound(DataInput input, boolean named) throws IOException {
        Tag tag = NBT.readUnnamedTag(input, named);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be CompoundTag");
    }

    public static void writeCompound(CompoundTag nbt, DataOutput output, boolean named) throws IOException {
        NBT.writeUnnamedTag(nbt, output, named);
    }

    @Nullable
    public static CompoundTag readFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        if (file.length() == 0L) {
            return null;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            CompoundTag compoundTag;
            try (DataInputStream input = new DataInputStream(fis);){
                compoundTag = NBT.readCompound(input, false);
            }
            return compoundTag;
        }
    }

    public static void writeFile(File file, CompoundTag nbt) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            NBT.writeCompound(nbt, dataOutputStream, false);
        }
    }

    @Nullable
    public static CompoundTag fromBytes(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            CompoundTag compoundTag;
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                compoundTag = NBT.readCompound(dataInputStream, false);
            }
            return compoundTag;
        }
    }

    public static byte @NotNull [] toBytes(@NotNull CompoundTag nbt) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                NBT.writeCompound(nbt, dataOutputStream, false);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public static byte @NotNull [] toBytes(@NotNull Tag nbt, boolean named) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                NBT.writeUnnamedTag(nbt, dataOutputStream, named);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }
}

