/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;

public class StringTag
implements Tag {
    private final String value;

    public StringTag(String value) {
        this.value = value;
    }

    public static void skipString(DataInput input) throws IOException {
        input.skipBytes(input.readUnsignedShort());
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.value);
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.STRING;
    }

    @Override
    public StringTag deepClone() {
        return new StringTag(this.value);
    }

    @Override
    public StringTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitString(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringTag)) {
            return false;
        }
        StringTag stringTag = (StringTag)o;
        return this.value.equals(stringTag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static String quoteAndEscape(String value) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        int quoteChar = 0;
        for (int i = 0; i < value.length(); ++i) {
            int currentChar = value.charAt(i);
            if (currentChar == 92) {
                stringBuilder.append('\\');
            } else if (currentChar == 34 || currentChar == 39) {
                if (quoteChar == 0) {
                    int n = quoteChar = currentChar == 34 ? 39 : 34;
                }
                if (quoteChar == currentChar) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append((char)currentChar);
        }
        if (quoteChar == 0) {
            quoteChar = 34;
        }
        stringBuilder.setCharAt(0, (char)quoteChar);
        stringBuilder.append((char)quoteChar);
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return Tag.super.getAsString();
    }

    @Override
    public String getAsString() {
        return this.value;
    }
}

