/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class LegacyJavaOps
implements DynamicOps<Object> {
    public static final LegacyJavaOps INSTANCE = new LegacyJavaOps();

    private LegacyJavaOps() {
    }

    public Object empty() {
        return null;
    }

    public Object emptyMap() {
        return Map.of();
    }

    public Object emptyList() {
        return List.of();
    }

    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        if (input == null) {
            return (U)outOps.empty();
        }
        if (input instanceof Map) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof ByteList) {
            ByteList value = (ByteList)input;
            return (U)outOps.createByteList(ByteBuffer.wrap(value.toByteArray()));
        }
        if (input instanceof IntList) {
            IntList value = (IntList)input;
            return (U)outOps.createIntList(value.intStream());
        }
        if (input instanceof LongList) {
            LongList value = (LongList)input;
            return (U)outOps.createLongList(value.longStream());
        }
        if (input instanceof List) {
            return (U)this.convertList(outOps, input);
        }
        if (input instanceof String) {
            String value = (String)input;
            return (U)outOps.createString(value);
        }
        if (input instanceof Boolean) {
            Boolean value = (Boolean)input;
            return (U)outOps.createBoolean(value.booleanValue());
        }
        if (input instanceof Byte) {
            Byte value = (Byte)input;
            return (U)outOps.createByte(value.byteValue());
        }
        if (input instanceof Short) {
            Short value = (Short)input;
            return (U)outOps.createShort(value.shortValue());
        }
        if (input instanceof Integer) {
            Integer value = (Integer)input;
            return (U)outOps.createInt(value.intValue());
        }
        if (input instanceof Long) {
            Long value = (Long)input;
            return (U)outOps.createLong(value.longValue());
        }
        if (input instanceof Float) {
            Float value = (Float)input;
            return (U)outOps.createFloat(value.floatValue());
        }
        if (input instanceof Double) {
            Double value = (Double)input;
            return (U)outOps.createDouble(value.doubleValue());
        }
        if (input instanceof Number) {
            Number value = (Number)input;
            return (U)outOps.createNumeric(value);
        }
        throw new IllegalStateException("Don't know how to convert " + String.valueOf(input));
    }

    public DataResult<Number> getNumberValue(Object input) {
        if (input instanceof Number) {
            Number value = (Number)input;
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public Object createNumeric(Number value) {
        return value;
    }

    public Object createByte(byte value) {
        return value;
    }

    public Object createShort(short value) {
        return value;
    }

    public Object createInt(int value) {
        return value;
    }

    public Object createLong(long value) {
        return value;
    }

    public Object createFloat(float value) {
        return Float.valueOf(value);
    }

    public Object createDouble(double value) {
        return value;
    }

    public DataResult<Boolean> getBooleanValue(Object input) {
        if (input instanceof Boolean) {
            Boolean value = (Boolean)input;
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public Object createBoolean(boolean value) {
        return value;
    }

    public DataResult<String> getStringValue(Object input) {
        if (input instanceof String) {
            String value = (String)input;
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public Object createString(String value) {
        return value;
    }

    public DataResult<Object> mergeToList(Object input, Object value) {
        if (input == this.empty()) {
            return DataResult.success(List.of(value));
        }
        if (input instanceof List) {
            List list = (List)input;
            if (list.isEmpty()) {
                return DataResult.success(List.of(value));
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)list).add(value).build());
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(input));
    }

    public DataResult<Object> mergeToList(Object input, List<Object> values) {
        if (input == this.empty()) {
            return DataResult.success(values);
        }
        if (input instanceof List) {
            List list = (List)input;
            if (list.isEmpty()) {
                return DataResult.success(values);
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)list).addAll(values).build());
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(input));
    }

    public DataResult<Object> mergeToMap(Object input, Object key, Object value) {
        if (input == this.empty()) {
            return DataResult.success(Map.of(key, value));
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(Map.of(key, value));
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)(map.size() + 1));
            result.putAll(map);
            result.put(key, value);
            return DataResult.success((Object)result.build());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public DataResult<Object> mergeToMap(Object input, Map<Object, Object> values) {
        if (input == this.empty()) {
            return DataResult.success(values);
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(values);
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)(map.size() + values.size()));
            result.putAll(map);
            result.putAll(values);
            return DataResult.success((Object)result.build());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    private static Map<Object, Object> mapLikeToMap(MapLike<Object> values) {
        return (Map)values.entries().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<Object> mergeToMap(Object input, MapLike<Object> values) {
        if (input == this.empty()) {
            return DataResult.success(LegacyJavaOps.mapLikeToMap(values));
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (map.isEmpty()) {
                return DataResult.success(LegacyJavaOps.mapLikeToMap(values));
            }
            ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)map.size());
            result.putAll(map);
            values.entries().forEach(e -> result.put(e.getFirst(), e.getSecond()));
            return DataResult.success((Object)result.build());
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    private static Stream<Pair<Object, Object>> getMapEntries(Map<?, ?> input) {
        return input.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue()));
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        if (input instanceof Map) {
            Map map = (Map)input;
            return DataResult.success(LegacyJavaOps.getMapEntries(map));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object input) {
        if (input instanceof Map) {
            Map map = (Map)input;
            return DataResult.success(map::forEach);
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public Object createMap(Stream<Pair<Object, Object>> map) {
        return map.collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<MapLike<Object>> getMap(Object input) {
        if (input instanceof Map) {
            final Map map = (Map)input;
            return DataResult.success((Object)new MapLike<Object>(this){

                @Nullable
                public Object get(Object key) {
                    return map.get(key);
                }

                @Nullable
                public Object get(String key) {
                    return map.get(key);
                }

                public Stream<Pair<Object, Object>> entries() {
                    return LegacyJavaOps.getMapEntries(map);
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(map) + "]";
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public Object createMap(Map<Object, Object> map) {
        return map;
    }

    public DataResult<Stream<Object>> getStream(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return DataResult.success(list.stream().map(o -> o));
        }
        return DataResult.error(() -> "Not an list: " + String.valueOf(input));
    }

    public DataResult<Consumer<Consumer<Object>>> getList(Object input) {
        if (input instanceof List) {
            List list = (List)input;
            return DataResult.success(list::forEach);
        }
        return DataResult.error(() -> "Not an list: " + String.valueOf(input));
    }

    public Object createList(Stream<Object> input) {
        return input.toList();
    }

    public DataResult<ByteBuffer> getByteBuffer(Object input) {
        if (input instanceof ByteList) {
            ByteList value = (ByteList)input;
            return DataResult.success((Object)ByteBuffer.wrap(value.toByteArray()));
        }
        return DataResult.error(() -> "Not a byte list: " + String.valueOf(input));
    }

    public Object createByteList(ByteBuffer input) {
        ByteBuffer wholeBuffer = input.duplicate().clear();
        ByteArrayList result = new ByteArrayList();
        result.size(wholeBuffer.capacity());
        wholeBuffer.get(0, result.elements(), 0, result.size());
        return result;
    }

    public DataResult<IntStream> getIntStream(Object input) {
        if (input instanceof IntList) {
            IntList value = (IntList)input;
            return DataResult.success((Object)value.intStream());
        }
        return DataResult.error(() -> "Not an int list: " + String.valueOf(input));
    }

    public Object createIntList(IntStream input) {
        return IntArrayList.toList((IntStream)input);
    }

    public DataResult<LongStream> getLongStream(Object input) {
        if (input instanceof LongList) {
            LongList value = (LongList)input;
            return DataResult.success((Object)value.longStream());
        }
        return DataResult.error(() -> "Not a long list: " + String.valueOf(input));
    }

    public Object createLongList(LongStream input) {
        return LongArrayList.toList((LongStream)input);
    }

    public Object remove(Object input, String key) {
        if (input instanceof Map) {
            Map map = (Map)input;
            LinkedHashMap result = new LinkedHashMap(map);
            result.remove(key);
            return Map.copyOf(result);
        }
        return input;
    }

    public RecordBuilder<Object> mapBuilder() {
        return new FixedMapBuilder<Object>(this);
    }

    public String toString() {
        return "Java";
    }

    private static final class FixedMapBuilder<T>
    extends RecordBuilder.AbstractUniversalBuilder<T, ImmutableMap.Builder<T, T>> {
        public FixedMapBuilder(DynamicOps<T> ops) {
            super(ops);
        }

        protected ImmutableMap.Builder<T, T> initBuilder() {
            return ImmutableMap.builder();
        }

        protected ImmutableMap.Builder<T, T> append(T key, T value, ImmutableMap.Builder<T, T> builder) {
            return builder.put(key, value);
        }

        protected DataResult<T> build(ImmutableMap.Builder<T, T> builder, T prefix) {
            ImmutableMap result = builder.build();
            return this.ops().mergeToMap(prefix, (Map)result);
        }
    }
}

