/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.api;

import java.util.Map;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UpdateOption;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftEngineBlocks {
    private CraftEngineBlocks() {
    }

    @NotNull
    public static Map<Key, CustomBlock> loadedBlocks() {
        return BukkitBlockManager.instance().loadedBlocks();
    }

    @Nullable
    public static CustomBlock byId(@NotNull Key id) {
        return BukkitBlockManager.instance().blockById(id).orElse(null);
    }

    public static boolean place(@NotNull Location location, @NotNull ImmutableBlockState block, boolean playSound) {
        return CraftEngineBlocks.place(location, block, UpdateOption.UPDATE_ALL, playSound);
    }

    public static boolean place(@NotNull Location location, @NotNull Key blockId, boolean playSound) {
        CustomBlock block = CraftEngineBlocks.byId(blockId);
        if (block == null) {
            return false;
        }
        return CraftEngineBlocks.place(location, block.defaultState(), UpdateOption.UPDATE_ALL, playSound);
    }

    public static boolean place(@NotNull Location location, @NotNull Key blockId, @NotNull CompoundTag properties, boolean playSound) {
        CustomBlock block = CraftEngineBlocks.byId(blockId);
        if (block == null) {
            return false;
        }
        return CraftEngineBlocks.place(location, block.getBlockState(properties), UpdateOption.UPDATE_ALL, playSound);
    }

    public static boolean place(@NotNull Location location, @NotNull Key blockId, @NotNull CompoundTag properties, @NotNull UpdateOption option, boolean playSound) {
        CustomBlock block = CraftEngineBlocks.byId(blockId);
        if (block == null) {
            return false;
        }
        return CraftEngineBlocks.place(location, block.getBlockState(properties), option, playSound);
    }

    public static boolean place(@NotNull Location location, @NotNull ImmutableBlockState block, @NotNull UpdateOption option, boolean playSound) {
        Object worldServer = FastNMS.INSTANCE.field$CraftWorld$ServerLevel(location.getWorld());
        Object blockPos = FastNMS.INSTANCE.constructor$BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Object blockState = block.customBlockState().literalObject();
        Object oldBlockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(worldServer, blockPos);
        boolean success = FastNMS.INSTANCE.method$LevelWriter$setBlock(worldServer, blockPos, blockState, option.flags());
        if (success) {
            FastNMS.INSTANCE.method$BlockStateBase$onPlace(blockState, worldServer, blockPos, oldBlockState, false);
            if (playSound) {
                SoundData data = block.settings().sounds().placeSound();
                location.getWorld().playSound(location, data.id().toString(), SoundCategory.BLOCKS, ((Float)data.volume().get()).floatValue(), ((Float)data.pitch().get()).floatValue());
            }
        }
        return success;
    }

    public static boolean remove(@NotNull Block block) {
        return CraftEngineBlocks.remove(block, false);
    }

    public static boolean remove(@NotNull Block block, boolean isMoving) {
        if (!CraftEngineBlocks.isCustomBlock(block)) {
            return false;
        }
        FastNMS.INSTANCE.method$Level$removeBlock(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(block.getWorld()), LocationUtils.toBlockPos(block.getX(), block.getY(), block.getZ()), isMoving);
        return true;
    }

    public static boolean remove(@NotNull Block block, @Nullable Player player, boolean isMoving, boolean dropLoot, boolean sendLevelEvent) {
        ImmutableBlockState state = CraftEngineBlocks.getCustomBlockState(block);
        if (state == null || state.isEmpty()) {
            return false;
        }
        BukkitWorld world = new BukkitWorld(block.getWorld());
        Location location = block.getLocation();
        WorldPosition position = new WorldPosition((World)world, (double)location.getBlockX() + 0.5, (double)location.getBlockY() + 0.5, (double)location.getBlockZ() + 0.5);
        if (dropLoot) {
            ContextHolder.Builder builder = new ContextHolder.Builder().withParameter(DirectContextParameters.POSITION, position);
            BukkitServerPlayer serverPlayer = null;
            if (player != null) {
                serverPlayer = BukkitCraftEngine.instance().adapt(player);
                builder.withOptionalParameter(DirectContextParameters.PLAYER, serverPlayer);
            }
            for (Item<Object> item : state.getDrops(builder, world, serverPlayer)) {
                world.dropItemNaturally(position, item);
            }
        }
        if (sendLevelEvent) {
            FastNMS.INSTANCE.method$LevelAccessor$levelEvent(world.serverWorld(), 2001, LocationUtils.toBlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), state.customBlockState().registryId());
        }
        FastNMS.INSTANCE.method$Level$removeBlock(world.serverWorld(), LocationUtils.toBlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), isMoving);
        return true;
    }

    @Deprecated(forRemoval=true)
    public static boolean remove(@NotNull Block block, @Nullable Player player, boolean isMoving, boolean dropLoot, boolean playSound, boolean sendParticles) {
        return CraftEngineBlocks.remove(block, player, dropLoot, isMoving, playSound || sendParticles);
    }

    public static boolean isCustomBlock(@NotNull Block block) {
        Object state = FastNMS.INSTANCE.method$BlockGetter$getBlockState(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(block.getWorld()), LocationUtils.toBlockPos(block.getX(), block.getY(), block.getZ()));
        return BlockStateUtils.isCustomBlock(state);
    }

    @Nullable
    public static ImmutableBlockState getCustomBlockState(@NotNull Block block) {
        Object state = FastNMS.INSTANCE.method$BlockGetter$getBlockState(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(block.getWorld()), LocationUtils.toBlockPos(block.getX(), block.getY(), block.getZ()));
        return BlockStateUtils.getOptionalCustomBlockState(state).orElse(null);
    }

    @Nullable
    public static ImmutableBlockState getCustomBlockState(@NotNull BlockData blockData) {
        Object state = BlockStateUtils.blockDataToBlockState(blockData);
        return BlockStateUtils.getOptionalCustomBlockState(state).orElse(null);
    }

    @NotNull
    public static BlockData getBukkitBlockData(@NotNull ImmutableBlockState blockState) {
        return BlockStateUtils.fromBlockData(blockState.customBlockState().literalObject());
    }

    public static boolean isVanillaBlockState(int id) {
        return BukkitBlockManager.instance().isVanillaBlockState(id);
    }
}

