/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.api.event;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.momirealms.craftengine.core.pack.PackCacheData;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class AsyncResourcePackCacheEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final PackCacheData cacheData;

    public AsyncResourcePackCacheEvent(@NotNull PackCacheData cacheData) {
        super(true);
        this.cacheData = cacheData;
    }

    @NotNull
    public PackCacheData cacheData() {
        return this.cacheData;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return AsyncResourcePackCacheEvent.getHandlerList();
    }

    public void registerExternalResourcePack(@NotNull Path path) {
        if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().endsWith(".zip")) {
            this.cacheData.externalZips().add(path);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            this.cacheData.externalFolders().add(path);
        } else {
            throw new IllegalArgumentException("Illegal resource pack path: " + String.valueOf(path));
        }
    }
}

