/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.bukkit.block.BlockEventListener;
import net.momirealms.craftengine.bukkit.block.BukkitBlockShape;
import net.momirealms.craftengine.bukkit.block.BukkitCustomBlock;
import net.momirealms.craftengine.bukkit.block.BukkitCustomBlockStateWrapper;
import net.momirealms.craftengine.bukkit.block.BukkitVanillaBlockStateWrapper;
import net.momirealms.craftengine.bukkit.block.behavior.UnsafeCompositeBlockBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.injector.BlockGenerator;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MFluids;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.RegistryUtils;
import net.momirealms.craftengine.bukkit.util.SoundUtils;
import net.momirealms.craftengine.bukkit.util.TagUtils;
import net.momirealms.craftengine.core.block.AbstractBlockManager;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockKeys;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.block.BlockRegistryMirror;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockShape;
import net.momirealms.craftengine.core.block.BlockSounds;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.DelegatingBlock;
import net.momirealms.craftengine.core.block.DelegatingBlockState;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.AbstractBlockBehavior;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviors;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.block.parser.BlockStateParser;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.SoundSet;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ObjectHolder;
import net.momirealms.craftengine.core.util.Tristate;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.chunk.PalettedContainer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitBlockManager
extends AbstractBlockManager {
    public static final Set<Object> CLIENT_SIDE_NOTE_BLOCKS = new HashSet<Object>(2048, 0.6f);
    private static final Object ALWAYS_FALSE = FastNMS.INSTANCE.method$StatePredicate$always(false);
    private static final Object ALWAYS_TRUE = FastNMS.INSTANCE.method$StatePredicate$always(true);
    private static BukkitBlockManager instance;
    private final BukkitCraftEngine plugin;
    private final BlockEventListener blockEventListener;
    private final Map<String, BlockStateWrapper> blockStateCache = new HashMap<String, BlockStateWrapper>(1024);
    private final List<DelegatingBlock> burnableBlocks = new ArrayList<DelegatingBlock>();
    private Map<Object, Integer> igniteOdds;
    private Map<Object, Integer> burnOdds;
    private Map<Integer, List<String>> clientBoundTags = Map.of();
    private Map<Integer, List<String>> previousClientBoundTags = Map.of();
    private Object cachedUpdateTagsPacket;
    private Set<Object> missingPlaceSounds = Set.of();
    private Set<Object> missingBreakSounds = Set.of();
    private Set<Object> missingHitSounds = Set.of();
    private Set<Object> missingStepSounds = Set.of();
    private Set<Key> missingInteractSoundBlocks = Set.of();

    public BukkitBlockManager(BukkitCraftEngine plugin) {
        super(plugin, RegistryUtils.currentBlockRegistrySize(), Config.serverSideBlocks());
        this.plugin = plugin;
        this.blockEventListener = new BlockEventListener(plugin, this);
        this.registerServerSideCustomBlocks(Config.serverSideBlocks());
        EmptyBlock.initialize();
        instance = this;
    }

    @Override
    public void init() {
        this.initMirrorRegistry();
        this.initFireBlock();
        this.deceiveBukkitRegistry();
        this.markVanillaNoteBlocks();
        Arrays.fill(this.immutableBlockStates, EmptyBlock.INSTANCE.defaultState());
        this.plugin.networkManager().registerBlockStatePacketListeners(this.blockStateMappings);
    }

    public static BukkitBlockManager instance() {
        return instance;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.blockEventListener, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void unload() {
        super.unload();
        this.previousClientBoundTags = this.clientBoundTags;
        this.clientBoundTags = new HashMap<Integer, List<String>>();
        for (DelegatingBlock block : this.burnableBlocks) {
            this.igniteOdds.remove(block);
            this.burnOdds.remove(block);
        }
        this.burnableBlocks.clear();
        if (EmptyBlock.STATE != null) {
            Arrays.fill(this.immutableBlockStates, EmptyBlock.STATE);
        }
        for (DelegatingBlock block : this.customBlocks) {
            block.behaviorDelegate().bindValue(EmptyBlockBehavior.INSTANCE);
            block.shapeDelegate().bindValue(BukkitBlockShape.STONE);
            DelegatingBlockState state = (DelegatingBlockState)FastNMS.INSTANCE.method$Block$defaultState(block);
            state.setBlockState(null);
        }
    }

    @Override
    public void disable() {
        this.unload();
        HandlerList.unregisterAll((Listener)this.blockEventListener);
    }

    @Override
    public void delayedLoad() {
        this.plugin.networkManager().registerBlockStatePacketListeners(this.blockStateMappings);
        super.delayedLoad();
    }

    @Override
    public BlockBehavior createBlockBehavior(CustomBlock customBlock, List<Map<String, Object>> behaviorConfig) {
        if (behaviorConfig == null || behaviorConfig.isEmpty()) {
            return new EmptyBlockBehavior();
        }
        if (behaviorConfig.size() == 1) {
            return BlockBehaviors.fromMap(customBlock, behaviorConfig.getFirst());
        }
        ArrayList<AbstractBlockBehavior> behaviors = new ArrayList<AbstractBlockBehavior>();
        for (Map<String, Object> config : behaviorConfig) {
            behaviors.add((AbstractBlockBehavior)BlockBehaviors.fromMap(customBlock, config));
        }
        return new UnsafeCompositeBlockBehavior(customBlock, behaviors);
    }

    @Override
    protected void resendTags() {
        if (this.clientBoundTags.equals(this.previousClientBoundTags)) {
            return;
        }
        ArrayList<TagUtils.TagEntry> list = new ArrayList<TagUtils.TagEntry>();
        for (Map.Entry<Integer, List<String>> entry : this.clientBoundTags.entrySet()) {
            list.add(new TagUtils.TagEntry(entry.getKey(), entry.getValue()));
        }
        Object packet = TagUtils.createUpdateTagsPacket(Map.of(MRegistries.BLOCK, list));
        for (BukkitServerPlayer player : this.plugin.networkManager().onlineUsers()) {
            player.sendPacket(packet, false);
        }
        this.cachedUpdateTagsPacket = list.isEmpty() ? null : packet;
    }

    @Override
    @Nullable
    public BlockStateWrapper createBlockState(String blockState) {
        ImmutableBlockState state = BlockStateParser.deserialize(blockState);
        if (state != null) {
            return state.customBlockState();
        }
        return this.createVanillaBlockState(blockState);
    }

    @Override
    public BlockStateWrapper createVanillaBlockState(String blockState) {
        return this.blockStateCache.computeIfAbsent(blockState, k -> {
            Object state = this.parseBlockState((String)k);
            if (state == null) {
                return null;
            }
            return BlockStateUtils.toBlockStateWrapper(state);
        });
    }

    @Nullable
    private Object parseBlockState(String state) {
        try {
            Object registryOrLookUp = MBuiltInRegistries.BLOCK;
            if (CoreReflections.method$Registry$asLookup != null) {
                registryOrLookUp = CoreReflections.method$Registry$asLookup.invoke(registryOrLookUp, new Object[0]);
            }
            Object result = CoreReflections.method$BlockStateParser$parseForBlock.invoke(null, registryOrLookUp, state, false);
            return CoreReflections.method$BlockStateParser$BlockResult$blockState.invoke(result, new Object[0]);
        }
        catch (Exception e) {
            Debugger.BLOCK.warn(() -> "Failed to create block state: " + state, e);
            return null;
        }
    }

    @Nullable
    public Object getMinecraftBlockHolder(int stateId) {
        return this.customBlockHolders[stateId - BlockStateUtils.vanillaBlockStateCount()];
    }

    @Override
    public Key getBlockOwnerId(BlockStateWrapper state) {
        return BlockStateUtils.getBlockOwnerIdFromState(state.literalObject());
    }

    @Override
    protected Key getBlockOwnerId(int id) {
        return BlockStateUtils.getBlockOwnerIdFromState(BlockStateUtils.idToBlockState(id));
    }

    private void initFireBlock() {
        try {
            this.igniteOdds = (Map)CoreReflections.field$FireBlock$igniteOdds.get(MBlocks.FIRE);
            this.burnOdds = (Map)CoreReflections.field$FireBlock$burnOdds.get(MBlocks.FIRE);
        }
        catch (IllegalAccessException e) {
            this.plugin.logger().warn("Failed to get ignite odds", e);
        }
    }

    @Override
    protected void applyPlatformSettings(ImmutableBlockState state) {
        DelegatingBlockState nmsState = (DelegatingBlockState)state.customBlockState().literalObject();
        nmsState.setBlockState(state);
        Object nmsVisualState = state.vanillaBlockState().literalObject();
        BlockSettings settings = state.settings();
        try {
            CoreReflections.field$BlockStateBase$lightEmission.set(nmsState, settings.luminance());
            CoreReflections.field$BlockStateBase$burnable.set(nmsState, settings.burnable());
            CoreReflections.field$BlockStateBase$hardness.set(nmsState, Float.valueOf(settings.hardness()));
            CoreReflections.field$BlockStateBase$replaceable.set(nmsState, settings.replaceable());
            Object mcMapColor = CoreReflections.method$MapColor$byId.invoke(null, settings.mapColor().id);
            CoreReflections.field$BlockStateBase$mapColor.set(nmsState, mcMapColor);
            CoreReflections.field$BlockStateBase$instrument.set(nmsState, CoreReflections.instance$NoteBlockInstrument$values[settings.instrument().ordinal()]);
            CoreReflections.field$BlockStateBase$pushReaction.set(nmsState, CoreReflections.instance$PushReaction$values[settings.pushReaction().ordinal()]);
            boolean canOcclude = settings.canOcclude() == Tristate.UNDEFINED ? BlockStateUtils.isOcclude(nmsVisualState) : settings.canOcclude().asBoolean();
            CoreReflections.field$BlockStateBase$canOcclude.set(nmsState, canOcclude);
            boolean useShapeForLightOcclusion = settings.useShapeForLightOcclusion() == Tristate.UNDEFINED ? CoreReflections.field$BlockStateBase$useShapeForLightOcclusion.getBoolean(nmsVisualState) : settings.useShapeForLightOcclusion().asBoolean();
            CoreReflections.field$BlockStateBase$useShapeForLightOcclusion.set(nmsState, useShapeForLightOcclusion);
            CoreReflections.field$BlockStateBase$isRedstoneConductor.set(nmsState, settings.isRedstoneConductor().asBoolean() ? ALWAYS_TRUE : ALWAYS_FALSE);
            CoreReflections.field$BlockStateBase$isSuffocating.set(nmsState, settings.isSuffocating().asBoolean() ? ALWAYS_TRUE : ALWAYS_FALSE);
            CoreReflections.field$BlockStateBase$isViewBlocking.set(nmsState, settings.isViewBlocking() == Tristate.UNDEFINED ? (settings.isSuffocating().asBoolean() ? ALWAYS_TRUE : ALWAYS_FALSE) : (settings.isViewBlocking().asBoolean() ? ALWAYS_TRUE : ALWAYS_FALSE));
            DelegatingBlock nmsBlock = (DelegatingBlock)BlockStateUtils.getBlockOwner(nmsState);
            ObjectHolder<BlockShape> shapeHolder = nmsBlock.shapeDelegate();
            shapeHolder.bindValue(new BukkitBlockShape(nmsVisualState, Optional.ofNullable(state.settings().supportShapeBlockState()).map(it -> Objects.requireNonNull(this.createVanillaBlockState((String)it), "Illegal block state: " + it).literalObject()).orElse(null)));
            ObjectHolder<BlockBehavior> behaviorHolder = nmsBlock.behaviorDelegate();
            behaviorHolder.bindValue(state.behavior());
            CoreReflections.field$BlockBehaviour$explosionResistance.set(nmsBlock, Float.valueOf(settings.resistance()));
            CoreReflections.field$BlockBehaviour$friction.set(nmsBlock, Float.valueOf(settings.friction()));
            CoreReflections.field$BlockBehaviour$speedFactor.set(nmsBlock, Float.valueOf(settings.speedFactor()));
            CoreReflections.field$BlockBehaviour$jumpFactor.set(nmsBlock, Float.valueOf(settings.jumpFactor()));
            CoreReflections.field$BlockBehaviour$soundType.set(nmsBlock, SoundUtils.toSoundType(settings.sounds()));
            CoreReflections.method$BlockStateBase$initCache.invoke((Object)nmsState, new Object[0]);
            boolean isConditionallyFullOpaque = canOcclude & useShapeForLightOcclusion;
            if (!VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.field$BlockStateBase$isConditionallyFullOpaque.set(nmsState, isConditionallyFullOpaque);
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                int blockLight = settings.blockLight() != -1 ? settings.blockLight() : CoreReflections.field$BlockStateBase$lightBlock.getInt(nmsVisualState);
                CoreReflections.field$BlockStateBase$lightBlock.set(nmsState, blockLight);
                boolean propagatesSkylightDown = settings.propagatesSkylightDown() == Tristate.UNDEFINED ? CoreReflections.field$BlockStateBase$propagatesSkylightDown.getBoolean(nmsVisualState) : settings.propagatesSkylightDown().asBoolean();
                CoreReflections.field$BlockStateBase$propagatesSkylightDown.set(nmsState, propagatesSkylightDown);
            } else {
                Object cache = CoreReflections.field$BlockStateBase$cache.get(nmsState);
                int blockLight = settings.blockLight() != -1 ? settings.blockLight() : CoreReflections.field$BlockStateBase$Cache$lightBlock.getInt(CoreReflections.field$BlockStateBase$cache.get(nmsVisualState));
                CoreReflections.field$BlockStateBase$Cache$lightBlock.set(cache, blockLight);
                boolean propagatesSkylightDown = settings.propagatesSkylightDown() == Tristate.UNDEFINED ? CoreReflections.field$BlockStateBase$Cache$propagatesSkylightDown.getBoolean(CoreReflections.field$BlockStateBase$cache.get(nmsVisualState)) : settings.propagatesSkylightDown().asBoolean();
                CoreReflections.field$BlockStateBase$Cache$propagatesSkylightDown.set(cache, propagatesSkylightDown);
                if (!isConditionallyFullOpaque) {
                    CoreReflections.field$BlockStateBase$opacityIfCached.set(nmsState, blockLight);
                }
            }
            CoreReflections.field$BlockStateBase$fluidState.set(nmsState, settings.fluidState() ? MFluids.WATER$defaultState : MFluids.EMPTY$defaultState);
            CoreReflections.field$BlockStateBase$isRandomlyTicking.set(nmsState, settings.isRandomlyTicking());
            Object holder = BukkitCraftEngine.instance().blockManager().getMinecraftBlockHolder(state.customBlockState().registryId());
            HashSet<Object> tags = new HashSet<Object>();
            for (Key tag : settings.tags()) {
                tags.add(CoreReflections.method$TagKey$create.invoke(null, MRegistries.BLOCK, KeyUtils.toResourceLocation(tag)));
            }
            CoreReflections.field$Holder$Reference$tags.set(holder, tags);
            if (settings.burnable()) {
                this.igniteOdds.put(nmsBlock, settings.burnChance());
                this.burnOdds.put(nmsBlock, settings.fireSpreadChance());
                this.burnableBlocks.add(nmsBlock);
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to apply platform block settings for block state " + String.valueOf(state), e);
        }
    }

    private BlockSounds toBlockSounds(Object soundType) throws ReflectiveOperationException {
        return new BlockSounds(this.toSoundData(CoreReflections.field$SoundType$breakSound.get(soundType), SoundData.SoundValue.FIXED_1, SoundData.SoundValue.FIXED_0_8), this.toSoundData(CoreReflections.field$SoundType$stepSound.get(soundType), SoundData.SoundValue.FIXED_0_15, SoundData.SoundValue.FIXED_1), this.toSoundData(CoreReflections.field$SoundType$placeSound.get(soundType), SoundData.SoundValue.FIXED_1, SoundData.SoundValue.FIXED_0_8), this.toSoundData(CoreReflections.field$SoundType$hitSound.get(soundType), SoundData.SoundValue.FIXED_0_5, SoundData.SoundValue.FIXED_0_5), this.toSoundData(CoreReflections.field$SoundType$fallSound.get(soundType), SoundData.SoundValue.FIXED_0_5, SoundData.SoundValue.FIXED_0_75));
    }

    private SoundData toSoundData(Object soundEvent, SoundData.SoundValue volume, SoundData.SoundValue pitch) {
        Key soundId = KeyUtils.resourceLocationToKey(FastNMS.INSTANCE.field$SoundEvent$location(soundEvent));
        return new SoundData(soundId, volume, pitch);
    }

    private void initMirrorRegistry() {
        int i;
        int size = RegistryUtils.currentBlockRegistrySize();
        BlockStateWrapper[] states = new BlockStateWrapper[size];
        for (i = 0; i < this.vanillaBlockStateCount; ++i) {
            states[i] = new BukkitVanillaBlockStateWrapper(BlockStateUtils.idToBlockState(i), i);
        }
        for (i = this.vanillaBlockStateCount; i < size; ++i) {
            states[i] = new BukkitCustomBlockStateWrapper(BlockStateUtils.idToBlockState(i), i);
        }
        BlockRegistryMirror.init(states, states[BlockStateUtils.blockStateToId(MBlocks.STONE$defaultState)]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServerSideCustomBlocks(int count) {
        if (MiscUtils.ceilLog2(this.vanillaBlockStateCount + count) == MiscUtils.ceilLog2(this.vanillaBlockStateCount)) {
            PalettedContainer.NEED_DOWNGRADE = false;
        }
        try {
            this.unfreezeRegistry();
            for (int i = 0; i < count; ++i) {
                DelegatingBlock customBlock;
                Key customBlockId = BlockManager.createCustomBlockKey(i);
                try {
                    customBlock = BlockGenerator.generateBlock(customBlockId);
                }
                catch (Throwable t) {
                    CraftEngine.instance().logger().warn("Failed to generate custom block " + String.valueOf(customBlockId), t);
                    break;
                }
                this.customBlocks[i] = customBlock;
                try {
                    DelegatingBlockState newBlockState;
                    Object blockHolder;
                    Object resourceLocation = KeyUtils.toResourceLocation(customBlockId);
                    this.customBlockHolders[i] = blockHolder = CoreReflections.method$Registry$registerForHolder.invoke(null, MBuiltInRegistries.BLOCK, resourceLocation, customBlock);
                    CoreReflections.method$Holder$Reference$bindValue.invoke(blockHolder, customBlock);
                    CoreReflections.field$Holder$Reference$tags.set(blockHolder, Set.of());
                    this.customBlockStates[i] = newBlockState = (DelegatingBlockState)FastNMS.INSTANCE.method$Block$defaultState(customBlock);
                    CoreReflections.method$IdMapper$add.invoke(CoreReflections.instance$Block$BLOCK_STATE_REGISTRY, newBlockState);
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    CraftEngine.instance().logger().warn("Failed to register custom block " + String.valueOf(customBlockId), e);
                }
            }
        }
        finally {
            this.freezeRegistry();
        }
    }

    public Object cachedUpdateTagsPacket() {
        return this.cachedUpdateTagsPacket;
    }

    private void markVanillaNoteBlocks() {
        try {
            Object block = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(BlockKeys.NOTE_BLOCK));
            Object stateDefinition = CoreReflections.field$Block$StateDefinition.get(block);
            ImmutableList states = (ImmutableList)CoreReflections.field$StateDefinition$states.get(stateDefinition);
            CLIENT_SIDE_NOTE_BLOCKS.addAll((Collection<Object>)states);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to init vanilla note block", e);
        }
    }

    @Override
    protected void setVanillaBlockTags(Key id, List<String> tags) {
        Object block = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(id));
        this.clientBoundTags.put(FastNMS.INSTANCE.method$IdMap$getId(MBuiltInRegistries.BLOCK, block).orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(id) + " not found")), tags);
    }

    public boolean isPlaceSoundMissing(Object sound) {
        return this.missingPlaceSounds.contains(sound);
    }

    public boolean isBreakSoundMissing(Object sound) {
        return this.missingBreakSounds.contains(sound);
    }

    public boolean isHitSoundMissing(Object sound) {
        return this.missingHitSounds.contains(sound);
    }

    public boolean isStepSoundMissing(Object sound) {
        return this.missingStepSounds.contains(sound);
    }

    public boolean isInteractSoundMissing(Key blockType) {
        return this.missingInteractSoundBlocks.contains(blockType);
    }

    private void unfreezeRegistry() {
        try {
            CoreReflections.field$MappedRegistry$frozen.set(MBuiltInRegistries.BLOCK, false);
            CoreReflections.field$MappedRegistry$unregisteredIntrusiveHolders.set(MBuiltInRegistries.BLOCK, new IdentityHashMap());
        }
        catch (IllegalAccessException e) {
            this.plugin.logger().warn("Failed to unfreeze block registry", e);
        }
    }

    private void freezeRegistry() {
        try {
            CoreReflections.field$MappedRegistry$frozen.set(MBuiltInRegistries.BLOCK, true);
        }
        catch (IllegalAccessException e) {
            this.plugin.logger().warn("Failed to freeze block registry", e);
        }
    }

    private void deceiveBukkitRegistry() {
        try {
            Map magicMap = (Map)CraftBukkitReflections.field$CraftMagicNumbers$BLOCK_MATERIAL.get(null);
            for (DelegatingBlock customBlock : this.customBlocks) {
                magicMap.put(customBlock, Material.STONE);
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to deceive bukkit magic blocks", e);
        }
    }

    @Override
    protected boolean isVanillaBlock(Key id) {
        if (!id.namespace().equals("minecraft")) {
            return false;
        }
        if (id.value().equals("air")) {
            return true;
        }
        return FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.BLOCK, KeyUtils.toResourceLocation(id)) != MBlocks.AIR;
    }

    public boolean isBurnable(Object blockState) {
        Object blockOwner = BlockStateUtils.getBlockOwner(blockState);
        return this.igniteOdds.getOrDefault(blockOwner, 0) > 0;
    }

    @Override
    public int vanillaBlockStateCount() {
        return this.vanillaBlockStateCount;
    }

    @Override
    protected void processSounds() {
        Key previousId;
        HashSet<Object> affectedBlockSoundTypes = new HashSet<Object>();
        for (BlockStateWrapper vanillaBlockState : this.tempVisualBlockStatesInUse) {
            affectedBlockSoundTypes.add(FastNMS.INSTANCE.method$BlockBehaviour$BlockStateBase$getSoundType(vanillaBlockState.literalObject()));
        }
        HashSet<Object> placeSounds = new HashSet<Object>();
        HashSet<Object> breakSounds = new HashSet<Object>();
        HashSet<Object> stepSounds = new HashSet<Object>();
        HashSet<Object> hitSounds = new HashSet<Object>();
        for (Object soundType : affectedBlockSoundTypes) {
            placeSounds.add(FastNMS.INSTANCE.field$SoundEvent$location(FastNMS.INSTANCE.field$SoundType$placeSound(soundType)));
            breakSounds.add(FastNMS.INSTANCE.field$SoundEvent$location(FastNMS.INSTANCE.field$SoundType$breakSound(soundType)));
            stepSounds.add(FastNMS.INSTANCE.field$SoundEvent$location(FastNMS.INSTANCE.field$SoundType$stepSound(soundType)));
            hitSounds.add(FastNMS.INSTANCE.field$SoundEvent$location(FastNMS.INSTANCE.field$SoundType$hitSound(soundType)));
        }
        ImmutableMap.Builder soundReplacementBuilder = ImmutableMap.builder();
        for (Object e : placeSounds) {
            previousId = KeyUtils.resourceLocationToKey(e);
            soundReplacementBuilder.put((Object)previousId, (Object)Key.of(previousId.namespace(), "replaced." + previousId.value()));
        }
        for (Object e : breakSounds) {
            previousId = KeyUtils.resourceLocationToKey(e);
            soundReplacementBuilder.put((Object)previousId, (Object)Key.of(previousId.namespace(), "replaced." + previousId.value()));
        }
        for (Object e : stepSounds) {
            previousId = KeyUtils.resourceLocationToKey(e);
            soundReplacementBuilder.put((Object)previousId, (Object)Key.of(previousId.namespace(), "replaced." + previousId.value()));
        }
        for (Object e : hitSounds) {
            previousId = KeyUtils.resourceLocationToKey(e);
            soundReplacementBuilder.put((Object)previousId, (Object)Key.of(previousId.namespace(), "replaced." + previousId.value()));
        }
        this.missingPlaceSounds = placeSounds;
        this.missingBreakSounds = breakSounds;
        this.missingHitSounds = hitSounds;
        this.missingStepSounds = stepSounds;
        HashSet<Key> missingInteractSoundBlocks = new HashSet<Key>();
        block6: for (SoundSet soundSet : SoundSet.getAllSoundSets()) {
            for (Key block : soundSet.blocks()) {
                if (!this.tempVisualBlocksInUse.contains(block)) continue;
                Key openSound = soundSet.openSound();
                soundReplacementBuilder.put((Object)openSound, (Object)Key.of(openSound.namespace(), "replaced." + openSound.value()));
                Key closeSound = soundSet.closeSound();
                soundReplacementBuilder.put((Object)closeSound, (Object)Key.of(closeSound.namespace(), "replaced." + closeSound.value()));
                missingInteractSoundBlocks.addAll(soundSet.blocks());
                continue block6;
            }
        }
        this.missingInteractSoundBlocks = missingInteractSoundBlocks;
        this.soundReplacements = soundReplacementBuilder.buildKeepingLast();
    }

    @Override
    protected CustomBlock createCustomBlock(@NotNull Holder.Reference<CustomBlock> holder, @NotNull BlockStateVariantProvider variantProvider, @NotNull Map<EventTrigger, List<Function<PlayerOptionalContext>>> events, @Nullable LootTable<?> lootTable) {
        return new BukkitCustomBlock(holder, variantProvider, events, lootTable);
    }
}

