/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block;

import java.util.Optional;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.core.block.AbstractBlockStateWrapper;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.util.Key;

public class BukkitCustomBlockStateWrapper
extends AbstractBlockStateWrapper {
    public BukkitCustomBlockStateWrapper(Object blockState, int registryId) {
        super(blockState, registryId);
    }

    @Override
    public Key ownerId() {
        return this.getImmutableBlockState().map(state -> state.owner().value().id()).orElseGet(() -> BlockStateUtils.getBlockOwnerIdFromState(this.blockState));
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return this.getImmutableBlockState().map(state -> {
            Property<?> property = state.owner().value().getProperty(propertyName);
            if (property == null) {
                return null;
            }
            return state.getNullable(property);
        }).orElse(null);
    }

    @Override
    public BlockStateWrapper withProperty(String propertyName, String propertyValue) {
        Object value;
        Property<?> property;
        Optional<ImmutableBlockState> immutableBlockState = this.getImmutableBlockState();
        if (immutableBlockState.isPresent() && (property = immutableBlockState.get().owner().value().getProperty(propertyName)) != null && (value = property.valueByName(propertyValue)) != null) {
            return ImmutableBlockState.with(immutableBlockState.get(), property, value).customBlockState();
        }
        return this;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.getImmutableBlockState().map(state -> state.owner().value().getProperty(propertyName) != null).orElse(false);
    }

    @Override
    public String getAsString() {
        return this.getImmutableBlockState().map(ImmutableBlockState::toString).orElseGet(() -> BlockStateUtils.fromBlockData(this.blockState).getAsString());
    }

    public Optional<ImmutableBlockState> getImmutableBlockState() {
        return BlockStateUtils.getOptionalCustomBlockState(this.blockState);
    }
}

