/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MFluids;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UpdateOption;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviorFactory;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public class ConcretePowderBlockBehavior
extends BukkitBlockBehavior {
    public static final Factory FACTORY = new Factory();
    private final Key targetBlock;
    private Object defaultBlockState;
    private ImmutableBlockState defaultImmutableBlockState;

    public ConcretePowderBlockBehavior(CustomBlock block, Key targetBlock) {
        super(block);
        this.targetBlock = targetBlock;
    }

    public ImmutableBlockState defaultImmutableBlockState() {
        if (this.defaultImmutableBlockState == null) {
            this.getDefaultBlockState();
        }
        return this.defaultImmutableBlockState;
    }

    public Object getDefaultBlockState() {
        if (this.defaultBlockState != null) {
            return this.defaultBlockState;
        }
        Optional<CustomBlock> optionalCustomBlock = BukkitBlockManager.instance().blockById(this.targetBlock);
        if (optionalCustomBlock.isPresent()) {
            CustomBlock customBlock = optionalCustomBlock.get();
            this.defaultBlockState = customBlock.defaultState().customBlockState().literalObject();
            this.defaultImmutableBlockState = customBlock.defaultState();
        } else {
            CraftEngine.instance().logger().warn("Failed to create solid block " + String.valueOf(this.targetBlock) + " in ConcretePowderBlockBehavior");
            this.defaultBlockState = MBlocks.STONE$defaultState;
            this.defaultImmutableBlockState = EmptyBlock.STATE;
        }
        return this.defaultBlockState;
    }

    @Override
    public ImmutableBlockState updateStateForPlacement(BlockPlaceContext context, ImmutableBlockState state) {
        Object level = context.getLevel().serverWorld();
        Object blockPos = LocationUtils.toBlockPos(context.getClickedPos());
        try {
            Object previousState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, blockPos);
            if (!ConcretePowderBlockBehavior.shouldSolidify(level, blockPos, previousState)) {
                return super.updateStateForPlacement(context, state);
            }
            BlockState craftBlockState = (BlockState)CraftBukkitReflections.method$CraftBlockStates$getBlockState.invoke(null, level, blockPos);
            craftBlockState.setBlockData(BlockStateUtils.fromBlockData(this.getDefaultBlockState()));
            BlockFormEvent event = new BlockFormEvent(craftBlockState.getBlock(), craftBlockState);
            if (!EventUtils.fireAndCheckCancel((Event)event)) {
                return this.defaultImmutableBlockState();
            }
            return super.updateStateForPlacement(context, state);
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to update state for placement " + String.valueOf(context.getClickedPos()), e);
            return super.updateStateForPlacement(context, state);
        }
    }

    @Override
    public void onLand(Object thisBlock, Object[] args) throws Exception {
        Object world = args[0];
        Object blockPos = args[1];
        Object replaceableState = args[3];
        if (ConcretePowderBlockBehavior.shouldSolidify(world, blockPos, replaceableState)) {
            CraftBukkitReflections.method$CraftEventFactory$handleBlockFormEvent.invoke(null, world, blockPos, this.getDefaultBlockState(), UpdateOption.UPDATE_ALL.flags());
        }
    }

    @Override
    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        Object level = args[updateShape$level];
        Object pos = args[updateShape$blockPos];
        if (ConcretePowderBlockBehavior.touchesLiquid(level, pos)) {
            if (!CoreReflections.clazz$Level.isInstance(level)) {
                return this.getDefaultBlockState();
            }
            BlockState craftBlockState = (BlockState)CraftBukkitReflections.method$CraftBlockStates$getBlockState.invoke(null, level, pos);
            craftBlockState.setBlockData(BlockStateUtils.fromBlockData(this.getDefaultBlockState()));
            BlockFormEvent event = new BlockFormEvent(craftBlockState.getBlock(), craftBlockState);
            if (!EventUtils.fireAndCheckCancel((Event)event)) {
                return CraftBukkitReflections.method$CraftBlockState$getHandle.invoke((Object)craftBlockState, new Object[0]);
            }
        }
        return args[0];
    }

    private static boolean shouldSolidify(Object level, Object blockPos, Object blockState) throws ReflectiveOperationException {
        return ConcretePowderBlockBehavior.canSolidify(blockState) || ConcretePowderBlockBehavior.touchesLiquid(level, blockPos);
    }

    private static boolean canSolidify(Object state) throws ReflectiveOperationException {
        Object fluidState = CoreReflections.field$BlockStateBase$fluidState.get(state);
        if (fluidState == null) {
            return false;
        }
        Object fluidType = FastNMS.INSTANCE.method$FluidState$getType(fluidState);
        return fluidType == MFluids.WATER || fluidType == MFluids.FLOWING_WATER;
    }

    private static boolean touchesLiquid(Object level, Object pos) throws ReflectiveOperationException {
        boolean flag = false;
        Object mutablePos = CoreReflections.method$BlockPos$mutable.invoke(pos, new Object[0]);
        int j = Direction.values().length;
        for (int k = 0; k < j; ++k) {
            Object direction = CoreReflections.instance$Direction$values[k];
            Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, mutablePos);
            if (direction == CoreReflections.instance$Direction$DOWN && !ConcretePowderBlockBehavior.canSolidify(blockState)) continue;
            CoreReflections.method$MutableBlockPos$setWithOffset.invoke(mutablePos, pos, direction);
            blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(level, mutablePos);
            if (!ConcretePowderBlockBehavior.canSolidify(blockState) || ((Boolean)CoreReflections.method$BlockStateBase$isFaceSturdy.invoke(blockState, level, pos, FastNMS.INSTANCE.method$Direction$getOpposite(direction), CoreReflections.instance$SupportType$FULL)).booleanValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static class Factory
    implements BlockBehaviorFactory {
        @Override
        public BlockBehavior create(CustomBlock block, Map<String, Object> arguments) {
            String solidBlock = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("solid-block"), "warning.config.block.behavior.concrete.missing_solid");
            return new ConcretePowderBlockBehavior(block, Key.of(solidBlock));
        }
    }
}

