/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.behavior;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.BlockTags;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviorFactory;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.Tuple;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class DirectionalAttachedBlockBehavior
extends BukkitBlockBehavior {
    public static final Factory FACTORY = new Factory();
    private final Property<?> facingProperty;
    private final boolean isSixDirection;
    private final List<Object> tagsCanSurviveOn;
    private final Set<Object> blockStatesCanSurviveOn;
    private final Set<String> customBlocksCansSurviveOn;
    private final boolean blacklistMode;

    public DirectionalAttachedBlockBehavior(CustomBlock customBlock, Property<?> facingProperty, boolean isSixDirection, boolean blacklist, List<Object> tagsCanSurviveOn, Set<Object> blockStatesCanSurviveOn, Set<String> customBlocksCansSurviveOn) {
        super(customBlock);
        this.facingProperty = facingProperty;
        this.isSixDirection = isSixDirection;
        this.tagsCanSurviveOn = tagsCanSurviveOn;
        this.blockStatesCanSurviveOn = blockStatesCanSurviveOn;
        this.customBlocksCansSurviveOn = customBlocksCansSurviveOn;
        this.blacklistMode = blacklist;
    }

    @Override
    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        Direction direction;
        ImmutableBlockState state = BlockStateUtils.getOptionalCustomBlockState(args[0]).orElse(null);
        if (state == null) {
            return args[0];
        }
        DirectionalAttachedBlockBehavior behavior = state.behavior().getAs(DirectionalAttachedBlockBehavior.class).orElse(null);
        if (behavior == null) {
            return state;
        }
        boolean flag = this.isSixDirection ? (direction = DirectionUtils.fromNMSDirection(args[updateShape$direction]).opposite()) == state.get(behavior.facingProperty) : (direction = DirectionUtils.fromNMSDirection(args[updateShape$direction]).opposite().toHorizontalDirection()) == state.get(behavior.facingProperty);
        return flag && !FastNMS.INSTANCE.method$BlockStateBase$canSurvive(args[0], args[updateShape$level], args[updateShape$blockPos]) ? MBlocks.AIR$defaultState : args[0];
    }

    @Override
    public boolean canSurvive(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        ImmutableBlockState state = BlockStateUtils.getOptionalCustomBlockState(args[0]).orElse(null);
        if (state == null) {
            return false;
        }
        DirectionalAttachedBlockBehavior behavior = state.behavior().getAs(DirectionalAttachedBlockBehavior.class).orElse(null);
        if (behavior == null) {
            return false;
        }
        Direction direction = this.isSixDirection ? ((Direction)((Object)state.get(behavior.facingProperty))).opposite() : ((HorizontalDirection)((Object)state.get(behavior.facingProperty))).opposite().toDirection();
        BlockPos blockPos = LocationUtils.fromBlockPos(args[2]).relative(direction);
        Object nmsPos = LocationUtils.toBlockPos(blockPos);
        Object nmsState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(args[1], nmsPos);
        return FastNMS.INSTANCE.method$BlockStateBase$isFaceSturdy(nmsState, args[1], nmsPos, DirectionUtils.toNMSDirection(direction), CoreReflections.instance$SupportType$FULL) && this.mayPlaceOn(nmsState);
    }

    private boolean mayPlaceOn(Object state) {
        for (Object tag : this.tagsCanSurviveOn) {
            if (!FastNMS.INSTANCE.method$BlockStateBase$is(state, tag)) continue;
            return !this.blacklistMode;
        }
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(state);
        if (optionalCustomState.isEmpty()) {
            if (!this.blockStatesCanSurviveOn.isEmpty() && this.blockStatesCanSurviveOn.contains(state)) {
                return !this.blacklistMode;
            }
        } else {
            ImmutableBlockState belowCustomState = optionalCustomState.get();
            if (this.customBlocksCansSurviveOn.contains(belowCustomState.owner().value().id().toString())) {
                return !this.blacklistMode;
            }
            if (this.customBlocksCansSurviveOn.contains(belowCustomState.toString())) {
                return !this.blacklistMode;
            }
        }
        return this.blacklistMode;
    }

    @Override
    public ImmutableBlockState updateStateForPlacement(BlockPlaceContext context, ImmutableBlockState state) {
        DirectionalAttachedBlockBehavior behavior = state.behavior().getAs(DirectionalAttachedBlockBehavior.class).orElse(null);
        if (behavior == null) {
            return null;
        }
        World level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!(this.isSixDirection ? FastNMS.INSTANCE.method$BlockStateBase$canSurvive((state = state.with(behavior.facingProperty, direction.opposite())).customBlockState().literalObject(), level.serverWorld(), LocationUtils.toBlockPos(clickedPos)) : direction.axis().isHorizontal() && FastNMS.INSTANCE.method$BlockStateBase$canSurvive((state = state.with(behavior.facingProperty, direction.opposite().toHorizontalDirection())).customBlockState().literalObject(), level.serverWorld(), LocationUtils.toBlockPos(clickedPos)))) continue;
            return state;
        }
        return null;
    }

    public static Tuple<List<Object>, Set<Object>, Set<String>> readTagsAndState(Map<String, Object> arguments) {
        ArrayList<Object> mcTags = new ArrayList<Object>();
        for (String tag : MiscUtils.getAsStringList(arguments.getOrDefault("attached-block-tags", List.of()))) {
            mcTags.add(BlockTags.getOrCreate(Key.of(tag)));
        }
        HashSet<Object> mcBlocks = new HashSet<Object>();
        HashSet<String> customBlocks = new HashSet<String>();
        for (String blockStateStr : MiscUtils.getAsStringList(arguments.getOrDefault("attached-blocks", List.of()))) {
            int index = blockStateStr.indexOf(91);
            Key blockType = index != -1 ? Key.from(blockStateStr.substring(0, index)) : Key.from(blockStateStr);
            Material material = (Material)Registry.MATERIAL.get(new NamespacedKey(blockType.namespace(), blockType.value()));
            if (material != null) {
                if (index == -1) {
                    mcBlocks.addAll(BlockStateUtils.getPossibleBlockStates(blockType));
                    continue;
                }
                mcBlocks.add(BlockStateUtils.blockDataToBlockState(Bukkit.createBlockData((String)blockStateStr)));
                continue;
            }
            customBlocks.add(blockStateStr);
        }
        return new Tuple<List<Object>, Set<Object>, Set<String>>(mcTags, mcBlocks, customBlocks);
    }

    public static class Factory
    implements BlockBehaviorFactory {
        @Override
        public BlockBehavior create(CustomBlock block, Map<String, Object> arguments) {
            boolean isDirection;
            Property<?> facing = ResourceConfigUtils.requireNonNullOrThrow(block.getProperty("facing"), "warning.config.block.behavior.directional_attached.missing_facing");
            boolean isHorizontalDirection = facing.valueClass() == HorizontalDirection.class;
            boolean bl = isDirection = facing.valueClass() == Direction.class;
            if (!isHorizontalDirection && !isDirection) {
                throw new LocalizedResourceConfigException("warning.config.block.behavior.directional_attached.missing_facing", new String[0]);
            }
            Tuple<List<Object>, Set<Object>, Set<String>> tuple = DirectionalAttachedBlockBehavior.readTagsAndState(arguments);
            boolean blacklistMode = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("blacklist", true), "blacklist");
            return new DirectionalAttachedBlockBehavior(block, facing, isDirection, blacklistMode, tuple.left(), tuple.mid(), tuple.right());
        }
    }
}

