/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehavior;
import net.momirealms.craftengine.bukkit.entity.BukkitEntity;
import net.momirealms.craftengine.bukkit.entity.data.BaseEntityData;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.BlockBehaviorFactory;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;

public class FallingBlockBehavior
extends BukkitBlockBehavior {
    public static final Factory FACTORY = new Factory();
    private final float hurtAmount;
    private final int maxHurt;
    private final SoundData landSound;
    private final SoundData destroySound;

    public FallingBlockBehavior(CustomBlock block, float hurtAmount, int maxHurt, SoundData landSound, SoundData destroySound) {
        super(block);
        this.hurtAmount = hurtAmount;
        this.maxHurt = maxHurt;
        this.landSound = landSound;
        this.destroySound = destroySound;
    }

    @Override
    public void onPlace(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        Object world = args[1];
        Object blockPos = args[2];
        FastNMS.INSTANCE.method$ScheduledTickAccess$scheduleBlockTick(world, blockPos, thisBlock, 2);
    }

    @Override
    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        Object world = args[updateShape$level];
        Object blockPos = args[updateShape$blockPos];
        FastNMS.INSTANCE.method$ScheduledTickAccess$scheduleBlockTick(world, blockPos, thisBlock, 2);
        return args[0];
    }

    @Override
    public void tick(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        int z;
        Object world;
        Object dimension;
        int minY;
        Object blockPos = args[2];
        int y = FastNMS.INSTANCE.field$Vec3i$y(blockPos);
        if (y < (minY = CoreReflections.field$DimensionType$minY.getInt(dimension = CoreReflections.method$$LevelReader$dimensionType.invoke(world = args[1], new Object[0])))) {
            return;
        }
        int x = FastNMS.INSTANCE.field$Vec3i$x(blockPos);
        Object belowPos = LocationUtils.toBlockPos(x, y - 1, z = FastNMS.INSTANCE.field$Vec3i$z(blockPos));
        Object belowState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(world, belowPos);
        boolean isFree = (Boolean)CoreReflections.method$FallingBlock$isFree.invoke(null, belowState);
        if (!isFree) {
            return;
        }
        Object blockState = args[0];
        Object fallingBlockEntity = FastNMS.INSTANCE.createInjectedFallingBlockEntity(world, blockPos, blockState);
        if (this.hurtAmount > 0.0f && this.maxHurt > 0) {
            CoreReflections.method$FallingBlockEntity$setHurtsEntities.invoke(fallingBlockEntity, Float.valueOf(this.hurtAmount), this.maxHurt);
        }
    }

    @Override
    public void onBrokenAfterFall(Object thisBlock, Object[] args) throws Exception {
        Object level = args[0];
        Object fallingBlockEntity = args[2];
        BukkitEntity entity = BukkitAdaptors.adapt(FastNMS.INSTANCE.method$Entity$getBukkitEntity(fallingBlockEntity));
        if (!entity.getEntityData(BaseEntityData.Silent).booleanValue()) {
            Object blockState = CoreReflections.field$FallingBlockEntity$blockState.get(fallingBlockEntity);
            Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
            if (optionalCustomState.isEmpty()) {
                return;
            }
            BukkitWorld world = new BukkitWorld(FastNMS.INSTANCE.method$Level$getCraftWorld(level));
            WorldPosition position = new WorldPosition((World)world, CoreReflections.field$Entity$xo.getDouble(fallingBlockEntity), CoreReflections.field$Entity$yo.getDouble(fallingBlockEntity), CoreReflections.field$Entity$zo.getDouble(fallingBlockEntity));
            if (this.destroySound != null) {
                world.playBlockSound(position, this.destroySound);
            }
        }
    }

    @Override
    public void onLand(Object thisBlock, Object[] args) {
        Object fallingBlock = args[4];
        Object level = args[0];
        Object pos = args[1];
        BukkitEntity entity = BukkitAdaptors.adapt(FastNMS.INSTANCE.method$Entity$getBukkitEntity(fallingBlock));
        Object blockState = args[2];
        int stateId = BlockStateUtils.blockStateToId(blockState);
        ImmutableBlockState immutableBlockState = BukkitBlockManager.instance().getImmutableBlockState(stateId);
        if (immutableBlockState == null || immutableBlockState.isEmpty()) {
            return;
        }
        if (!entity.getEntityData(BaseEntityData.Silent).booleanValue()) {
            BukkitWorld world = new BukkitWorld(FastNMS.INSTANCE.method$Level$getCraftWorld(level));
            if (this.landSound != null) {
                world.playBlockSound(Vec3d.atCenterOf(LocationUtils.fromBlockPos(pos)), this.landSound);
            }
        }
    }

    public static class Factory
    implements BlockBehaviorFactory {
        @Override
        public BlockBehavior create(CustomBlock block, Map<String, Object> arguments) {
            float hurtAmount = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("hurt-amount", Float.valueOf(-1.0f)), "hurt-amount");
            int hurtMax = ResourceConfigUtils.getAsInt(arguments.getOrDefault("max-hurt", -1), "max-hurt");
            Map sounds = (Map)arguments.get("sounds");
            SoundData fallSound = null;
            SoundData destroySound = null;
            if (sounds != null) {
                fallSound = Optional.ofNullable(sounds.get("fall")).map(obj -> SoundData.create(obj, SoundData.SoundValue.FIXED_1, SoundData.SoundValue.ranged(0.9f, 1.0f))).orElse(null);
                destroySound = Optional.ofNullable(sounds.get("destroy")).map(obj -> SoundData.create(obj, SoundData.SoundValue.FIXED_1, SoundData.SoundValue.ranged(0.9f, 1.0f))).orElse(null);
            }
            return new FallingBlockBehavior(block, hurtAmount, hurtMax, fallSound, destroySound);
        }
    }
}

