/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.entity;

import net.momirealms.craftengine.bukkit.block.behavior.SimpleParticleBlockBehavior;
import net.momirealms.craftengine.bukkit.block.entity.AbstractAnimateTickBlockEntity;
import net.momirealms.craftengine.bukkit.block.entity.BukkitBlockEntityTypes;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.SimpleContext;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.particle.ParticleConfig;

public class SimpleParticleBlockEntity
extends AbstractAnimateTickBlockEntity {
    private final SimpleParticleBlockBehavior behavior;
    private final Context context = SimpleContext.of(ContextHolder.empty());

    public SimpleParticleBlockEntity(BlockPos pos, ImmutableBlockState blockState) {
        super(BukkitBlockEntityTypes.SIMPLE_PARTICLE, pos, blockState);
        this.behavior = blockState.behavior().getAs(SimpleParticleBlockBehavior.class).orElseThrow();
    }

    public void animateTick(ImmutableBlockState state, World level, BlockPos pos) {
        for (ParticleConfig particle : this.behavior.particles) {
            Vec3d location = new Vec3d((double)this.pos.x() + particle.x.getDouble(this.context), (double)this.pos.y() + particle.y.getDouble(this.context), (double)this.pos.z() + particle.z.getDouble(this.context));
            level.spawnParticle(location, particle.particleType, particle.count.getInt(this.context), particle.xOffset.getDouble(this.context), particle.yOffset.getDouble(this.context), particle.zOffset.getDouble(this.context), particle.speed.getDouble(this.context), particle.particleData, this.context);
        }
    }

    public static void tick(CEWorld ceWorld, BlockPos blockPos, ImmutableBlockState state, SimpleParticleBlockEntity particle) {
        ++particle.tickCount;
        if (particle.tickCount % particle.behavior.tickInterval != 0) {
            return;
        }
        particle.animateTick(state, ceWorld.world(), blockPos);
    }
}

