/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.compatibility.item.CustomFishingSource;
import net.momirealms.craftengine.bukkit.compatibility.item.HeadDatabaseSource;
import net.momirealms.craftengine.bukkit.compatibility.item.MMOItemsSource;
import net.momirealms.craftengine.bukkit.compatibility.item.MythicMobsSource;
import net.momirealms.craftengine.bukkit.compatibility.item.NeigeItemsSource;
import net.momirealms.craftengine.bukkit.compatibility.item.SXItemSource;
import net.momirealms.craftengine.bukkit.compatibility.item.SlimefunSource;
import net.momirealms.craftengine.bukkit.compatibility.item.ZaphkielSource;
import net.momirealms.craftengine.bukkit.compatibility.legacy.slimeworld.LegacySlimeFormatStorageAdaptor;
import net.momirealms.craftengine.bukkit.compatibility.leveler.AuraSkillsLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.AureliumSkillsLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.EcoJobsLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.EcoSkillsLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.JobsRebornLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.MMOCoreLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.leveler.McMMOLevelerProvider;
import net.momirealms.craftengine.bukkit.compatibility.model.bettermodel.BetterModelModel;
import net.momirealms.craftengine.bukkit.compatibility.model.bettermodel.BetterModelUtils;
import net.momirealms.craftengine.bukkit.compatibility.model.modelengine.ModelEngineModel;
import net.momirealms.craftengine.bukkit.compatibility.model.modelengine.ModelEngineUtils;
import net.momirealms.craftengine.bukkit.compatibility.mythicmobs.MythicItemDropListener;
import net.momirealms.craftengine.bukkit.compatibility.mythicmobs.MythicSkillHelper;
import net.momirealms.craftengine.bukkit.compatibility.papi.PlaceholderAPIUtils;
import net.momirealms.craftengine.bukkit.compatibility.permission.LuckPermsEventListeners;
import net.momirealms.craftengine.bukkit.compatibility.quickshop.QuickShopItemExpressionHandler;
import net.momirealms.craftengine.bukkit.compatibility.region.WorldGuardRegionCondition;
import net.momirealms.craftengine.bukkit.compatibility.skript.SkriptHook;
import net.momirealms.craftengine.bukkit.compatibility.slimeworld.SlimeFormatStorageAdaptor;
import net.momirealms.craftengine.bukkit.compatibility.viaversion.ViaVersionUtils;
import net.momirealms.craftengine.bukkit.compatibility.worldedit.WorldEditBlockRegister;
import net.momirealms.craftengine.bukkit.font.BukkitFontManager;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.entity.furniture.ExternalModel;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.loot.LootConditions;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.plugin.compatibility.CompatibilityManager;
import net.momirealms.craftengine.core.plugin.compatibility.LevelerProvider;
import net.momirealms.craftengine.core.plugin.compatibility.ModelProvider;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.condition.AlwaysFalseCondition;
import net.momirealms.craftengine.core.plugin.context.event.EventConditions;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BukkitCompatibilityManager
implements CompatibilityManager {
    private final BukkitCraftEngine plugin;
    private final Map<String, ModelProvider> modelProviders;
    private final Map<String, LevelerProvider> levelerProviders;
    private boolean hasPlaceholderAPI;

    public BukkitCompatibilityManager(BukkitCraftEngine plugin) {
        this.plugin = plugin;
        this.modelProviders = new HashMap<String, ModelProvider>(Map.of("ModelEngine", ModelEngineModel::new, "BetterModel", BetterModelModel::new));
        this.levelerProviders = new HashMap<String, LevelerProvider>();
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onEnable() {
        this.initSlimeWorldHook();
        if (this.isPluginEnabled("PlaceholderAPI")) {
            PlaceholderAPIUtils.registerExpansions(this.plugin);
            this.hasPlaceholderAPI = true;
            this.logHook("PlaceholderAPI");
        }
        if (this.isPluginEnabled("Skript")) {
            SkriptHook.register();
            this.logHook("Skript");
        }
        if (this.isPluginEnabled("FastAsyncWorldEdit")) {
            try {
                this.initFastAsyncWorldEditHook();
                this.logHook("FastAsyncWorldEdit");
            }
            catch (Exception e) {
                this.plugin.logger().warn("[Compatibility] Failed to initialize FastAsyncWorldEdit hook", e);
            }
        } else if (this.isPluginEnabled("WorldEdit")) {
            this.initWorldEditHook();
            this.logHook("WorldEdit");
        }
    }

    @Override
    public void onDelayedEnable() {
        this.initItemHooks();
        if (this.isPluginEnabled("LuckPerms")) {
            this.initLuckPermsHook();
            this.logHook("LuckPerms");
        }
        if (this.isPluginEnabled("AuraSkills")) {
            this.registerLevelerProvider("AuraSkills", new AuraSkillsLevelerProvider());
            this.logHook("AuraSkills");
        }
        if (this.isPluginEnabled("AureliumSkills")) {
            this.registerLevelerProvider("AureliumSkills", new AureliumSkillsLevelerProvider());
        }
        if (this.isPluginEnabled("McMMO")) {
            this.registerLevelerProvider("mcMMO", new McMMOLevelerProvider());
            this.logHook("McMMO");
        }
        if (this.isPluginEnabled("MMOCore")) {
            this.registerLevelerProvider("MMOCore", new MMOCoreLevelerProvider());
            this.logHook("MMOCore");
        }
        if (this.isPluginEnabled("Jobs")) {
            this.registerLevelerProvider("Jobs", new JobsRebornLevelerProvider());
            this.logHook("Jobs");
        }
        if (this.isPluginEnabled("EcoSkills")) {
            this.registerLevelerProvider("EcoSkills", new EcoSkillsLevelerProvider());
            this.logHook("EcoSkills");
        }
        if (this.isPluginEnabled("EcoJobs")) {
            this.registerLevelerProvider("EcoJobs", new EcoJobsLevelerProvider());
            this.logHook("EcoJobs");
        }
        if (this.isPluginEnabled("MythicMobs")) {
            BukkitItemManager.instance().registerExternalItemSource(new MythicMobsSource());
            new MythicItemDropListener(this.plugin);
            this.logHook("MythicMobs");
        }
        Key worldGuardRegion = Key.of("worldguard:region");
        if (this.isPluginEnabled("WorldGuard")) {
            EventConditions.register(worldGuardRegion, new WorldGuardRegionCondition.FactoryImpl<PlayerOptionalContext>());
            LootConditions.register(worldGuardRegion, new WorldGuardRegionCondition.FactoryImpl<LootContext>());
            this.logHook("WorldGuard");
        } else {
            EventConditions.register(worldGuardRegion, new AlwaysFalseCondition.FactoryImpl<PlayerOptionalContext>());
            LootConditions.register(worldGuardRegion, new AlwaysFalseCondition.FactoryImpl<LootContext>());
        }
        if (this.isPluginEnabled("BetterModel")) {
            BetterModelUtils.registerConstantBlockEntityRender();
            this.logHook("BetterModel");
        }
        if (this.isPluginEnabled("ModelEngine")) {
            ModelEngineUtils.registerConstantBlockEntityRender();
            this.logHook("ModelEngine");
        }
        if (this.isPluginEnabled("QuickShop-Hikari")) {
            new QuickShopItemExpressionHandler(this.plugin).register();
            this.logHook("QuickShop-Hikari");
        }
    }

    @Override
    public void executeMMSkill(String skill, float power, Player player) {
        MythicSkillHelper.execute(skill, power, player);
    }

    @Override
    public void registerLevelerProvider(String plugin, LevelerProvider provider) {
        this.levelerProviders.put(plugin, provider);
    }

    private void logHook(String plugin) {
        this.plugin.logger().info("[Compatibility] " + plugin + " hooked");
    }

    @Override
    public void addLevelerExp(Player player, String plugin, String target, double value) {
        Optional.ofNullable(this.levelerProviders.get(plugin)).ifPresentOrElse(leveler -> leveler.addExp(player, target, value), () -> this.plugin.logger().warn("[Compatibility] '" + plugin + "' leveler provider not found"));
    }

    @Override
    public int getLevel(Player player, String plugin, String target) {
        return Optional.ofNullable(this.levelerProviders.get(plugin)).map(leveler -> leveler.getLevel(player, target)).orElseGet(() -> {
            this.plugin.logger().warn("[Compatibility] '" + plugin + "' leveler provider not found");
            return 0;
        });
    }

    @Override
    public ExternalModel createModel(String plugin, String id) {
        return this.modelProviders.get(plugin).createModel(id);
    }

    @Override
    public int interactionToBaseEntity(int id) {
        return ModelEngineUtils.interactionToBaseEntity(id);
    }

    private void initLuckPermsHook() {
        new LuckPermsEventListeners(this.plugin.javaPlugin(), uuid -> {
            BukkitFontManager fontManager = this.plugin.fontManager();
            fontManager.refreshEmojiSuggestions((UUID)uuid);
        });
    }

    private void initSlimeWorldHook() {
        block6: {
            WorldManager worldManager = this.plugin.worldManager();
            if (VersionHelper.isOrAbove1_21_4()) {
                try {
                    Class.forName("com.infernalsuite.asp.api.AdvancedSlimePaperAPI");
                    SlimeFormatStorageAdaptor adaptor = new SlimeFormatStorageAdaptor(worldManager);
                    worldManager.setStorageAdaptor(adaptor);
                    Bukkit.getPluginManager().registerEvents((Listener)adaptor, (Plugin)this.plugin.javaPlugin());
                    this.logHook("AdvancedSlimePaper");
                }
                catch (ClassNotFoundException adaptor) {}
            } else {
                try {
                    Class.forName("com.infernalsuite.aswm.api.SlimePlugin");
                    LegacySlimeFormatStorageAdaptor adaptor = new LegacySlimeFormatStorageAdaptor(worldManager, 1);
                    worldManager.setStorageAdaptor(adaptor);
                    Bukkit.getPluginManager().registerEvents((Listener)adaptor, (Plugin)this.plugin.javaPlugin());
                    this.logHook("AdvancedSlimePaper");
                }
                catch (ClassNotFoundException ignored) {
                    if (!Bukkit.getPluginManager().isPluginEnabled("SlimeWorldPlugin")) break block6;
                    LegacySlimeFormatStorageAdaptor adaptor = new LegacySlimeFormatStorageAdaptor(worldManager, 2);
                    worldManager.setStorageAdaptor(adaptor);
                    Bukkit.getPluginManager().registerEvents((Listener)adaptor, (Plugin)this.plugin.javaPlugin());
                    this.logHook("AdvancedSlimePaper");
                }
            }
        }
    }

    private void initFastAsyncWorldEditHook() {
        String version;
        Plugin fastAsyncWorldEdit = Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit");
        String string = version = VersionHelper.isPaper() ? fastAsyncWorldEdit.getPluginMeta().getVersion() : fastAsyncWorldEdit.getDescription().getVersion();
        if (!this.fastAsyncWorldEditVersionCheck(version) && VersionHelper.isOrAbove1_20_3()) {
            this.plugin.logger().severe("");
            if (Locale.getDefault() == Locale.SIMPLIFIED_CHINESE) {
                this.plugin.logger().severe("[Compatibility] \u63d2\u4ef6\u9700\u8981\u66f4\u65b0 FastAsyncWorldEdit \u5230 2.13.0 \u6216\u66f4\u9ad8\u7248\u672c\uff0c\u4ee5\u83b7\u5f97\u66f4\u597d\u7684\u517c\u5bb9\u6027\u3002(\u5f53\u524d\u7248\u672c: " + version + ")");
                this.plugin.logger().severe("[Compatibility] \u8bf7\u524d\u5f80 https://ci.athion.net/job/FastAsyncWorldEdit/ \u4e0b\u8f7d\u6700\u65b0\u7248\u672c");
            } else {
                this.plugin.logger().severe("[Compatibility] Update FastAsyncWorldEdit to v2.13.0+ for better compatibility (Current: " + version + ")");
                this.plugin.logger().severe("[Compatibility] Download latest version: https://ci.athion.net/job/FastAsyncWorldEdit/");
            }
            this.plugin.logger().severe("");
        }
        new WorldEditBlockRegister(BukkitBlockManager.instance(), true);
    }

    private boolean fastAsyncWorldEditVersionCheck(String version) {
        String cleanVersion = version.split("-")[0];
        String[] parts = cleanVersion.split("\\.");
        int first = Integer.parseInt(parts[0]);
        int second = Integer.parseInt(parts[1]);
        return first >= 2 && second >= 13;
    }

    private void initWorldEditHook() {
        WorldEditBlockRegister weBlockRegister = new WorldEditBlockRegister(BukkitBlockManager.instance(), false);
        try {
            for (int i = 0; i < Config.serverSideBlocks(); ++i) {
                weBlockRegister.register(BlockManager.createCustomBlockKey(i));
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to initialize world edit hook", e);
        }
    }

    private void initItemHooks() {
        BukkitItemManager itemManager = BukkitItemManager.instance();
        if (this.isPluginEnabled("NeigeItems")) {
            itemManager.registerExternalItemSource(new NeigeItemsSource());
            this.logHook("NeigeItems");
        }
        if (this.isPluginEnabled("MMOItems")) {
            itemManager.registerExternalItemSource(new MMOItemsSource());
            this.logHook("MMOItems");
        }
        if (this.isPluginEnabled("CustomFishing")) {
            itemManager.registerExternalItemSource(new CustomFishingSource());
            this.logHook("CustomFishing");
        }
        if (this.isPluginEnabled("Zaphkiel")) {
            itemManager.registerExternalItemSource(new ZaphkielSource());
            this.logHook("Zaphkiel");
        }
        if (this.isPluginEnabled("HeadDatabase")) {
            itemManager.registerExternalItemSource(new HeadDatabaseSource());
            this.logHook("HeadDatabase");
        }
        if (this.isPluginEnabled("SX-Item")) {
            itemManager.registerExternalItemSource(new SXItemSource());
            this.logHook("SX-Item");
        }
        if (this.isPluginEnabled("Slimefun")) {
            itemManager.registerExternalItemSource(new SlimefunSource());
            this.logHook("Slimefun");
        }
    }

    private Plugin getPlugin(String name) {
        return Bukkit.getPluginManager().getPlugin(name);
    }

    @Override
    public boolean hasPlaceholderAPI() {
        return this.hasPlaceholderAPI;
    }

    @Override
    public boolean isPluginEnabled(String plugin) {
        return Bukkit.getPluginManager().isPluginEnabled(plugin);
    }

    @Override
    public boolean hasPlugin(String plugin) {
        return Bukkit.getPluginManager().getPlugin(plugin) != null;
    }

    @Override
    public String parse(Player player, String text) {
        return PlaceholderAPIUtils.parse((OfflinePlayer)((org.bukkit.entity.Player)player.platformPlayer()), text);
    }

    @Override
    public String parse(Player player1, Player player2, String text) {
        return PlaceholderAPIUtils.parse((org.bukkit.entity.Player)player1.platformPlayer(), (org.bukkit.entity.Player)player2.platformPlayer(), text);
    }

    @Override
    public int getPlayerProtocolVersion(UUID uuid) {
        return ViaVersionUtils.getPlayerProtocolVersion(uuid);
    }
}

