/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.legacy.slimeworld;

import com.flowpowered.nbt.ByteArrayTag;
import com.flowpowered.nbt.Tag;
import com.infernalsuite.aswm.api.world.SlimeChunk;
import com.infernalsuite.aswm.api.world.SlimeWorld;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.serialization.DefaultChunkSerializer;
import net.momirealms.craftengine.core.world.chunk.storage.WorldDataStorage;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;
import org.jetbrains.annotations.NotNull;

public class LegacySlimeWorldDataStorage
implements WorldDataStorage {
    private final WeakReference<SlimeWorld> slimeWorld;

    public LegacySlimeWorldDataStorage(SlimeWorld slimeWorld) {
        this.slimeWorld = new WeakReference<SlimeWorld>(slimeWorld);
    }

    public SlimeWorld getWorld() {
        return (SlimeWorld)this.slimeWorld.get();
    }

    @Override
    @NotNull
    public CEChunk readChunkAt(@NotNull CEWorld world, @NotNull ChunkPos pos) {
        SlimeChunk slimeChunk = this.getWorld().getChunk(pos.x, pos.z);
        if (slimeChunk == null) {
            return new CEChunk(world, pos);
        }
        Optional tag = slimeChunk.getExtraData().getAsByteArrayTag("craftengine");
        if (tag.isEmpty()) {
            return new CEChunk(world, pos);
        }
        try {
            CompoundTag compoundTag = NBT.fromBytes(((ByteArrayTag)tag.get()).getValue());
            if (compoundTag == null) {
                return new CEChunk(world, pos);
            }
            return DefaultChunkSerializer.deserialize(world, pos, compoundTag);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read chunk tag from slime world. " + String.valueOf(pos), e);
        }
    }

    @Override
    public void writeChunkAt(@NotNull ChunkPos pos, @NotNull CEChunk chunk) {
        SlimeChunk slimeChunk = this.getWorld().getChunk(pos.x, pos.z);
        if (slimeChunk == null) {
            return;
        }
        CompoundTag nbt = DefaultChunkSerializer.serialize(chunk);
        if (nbt == null) {
            slimeChunk.getExtraData().getValue().remove((Object)"craftengine");
        } else {
            try {
                slimeChunk.getExtraData().getValue().put("craftengine", (Tag)new ByteArrayTag("craftengine", NBT.toBytes(nbt)));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write chunk tag to slime world. " + String.valueOf(pos), e);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

