/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.model.modelengine;

import java.util.Map;
import net.momirealms.craftengine.bukkit.compatibility.model.modelengine.ModelEngineBlockEntityElement;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElement;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfig;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfigFactory;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import org.joml.Vector3f;

public class ModelEngineBlockEntityElementConfig
implements BlockEntityElementConfig<ModelEngineBlockEntityElement> {
    private final Vector3f position;
    private final float yaw;
    private final float pitch;
    private final String model;

    public ModelEngineBlockEntityElementConfig(String model, Vector3f position, float yaw, float pitch) {
        this.pitch = pitch;
        this.position = position;
        this.yaw = yaw;
        this.model = model;
    }

    public String model() {
        return this.model;
    }

    public float pitch() {
        return this.pitch;
    }

    public Vector3f position() {
        return this.position;
    }

    public float yaw() {
        return this.yaw;
    }

    @Override
    public ModelEngineBlockEntityElement create(World world, BlockPos pos) {
        return new ModelEngineBlockEntityElement(world, pos, this);
    }

    public static class Factory
    implements BlockEntityElementConfigFactory {
        @Override
        public <E extends BlockEntityElement> BlockEntityElementConfig<E> create(Map<String, Object> arguments) {
            String model = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("model"), "warning.config.block.state.entity_renderer.model_engine.missing_model");
            return new ModelEngineBlockEntityElementConfig(model, ResourceConfigUtils.getAsVector3f(arguments.getOrDefault("position", Float.valueOf(0.5f)), "position"), ResourceConfigUtils.getAsFloat(arguments.getOrDefault("yaw", Float.valueOf(0.0f)), "yaw"), ResourceConfigUtils.getAsFloat(arguments.getOrDefault("pitch", Float.valueOf(0.0f)), "pitch"));
        }
    }
}

