/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.event;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import net.momirealms.craftengine.bukkit.api.event.CraftEngineReloadEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="On CraftEngine Reload")
@Description(value={"Fires when CraftEngine reload"})
@Since(value={"1.0"})
public class EvtCraftEngineReload
extends SkriptEvent {
    private boolean onlyCheckFirstCall;
    private static boolean hasBeenCalled = false;

    public static void register() {
        Skript.registerEvent((String)"CraftEngine Loaded", EvtCraftEngineReload.class, CraftEngineReloadEvent.class, (String[])new String[]{"(ce|craft(engine|-engine)) [first] (load[ed]|reload)"}).description(new String[]{"Called when Craft-Engine resource loaded."});
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        String expr = parser.expr;
        this.onlyCheckFirstCall = expr.contains("first");
        return true;
    }

    public boolean check(Event event) {
        if (!(event instanceof CraftEngineReloadEvent)) {
            return false;
        }
        CraftEngineReloadEvent reloadEvent = (CraftEngineReloadEvent)event;
        if (this.onlyCheckFirstCall) {
            if (hasBeenCalled) {
                return false;
            }
            hasBeenCalled = true;
            return true;
        }
        hasBeenCalled = true;
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.onlyCheckFirstCall ? "craftengine first load" : "craftengine reload";
    }

    public static boolean hasBeenLoad() {
        return hasBeenCalled;
    }
}

