/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="CraftEngine Item ID")
@Description(value={"Get CraftEngine item id."})
@Since(value={"1.0"})
public class ExprItemCustomItemID
extends SimpleExpression<String> {
    private Expression<?> itemStackExpr;

    public static void register() {
        Skript.registerExpression(ExprItemCustomItemID.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(custom|ce|craft-engine) item [namespace] id of %itemstack/itemtype/slot%", "%itemstack/itemtype/slot%'[s] (custom|ce|craft-engine) item [namespace] id"});
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemStackExpr = exprs[0];
        return true;
    }

    protected String[] get(Event event) {
        Object single = this.itemStackExpr.getSingle(event);
        String result = null;
        if (single instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)single;
            result = Optional.of(itemStack).map(this::getCraftEngineItemId).orElse(null);
        } else if (single instanceof ItemType) {
            ItemType itemType = (ItemType)single;
            result = Optional.ofNullable(((ItemData)itemType.getTypes().getFirst()).getStack()).map(this::getCraftEngineItemId).orElse(null);
        } else if (single instanceof Slot) {
            Slot slot = (Slot)single;
            result = Optional.ofNullable(slot.getItem()).map(this::getCraftEngineItemId).orElse(null);
        }
        return new String[]{result};
    }

    private String getCraftEngineItemId(ItemStack itemStack) {
        return Optional.ofNullable(CraftEngineItems.getCustomItemId(itemStack)).map(Key::asString).orElse(null);
    }

    public boolean isSingle() {
        return this.itemStackExpr.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "craft-engine item ID of " + this.itemStackExpr.toString(event, debug);
    }
}

