/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.worldedit;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitBlockRegistry;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.stream.Stream;
import net.momirealms.craftengine.bukkit.compatibility.worldedit.FastAsyncWorldEditDelegate;
import net.momirealms.craftengine.core.block.AbstractBlockManager;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.parser.BlockStateParser;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import org.bukkit.Material;

public class WorldEditBlockRegister {
    private final Field field$BlockType$blockMaterial = ReflectionUtils.getDeclaredField(BlockType.class, "blockMaterial");
    private final AbstractBlockManager manager;
    private final boolean isFAWE;

    public WorldEditBlockRegister(AbstractBlockManager manager, boolean isFAWE) {
        this.manager = manager;
        this.isFAWE = isFAWE;
        CEBlockParser blockParser = new CEBlockParser(WorldEdit.getInstance());
        WorldEdit.getInstance().getBlockFactory().register((InputParser)blockParser);
        if (isFAWE) {
            FastAsyncWorldEditDelegate.init();
        }
    }

    public void register(Key id) throws ReflectiveOperationException {
        BlockType blockType = new BlockType(id.toString(), blockState -> blockState);
        this.field$BlockType$blockMaterial.set(blockType, LazyReference.from(() -> new BukkitBlockRegistry.BukkitBlockMaterial(null, Material.STONE)));
        BlockType.REGISTRY.register(id.toString(), (Keyed)blockType);
    }

    private final class CEBlockParser
    extends InputParser<BaseBlock> {
        private CEBlockParser(WorldEdit worldEdit) {
            super(worldEdit);
        }

        public Stream<String> getSuggestions(String input) {
            Set<String> namespacesInUse = WorldEditBlockRegister.this.manager.namespacesInUse();
            if (input.isEmpty() || input.equals(":")) {
                return namespacesInUse.stream().map(namespace -> namespace + ":");
            }
            if (input.startsWith(":")) {
                String term = input.substring(1);
                return BlockStateParser.fillSuggestions(term).stream();
            }
            if (!input.contains(":")) {
                String lowerSearch = input.toLowerCase();
                return Stream.concat(namespacesInUse.stream().filter(n -> n.startsWith(lowerSearch)).map(n -> n + ":"), BlockStateParser.fillSuggestions(input).stream());
            }
            return BlockStateParser.fillSuggestions(input).stream();
        }

        public BaseBlock parseFromInput(String input, ParserContext context) {
            String namespace;
            int index;
            if (WorldEditBlockRegister.this.isFAWE && input.charAt((index = input.indexOf("[")) + 1) == ']') {
                return null;
            }
            int colonIndex = input.indexOf(58);
            if (colonIndex == -1) {
                return null;
            }
            Set<String> namespacesInUse = WorldEditBlockRegister.this.manager.namespacesInUse();
            if (!namespacesInUse.contains(namespace = input.substring(0, colonIndex))) {
                return null;
            }
            ImmutableBlockState state = BlockStateParser.deserialize(input);
            if (state == null) {
                return null;
            }
            try {
                String id = state.customBlockState().literalObject().toString();
                int first = id.indexOf(123);
                int last = id.indexOf(125);
                if (first != -1 && last != -1 && last > first) {
                    String blockId = id.substring(first + 1, last);
                    BlockType blockType = BlockTypes.get((String)blockId);
                    if (blockType == null) {
                        return null;
                    }
                    return blockType.getDefaultState().toBaseBlock();
                }
                throw new IllegalArgumentException("Invalid block ID format: " + id);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
    }
}

