/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity;

import java.lang.ref.WeakReference;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.entity.AbstractEntity;
import net.momirealms.craftengine.core.entity.data.EntityData;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.World;
import org.bukkit.entity.Entity;

public class BukkitEntity
extends AbstractEntity {
    private final WeakReference<Entity> entity;

    public BukkitEntity(Entity entity) {
        this.entity = new WeakReference<Entity>(entity);
    }

    @Override
    public double x() {
        return this.platformEntity().getX();
    }

    @Override
    public double y() {
        return this.platformEntity().getY();
    }

    @Override
    public double z() {
        return this.platformEntity().getZ();
    }

    @Override
    public void tick() {
    }

    @Override
    public int entityID() {
        return this.platformEntity().getEntityId();
    }

    @Override
    public float xRot() {
        return this.platformEntity().getYaw();
    }

    @Override
    public float yRot() {
        return this.platformEntity().getPitch();
    }

    @Override
    public World world() {
        return new BukkitWorld(this.platformEntity().getWorld());
    }

    @Override
    public Direction getDirection() {
        return Direction.NORTH;
    }

    public Entity platformEntity() {
        return (Entity)this.entity.get();
    }

    @Override
    public Object serverEntity() {
        return FastNMS.INSTANCE.method$CraftEntity$getHandle(this.platformEntity());
    }

    @Override
    public Key type() {
        return EntityUtils.getEntityType(this.platformEntity());
    }

    @Override
    public String name() {
        return this.platformEntity().getName();
    }

    @Override
    public UUID uuid() {
        return this.platformEntity().getUniqueId();
    }

    @Override
    public Object entityData() {
        return FastNMS.INSTANCE.field$Entity$entityData(this.serverEntity());
    }

    @Override
    public <T> T getEntityData(EntityData<T> data) {
        return (T)FastNMS.INSTANCE.method$SynchedEntityData$get(this.entityData(), data.entityDataAccessor());
    }

    @Override
    public <T> void setEntityData(EntityData<T> data, T value, boolean force) {
        FastNMS.INSTANCE.method$SynchedEntityData$set(this.entityData(), data.entityDataAccessor(), value, force);
    }
}

