/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity.furniture;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitCustomFurniture;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurniture;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureElement;
import net.momirealms.craftengine.bukkit.entity.furniture.DismountListener1_20;
import net.momirealms.craftengine.bukkit.entity.furniture.DismountListener1_20_3;
import net.momirealms.craftengine.bukkit.entity.furniture.FurnitureEventListener;
import net.momirealms.craftengine.bukkit.entity.furniture.hitbox.InteractionHitBox;
import net.momirealms.craftengine.bukkit.nms.CollisionEntity;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.network.handler.FurniturePacketHandler;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MEntityTypes;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.core.entity.furniture.AbstractFurnitureManager;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.entity.furniture.Collider;
import net.momirealms.craftengine.core.entity.furniture.ColliderType;
import net.momirealms.craftengine.core.entity.furniture.CustomFurniture;
import net.momirealms.craftengine.core.entity.furniture.Furniture;
import net.momirealms.craftengine.core.entity.furniture.FurnitureElement;
import net.momirealms.craftengine.core.entity.furniture.FurnitureExtraData;
import net.momirealms.craftengine.core.entity.furniture.FurnitureManager;
import net.momirealms.craftengine.core.entity.furniture.HitBox;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BukkitFurnitureManager
extends AbstractFurnitureManager {
    public static final NamespacedKey FURNITURE_KEY = KeyUtils.toNamespacedKey(FurnitureManager.FURNITURE_KEY);
    public static final NamespacedKey FURNITURE_EXTRA_DATA_KEY = KeyUtils.toNamespacedKey(FurnitureManager.FURNITURE_EXTRA_DATA_KEY);
    public static final NamespacedKey FURNITURE_SEAT_BASE_ENTITY_KEY = KeyUtils.toNamespacedKey(FurnitureManager.FURNITURE_SEAT_BASE_ENTITY_KEY);
    public static final NamespacedKey FURNITURE_SEAT_VECTOR_3F_KEY = KeyUtils.toNamespacedKey(FurnitureManager.FURNITURE_SEAT_VECTOR_3F_KEY);
    public static final NamespacedKey FURNITURE_COLLISION = KeyUtils.toNamespacedKey(FurnitureManager.FURNITURE_COLLISION);
    public static Class<?> COLLISION_ENTITY_CLASS = Interaction.class;
    public static Object NMS_COLLISION_ENTITY_TYPE = MEntityTypes.INTERACTION;
    public static ColliderType COLLISION_ENTITY_TYPE = ColliderType.INTERACTION;
    private static BukkitFurnitureManager instance;
    private final BukkitCraftEngine plugin;
    private final Map<Integer, BukkitFurniture> furnitureByRealEntityId = new ConcurrentHashMap<Integer, BukkitFurniture>(256, 0.5f);
    private final Map<Integer, BukkitFurniture> furnitureByEntityId = new ConcurrentHashMap<Integer, BukkitFurniture>(512, 0.5f);
    private final Listener dismountListener;
    private final FurnitureEventListener furnitureEventListener;

    public static BukkitFurnitureManager instance() {
        return instance;
    }

    public BukkitFurnitureManager(BukkitCraftEngine plugin) {
        super(plugin);
        instance = this;
        this.plugin = plugin;
        this.furnitureEventListener = new FurnitureEventListener(this);
        this.dismountListener = VersionHelper.isOrAbove1_20_3() ? new DismountListener1_20_3(this) : new DismountListener1_20(this::handleDismount);
    }

    @Override
    public Furniture place(WorldPosition position, CustomFurniture furniture, FurnitureExtraData extraData, boolean playSound) {
        return this.place(LocationUtils.toLocation(position), furniture, extraData, playSound);
    }

    public BukkitFurniture place(Location location, CustomFurniture furniture, FurnitureExtraData extraData, boolean playSound) {
        Optional<AnchorType> optionalAnchorType = extraData.anchorType();
        if (optionalAnchorType.isEmpty() || !furniture.isAllowedPlacement(optionalAnchorType.get())) {
            extraData.anchorType(furniture.getAnyAnchorType());
        }
        Entity furnitureEntity = EntityUtils.spawnEntity(location.getWorld(), location, EntityType.ITEM_DISPLAY, entity -> {
            ItemDisplay display = (ItemDisplay)entity;
            display.getPersistentDataContainer().set(FURNITURE_KEY, PersistentDataType.STRING, (Object)furniture.id().toString());
            try {
                display.getPersistentDataContainer().set(FURNITURE_EXTRA_DATA_KEY, PersistentDataType.BYTE_ARRAY, (Object)extraData.toBytes());
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to set furniture PDC for " + furniture.id().toString(), e);
            }
            this.handleBaseEntityLoadEarly(display);
        });
        if (playSound) {
            SoundData data = furniture.settings().sounds().placeSound();
            location.getWorld().playSound(location, data.id().toString(), SoundCategory.BLOCKS, ((Float)data.volume().get()).floatValue(), ((Float)data.pitch().get()).floatValue());
        }
        return this.loadedFurnitureByRealEntityId(furnitureEntity.getEntityId());
    }

    @Override
    public void delayedInit() {
        COLLISION_ENTITY_CLASS = Config.colliderType() == ColliderType.INTERACTION ? Interaction.class : Boat.class;
        NMS_COLLISION_ENTITY_TYPE = Config.colliderType() == ColliderType.INTERACTION ? MEntityTypes.INTERACTION : MEntityTypes.OAK_BOAT;
        COLLISION_ENTITY_TYPE = Config.colliderType();
        Bukkit.getPluginManager().registerEvents(this.dismountListener, (Plugin)this.plugin.javaPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.furnitureEventListener, (Plugin)this.plugin.javaPlugin());
        if (VersionHelper.isFolia()) {
            BiConsumer<Entity, Runnable> taskExecutor = (entity, runnable) -> entity.getScheduler().run((Plugin)this.plugin.javaPlugin(), t -> runnable.run(), () -> {});
            for (World world : Bukkit.getWorlds()) {
                List entities = world.getEntities();
                for (Entity entity2 : entities) {
                    if (entity2 instanceof ItemDisplay) {
                        ItemDisplay display = (ItemDisplay)entity2;
                        taskExecutor.accept(entity2, () -> this.handleBaseEntityLoadEarly(display));
                        continue;
                    }
                    if (entity2 instanceof Interaction) {
                        Interaction interaction = (Interaction)entity2;
                        taskExecutor.accept(entity2, () -> this.handleCollisionEntityLoadOnEntitiesLoad((Entity)interaction));
                        continue;
                    }
                    if (!(entity2 instanceof Boat)) continue;
                    Boat boat = (Boat)entity2;
                    taskExecutor.accept(entity2, () -> this.handleCollisionEntityLoadOnEntitiesLoad((Entity)boat));
                }
            }
        } else {
            for (World world : Bukkit.getWorlds()) {
                List entities = world.getEntities();
                for (Entity entity3 : entities) {
                    if (entity3 instanceof ItemDisplay) {
                        ItemDisplay display = (ItemDisplay)entity3;
                        this.handleBaseEntityLoadEarly(display);
                        continue;
                    }
                    if (entity3 instanceof Interaction) {
                        Interaction interaction = (Interaction)entity3;
                        this.handleCollisionEntityLoadOnEntitiesLoad((Entity)interaction);
                        continue;
                    }
                    if (!(entity3 instanceof Boat)) continue;
                    Boat boat = (Boat)entity3;
                    this.handleCollisionEntityLoadOnEntitiesLoad((Entity)boat);
                }
            }
        }
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this.dismountListener);
        HandlerList.unregisterAll((Listener)this.furnitureEventListener);
        this.unload();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Entity vehicle = player.getVehicle();
            if (vehicle == null) continue;
            this.tryLeavingSeat(player, vehicle);
        }
    }

    @Override
    public boolean isFurnitureRealEntity(int entityId) {
        return this.furnitureByRealEntityId.containsKey(entityId);
    }

    @Override
    @Nullable
    public BukkitFurniture loadedFurnitureByRealEntityId(int entityId) {
        return this.furnitureByRealEntityId.get(entityId);
    }

    @Override
    @Nullable
    public BukkitFurniture loadedFurnitureByEntityId(int entityId) {
        return this.furnitureByEntityId.get(entityId);
    }

    @Override
    protected CustomFurniture.Builder furnitureBuilder() {
        return BukkitCustomFurniture.builder();
    }

    @Override
    protected FurnitureElement.Builder furnitureElementBuilder() {
        return BukkitFurnitureElement.builder();
    }

    protected void handleBaseEntityUnload(Entity entity) {
        int id = entity.getEntityId();
        BukkitFurniture furniture = this.furnitureByRealEntityId.remove(id);
        if (furniture != null) {
            Location location = entity.getLocation();
            boolean isPreventing = FastNMS.INSTANCE.method$ServerLevel$isPreventingStatusUpdates(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(location.getWorld()), location.getBlockX() >> 4, location.getBlockZ() >> 4);
            if (!isPreventing) {
                furniture.destroySeats();
            }
            for (int sub : furniture.entityIds()) {
                this.furnitureByEntityId.remove(sub);
            }
        }
    }

    protected void handleCollisionEntityUnload(Entity entity) {
        int id = entity.getEntityId();
        this.furnitureByRealEntityId.remove(id);
    }

    protected void handleBaseEntityLoadLate(ItemDisplay display, int depth) {
        String id = (String)display.getPersistentDataContainer().get(FURNITURE_KEY, PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        Key key = Key.of(id);
        Optional<CustomFurniture> optionalFurniture = this.furnitureById(key);
        if (optionalFurniture.isEmpty()) {
            return;
        }
        CustomFurniture customFurniture = optionalFurniture.get();
        BukkitFurniture previous = this.furnitureByRealEntityId.get(display.getEntityId());
        if (previous != null) {
            return;
        }
        Location location = display.getLocation();
        boolean above1_20_1 = VersionHelper.isOrAbove1_20_2();
        boolean preventChange = FastNMS.INSTANCE.method$ServerLevel$isPreventingStatusUpdates(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(location.getWorld()), location.getBlockX() >> 4, location.getBlockZ() >> 4);
        if (above1_20_1) {
            if (!preventChange) {
                BukkitFurniture furniture = this.addNewFurniture(display, customFurniture);
                furniture.initializeColliders();
                for (Player player : display.getTrackedPlayers()) {
                    BukkitAdaptors.adapt(player).entityPacketHandlers().computeIfAbsent(furniture.baseEntityId(), k -> new FurniturePacketHandler(furniture.fakeEntityIds()));
                    this.plugin.networkManager().sendPacket(BukkitAdaptors.adapt(player), furniture.spawnPacket(player));
                }
            }
        } else {
            BukkitFurniture furniture = this.addNewFurniture(display, customFurniture);
            for (Player player : display.getTrackedPlayers()) {
                BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
                serverPlayer.entityPacketHandlers().computeIfAbsent(furniture.baseEntityId(), k -> new FurniturePacketHandler(furniture.fakeEntityIds()));
                this.plugin.networkManager().sendPacket(serverPlayer, furniture.spawnPacket(player));
            }
            if (preventChange) {
                this.plugin.scheduler().sync().runLater(furniture::initializeColliders, 1L, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
            } else {
                furniture.initializeColliders();
            }
        }
        if (depth > 2) {
            return;
        }
        this.plugin.scheduler().sync().runLater(() -> this.handleBaseEntityLoadLate(display, depth + 1), 1L, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    protected void handleCollisionEntityLoadLate(Entity entity, int depth) {
        if (FastNMS.INSTANCE.method$CraftEntity$getHandle(entity) instanceof CollisionEntity) {
            return;
        }
        Byte flag = (Byte)entity.getPersistentDataContainer().get(FURNITURE_COLLISION, PersistentDataType.BYTE);
        if (flag == null || flag != 1) {
            return;
        }
        Location location = entity.getLocation();
        World world = location.getWorld();
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        if (!FastNMS.INSTANCE.method$ServerLevel$isPreventingStatusUpdates(FastNMS.INSTANCE.field$CraftWorld$ServerLevel(world), chunkX, chunkZ)) {
            entity.remove();
            return;
        }
        if (depth > 2) {
            return;
        }
        this.plugin.scheduler().sync().runLater(() -> this.handleCollisionEntityLoadLate(entity, depth + 1), 1L, world, chunkX, chunkZ);
    }

    public void handleBaseEntityLoadEarly(ItemDisplay display) {
        Key key;
        Optional<CustomFurniture> optionalFurniture;
        String mapped;
        String id = (String)display.getPersistentDataContainer().get(FURNITURE_KEY, PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        if (Config.handleInvalidFurniture() && (mapped = Config.furnitureMappings().get(id)) != null) {
            if (mapped.isEmpty()) {
                display.remove();
                return;
            }
            id = mapped;
            display.getPersistentDataContainer().set(FURNITURE_KEY, PersistentDataType.STRING, (Object)id);
        }
        if ((optionalFurniture = this.furnitureById(key = Key.of(id))).isPresent()) {
            CustomFurniture customFurniture = optionalFurniture.get();
            BukkitFurniture previous = this.furnitureByRealEntityId.get(display.getEntityId());
            if (previous != null) {
                return;
            }
            BukkitFurniture furniture = this.addNewFurniture(display, customFurniture);
            furniture.initializeColliders();
        }
    }

    public void handleCollisionEntityLoadOnEntitiesLoad(Entity collisionEntity) {
        if (FastNMS.INSTANCE.method$CraftEntity$getHandle(collisionEntity) instanceof CollisionEntity) {
            collisionEntity.remove();
            return;
        }
        Byte flag = (Byte)collisionEntity.getPersistentDataContainer().get(FURNITURE_COLLISION, PersistentDataType.BYTE);
        if (flag == null || flag != 1) {
            return;
        }
        collisionEntity.remove();
    }

    private FurnitureExtraData getFurnitureExtraData(Entity baseEntity) throws IOException {
        byte[] extraData = (byte[])baseEntity.getPersistentDataContainer().get(FURNITURE_EXTRA_DATA_KEY, PersistentDataType.BYTE_ARRAY);
        if (extraData == null) {
            return FurnitureExtraData.builder().build();
        }
        return FurnitureExtraData.fromBytes(extraData);
    }

    private synchronized BukkitFurniture addNewFurniture(ItemDisplay display, CustomFurniture furniture) {
        FurnitureExtraData extraData;
        try {
            extraData = this.getFurnitureExtraData((Entity)display);
        }
        catch (IOException e) {
            extraData = FurnitureExtraData.builder().build();
            this.plugin.logger().warn("Furniture extra data could not be loaded", e);
        }
        BukkitFurniture bukkitFurniture = new BukkitFurniture((Entity)display, furniture, extraData);
        this.furnitureByRealEntityId.put(bukkitFurniture.baseEntityId(), bukkitFurniture);
        Collider[] colliderArray = bukkitFurniture.entityIds().iterator();
        while (colliderArray.hasNext()) {
            int entityId = colliderArray.next();
            this.furnitureByEntityId.put(entityId, bukkitFurniture);
        }
        for (Collider collisionEntity : bukkitFurniture.collisionEntities()) {
            int collisionEntityId = FastNMS.INSTANCE.method$Entity$getId(collisionEntity.handle());
            this.furnitureByRealEntityId.put(collisionEntityId, bukkitFurniture);
        }
        return bukkitFurniture;
    }

    @Override
    protected HitBox defaultHitBox() {
        return InteractionHitBox.DEFAULT;
    }

    protected void handleDismount(Player player, Entity entity) {
        if (!this.isSeatCarrierType(entity)) {
            return;
        }
        Location location = entity.getLocation();
        this.plugin.scheduler().sync().runDelayed(() -> this.tryLeavingSeat(player, entity), player.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    protected void tryLeavingSeat(@NotNull Player player, @NotNull Entity vehicle) {
        Integer baseFurniture = (Integer)vehicle.getPersistentDataContainer().get(FURNITURE_SEAT_BASE_ENTITY_KEY, PersistentDataType.INTEGER);
        if (baseFurniture == null) {
            return;
        }
        vehicle.remove();
        BukkitFurniture furniture = this.loadedFurnitureByRealEntityId(baseFurniture);
        if (furniture == null) {
            return;
        }
        String vector3f = (String)vehicle.getPersistentDataContainer().get(FURNITURE_SEAT_VECTOR_3F_KEY, PersistentDataType.STRING);
        if (vector3f == null) {
            this.plugin.logger().warn("Failed to get vector3f for player " + player.getName() + "'s seat");
            return;
        }
        Vector3f seatPos = ResourceConfigUtils.getAsVector3f(vector3f, "seat");
        furniture.removeOccupiedSeat(seatPos);
        if (player.getVehicle() != null) {
            return;
        }
        Location vehicleLocation = vehicle.getLocation();
        Location originalLocation = vehicleLocation.clone();
        originalLocation.setY(furniture.location().getY());
        Location targetLocation = originalLocation.clone().add(vehicleLocation.getDirection().multiply(1.1));
        if (!this.isSafeLocation(targetLocation) && (targetLocation = this.findSafeLocationNearby(originalLocation)) == null) {
            return;
        }
        targetLocation.setYaw(player.getLocation().getYaw());
        targetLocation.setPitch(player.getLocation().getPitch());
        if (VersionHelper.isFolia()) {
            player.teleportAsync(targetLocation);
        } else {
            player.teleport(targetLocation);
        }
    }

    protected boolean isSeatCarrierType(Entity entity) {
        return entity instanceof ArmorStand || entity instanceof ItemDisplay;
    }

    private boolean isSafeLocation(Location location) {
        int z;
        int y;
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        int x = location.getBlockX();
        if (!world.getBlockAt(x, (y = location.getBlockY()) - 1, z = location.getBlockZ()).getType().isSolid()) {
            return false;
        }
        if (!world.getBlockAt(x, y, z).isPassable()) {
            return false;
        }
        return world.getBlockAt(x, y + 1, z).isPassable();
    }

    @Nullable
    private Location findSafeLocationNearby(Location center) {
        World world = center.getWorld();
        if (world == null) {
            return null;
        }
        int centerX = center.getBlockX();
        int centerY = center.getBlockY();
        int centerZ = center.getBlockZ();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int z;
                int x;
                Location nearbyLocation;
                if (dx == 0 && dz == 0 || !this.isSafeLocation(nearbyLocation = new Location(world, (double)(x = centerX + dx) + 0.5, (double)centerY, (double)(z = centerZ + dz) + 0.5))) continue;
                return nearbyLocation;
            }
        }
        return null;
    }
}

