/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.factory;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.item.LegacyItemWrapper;
import net.momirealms.craftengine.bukkit.item.factory.BukkitItemFactory;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.attribute.AttributeModifier;
import net.momirealms.craftengine.core.item.data.FireworkExplosion;
import net.momirealms.craftengine.core.item.data.Trim;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.Color;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.SkullUtils;
import net.momirealms.craftengine.core.util.UUIDUtils;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class UniversalItemFactory
extends BukkitItemFactory<LegacyItemWrapper> {
    public UniversalItemFactory(CraftEngine plugin) {
        super(plugin);
    }

    @Override
    protected LegacyItemWrapper wrapInternal(ItemStack item) {
        return new LegacyItemWrapper(item);
    }

    @Override
    protected void setTag(LegacyItemWrapper item, Object value, Object ... path) {
        item.setTag(value, path);
    }

    @Override
    protected Object getJavaTag(LegacyItemWrapper item, Object ... path) {
        return item.getJavaTag(path);
    }

    @Override
    protected Tag getTag(LegacyItemWrapper item, Object ... path) {
        return item.getNBTTag(path);
    }

    @Override
    protected Object getExactTag(LegacyItemWrapper item, Object ... path) {
        return item.getExactTag(path);
    }

    @Override
    protected boolean hasTag(LegacyItemWrapper item, Object ... path) {
        return item.hasTag(path);
    }

    @Override
    protected boolean removeTag(LegacyItemWrapper item, Object ... path) {
        return item.remove(path);
    }

    @Override
    protected Optional<Key> customId(LegacyItemWrapper item) {
        Object id = item.getJavaTag("craftengine:id");
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(Key.of(id.toString()));
    }

    @Override
    protected void customId(LegacyItemWrapper item, Key id) {
        item.setTag(id.toString(), "craftengine:id");
    }

    @Override
    protected void customNameJson(LegacyItemWrapper item, String json) {
        if (json != null) {
            item.setTag(json, "display", "Name");
        } else {
            item.remove("display", "Name");
        }
    }

    @Override
    protected Optional<String> customNameJson(LegacyItemWrapper item) {
        if (!item.hasTag("display", "Name")) {
            return Optional.empty();
        }
        return Optional.of((String)item.getJavaTag("display", "Name"));
    }

    @Override
    protected void itemNameJson(LegacyItemWrapper item, String json) {
        this.customNameJson(item, json);
    }

    @Override
    protected Optional<String> itemNameJson(LegacyItemWrapper item) {
        return this.customNameJson(item);
    }

    @Override
    protected void customModelData(LegacyItemWrapper item, Integer data) {
        if (data == null) {
            item.remove("CustomModelData");
        } else {
            item.setTag(data, "CustomModelData");
        }
    }

    @Override
    protected Optional<Integer> customModelData(LegacyItemWrapper item) {
        if (!item.hasTag("CustomModelData")) {
            return Optional.empty();
        }
        return Optional.of((Integer)item.getJavaTag("CustomModelData"));
    }

    @Override
    protected void skull(LegacyItemWrapper item, String skullData) {
        if (skullData == null) {
            item.remove("SkullOwner");
        } else {
            item.setTag(UUID.nameUUIDFromBytes(SkullUtils.identifierFromBase64(skullData).getBytes(StandardCharsets.UTF_8)), "SkullOwner", "Id");
            item.setTag(List.of(Map.of("Value", skullData)), "SkullOwner", "Properties", "textures");
        }
    }

    @Override
    protected Optional<List<String>> loreJson(LegacyItemWrapper item) {
        if (!item.hasTag("display", "Lore")) {
            return Optional.empty();
        }
        return Optional.of((List)item.getJavaTag("display", "Lore"));
    }

    @Override
    protected void loreJson(LegacyItemWrapper item, List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            item.remove("display", "Lore");
        } else {
            item.setTag(lore, "display", "Lore");
        }
    }

    @Override
    protected boolean unbreakable(LegacyItemWrapper item) {
        return Optional.ofNullable((Boolean)item.getJavaTag("Unbreakable")).orElse(false);
    }

    @Override
    protected void unbreakable(LegacyItemWrapper item, boolean unbreakable) {
        item.setTag(unbreakable, "Unbreakable");
    }

    @Override
    protected Optional<Integer> damage(LegacyItemWrapper item) {
        if (!item.hasTag("Damage")) {
            return Optional.empty();
        }
        return Optional.of((Integer)item.getJavaTag("Damage"));
    }

    @Override
    protected void damage(LegacyItemWrapper item, Integer damage) {
        item.setTag(damage, "Damage");
    }

    @Override
    protected Optional<Color> dyedColor(LegacyItemWrapper item) {
        if (!item.hasTag("display", "color")) {
            return Optional.empty();
        }
        return Optional.of(Color.fromDecimal((Integer)item.getJavaTag("display", "color")));
    }

    @Override
    protected void dyedColor(LegacyItemWrapper item, Color color) {
        if (color == null) {
            item.remove("display", "color");
        } else {
            item.setTag(color.color(), "display", "color");
        }
    }

    @Override
    protected int maxDamage(LegacyItemWrapper item) {
        return item.getItem().getType().getMaxDurability();
    }

    @Override
    protected void maxDamage(LegacyItemWrapper item, Integer damage) {
    }

    @Override
    protected void enchantments(LegacyItemWrapper item, List<net.momirealms.craftengine.core.item.data.Enchantment> enchantments) {
        if (enchantments == null || enchantments.isEmpty()) {
            item.remove("Enchantments");
            return;
        }
        ArrayList<Map<String, Short>> tags = new ArrayList<Map<String, Short>>();
        for (net.momirealms.craftengine.core.item.data.Enchantment enchantment : enchantments) {
            tags.add(Map.of("id", enchantment.id().toString(), "lvl", (short)enchantment.level()));
        }
        item.setTag(tags, "Enchantments");
    }

    @Override
    protected void storedEnchantments(LegacyItemWrapper item, List<net.momirealms.craftengine.core.item.data.Enchantment> enchantments) {
        if (enchantments == null || enchantments.isEmpty()) {
            item.remove("StoredEnchantments");
            return;
        }
        ArrayList<Map<String, Short>> tags = new ArrayList<Map<String, Short>>();
        for (net.momirealms.craftengine.core.item.data.Enchantment enchantment : enchantments) {
            tags.add(Map.of("id", enchantment.id().toString(), "lvl", (short)enchantment.level()));
        }
        item.setTag(tags, "StoredEnchantments");
    }

    @Override
    protected Optional<net.momirealms.craftengine.core.item.data.Enchantment> getEnchantment(LegacyItemWrapper item, Key key) {
        int level = item.getItem().getEnchantmentLevel(Objects.requireNonNull((Enchantment)Registry.ENCHANTMENT.get(new NamespacedKey(key.namespace(), key.value()))));
        if (level <= 0) {
            return Optional.empty();
        }
        return Optional.of(new net.momirealms.craftengine.core.item.data.Enchantment(key, level));
    }

    @Override
    protected void itemFlags(LegacyItemWrapper item, List<String> flags) {
        if (flags == null || flags.isEmpty()) {
            item.remove("HideFlags");
            return;
        }
        int f = 0;
        for (String flag : flags) {
            ItemFlag itemFlag = ItemFlag.valueOf((String)flag);
            f |= 1 << itemFlag.ordinal();
        }
        item.setTag(f, "HideFlags");
    }

    @Override
    protected int maxStackSize(LegacyItemWrapper item) {
        return item.getItem().getType().getMaxStackSize();
    }

    @Override
    protected void maxStackSize(LegacyItemWrapper item, Integer maxStackSize) {
        throw new UnsupportedOperationException("This feature is only available on 1.20.5+");
    }

    @Override
    protected void repairCost(LegacyItemWrapper item, Integer data) {
        item.setTag(data, "RepairCost");
    }

    @Override
    protected Optional<Integer> repairCost(LegacyItemWrapper item) {
        if (!item.hasTag("RepairCost")) {
            return Optional.empty();
        }
        return Optional.of((Integer)item.getJavaTag("RepairCost"));
    }

    @Override
    protected void trim(LegacyItemWrapper item, Trim trim) {
        if (trim == null) {
            item.remove("Trim");
            return;
        }
        item.setTag(trim.material().asString(), "Trim", "material");
        item.setTag(trim.pattern().asString(), "Trim", "pattern");
    }

    @Override
    protected Optional<FireworkExplosion> fireworkExplosion(LegacyItemWrapper item) {
        Map explosionObj = (Map)item.getJavaTag("Explosion");
        if (explosionObj == null) {
            return Optional.empty();
        }
        IntArrayList colors = (IntArrayList)explosionObj.get("Colors");
        IntArrayList fadeColors = (IntArrayList)explosionObj.get("FadeColors");
        return Optional.of(new FireworkExplosion(FireworkExplosion.Shape.byId(explosionObj.getOrDefault("Type", 0)), (IntList)(colors == null ? new IntArrayList() : new IntArrayList((IntList)colors)), (IntList)(fadeColors == null ? new IntArrayList() : new IntArrayList((IntList)fadeColors)), explosionObj.getOrDefault("Trail", false), explosionObj.getOrDefault("Flicker", false)));
    }

    @Override
    protected void fireworkExplosion(LegacyItemWrapper item, FireworkExplosion explosion) {
        if (explosion == null) {
            item.remove("Explosion");
        } else {
            item.setTag(Map.of("Type", explosion.shape().id(), "Colors", explosion.colors(), "FadeColors", explosion.fadeColors(), "Trail", explosion.hasTrail(), "Flicker", explosion.hasTwinkle()), "Explosion");
        }
    }

    @Override
    protected Optional<Trim> trim(LegacyItemWrapper item) {
        String material = (String)item.getJavaTag("Trim", "material");
        String pattern = (String)item.getJavaTag("Trim", "pattern");
        if (material == null || pattern == null) {
            return Optional.empty();
        }
        return Optional.of(new Trim(Key.of(material), Key.of(pattern)));
    }

    @Override
    protected LegacyItemWrapper mergeCopy(LegacyItemWrapper item1, LegacyItemWrapper item2) {
        Object copied = FastNMS.INSTANCE.constructor$ItemStack(FastNMS.INSTANCE.method$ItemStack$getItem(item2.getLiteralObject()), item2.count());
        Object copiedTag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(copied);
        FastNMS.INSTANCE.method$CompoundTag$merge(copiedTag, FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item1.getLiteralObject()));
        FastNMS.INSTANCE.method$CompoundTag$merge(copiedTag, FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item2.getLiteralObject()));
        return new LegacyItemWrapper(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(copied));
    }

    @Override
    protected void merge(LegacyItemWrapper item1, LegacyItemWrapper item2) {
        Object item1Tag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item1.getLiteralObject());
        Object item2Tag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item2.getLiteralObject());
        FastNMS.INSTANCE.method$CompoundTag$merge(item1Tag, item2Tag);
    }

    @Override
    protected LegacyItemWrapper transmuteCopy(LegacyItemWrapper item, Key newItem, int amount) {
        Object copied = FastNMS.INSTANCE.constructor$ItemStack(FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(newItem)), amount);
        Object copiedTag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(copied);
        Object thisTag = FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item.getLiteralObject());
        FastNMS.INSTANCE.method$CompoundTag$merge(copiedTag, thisTag);
        return new LegacyItemWrapper(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(copied));
    }

    @Override
    protected LegacyItemWrapper unsafeTransmuteCopy(LegacyItemWrapper item, Object newItem, int amount) {
        Object newItemStack = FastNMS.INSTANCE.constructor$ItemStack(newItem, amount);
        FastNMS.INSTANCE.method$ItemStack$setTag(newItemStack, FastNMS.INSTANCE.method$CompoundTag$copy(FastNMS.INSTANCE.field$ItemStack$getOrCreateTag(item.getLiteralObject())));
        return new LegacyItemWrapper(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(newItemStack));
    }

    @Override
    protected void attributeModifiers(LegacyItemWrapper item, List<AttributeModifier> modifiers) {
        ListTag listTag = new ListTag();
        for (AttributeModifier modifier : modifiers) {
            CompoundTag modifierTag = new CompoundTag();
            modifierTag.putString("AttributeName", modifier.type());
            modifierTag.putString("Name", modifier.id().toString());
            modifierTag.putString("Slot", modifier.slot().name().toLowerCase(Locale.ENGLISH));
            modifierTag.putInt("Operation", modifier.operation().ordinal());
            modifierTag.putDouble("Amount", modifier.amount());
            modifierTag.putIntArray("UUID", UUIDUtils.uuidToIntArray(UUID.nameUUIDFromBytes(modifier.id().toString().getBytes(StandardCharsets.UTF_8))));
            listTag.add(modifierTag);
        }
        item.setTag(listTag, "AttributeModifiers");
    }
}

