/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_2.block;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.momirealms.craftengine.core.block.StatePropertyAccessor;

public class PaperStatePropertyAccessor
implements StatePropertyAccessor {
    private final IBlockData blockState;

    public PaperStatePropertyAccessor(IBlockData blockState) {
        this.blockState = blockState;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.blockState.B().stream().map(IBlockState::f).collect(Collectors.toList());
    }

    @Override
    public String getPropertyValueAsString(String s) {
        IBlockState property = this.blockState.b().l().a(s);
        if (property == null) {
            return null;
        }
        return this.blockState.c(property).toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public <T> T getPropertyValue(String s) {
        IBlockState property = this.blockState.b().l().a(s);
        if (property == null) {
            return null;
        }
        return (T)this.blockState.c(property);
    }

    @Override
    public boolean hasProperty(String s) {
        return this.blockState.b().l().a(s) != null;
    }

    public IBlockData withProperty(String propertyName, String value) {
        Optional optionalValue;
        IBlockState property = this.blockState.b().l().a(propertyName);
        IBlockData finalState = this.blockState;
        if (property != null && (optionalValue = property.b(value)).isPresent()) {
            finalState = PaperStatePropertyAccessor.setValue(finalState, property, optionalValue.get());
        }
        return finalState;
    }

    public static <T extends Comparable<T>> IBlockData setValue(IBlockData blockState, IBlockState<T> property, Object value) {
        return (IBlockData)blockState.a(property, (Comparable)value);
    }
}

