/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_3.entity;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.momirealms.craftengine.bukkit.block.behavior.ConcretePowderBlockBehavior;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.BooleanProperty;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class InjectedFallingBlockEntity
extends EntityFallingBlock {
    private static final Logger LOGGER = LogUtils.getLogger();

    public InjectedFallingBlockEntity(net.minecraft.world.level.World level, double x, double y, double z, IBlockData state) {
        super(level, x, y, z, state);
    }

    public static InjectedFallingBlockEntity fall(@NotNull net.minecraft.world.level.World level, BlockPosition pos, IBlockData blockState) {
        ImmutableBlockState customBlockState = BlockStateUtils.getOptionalCustomBlockState(blockState).orElse(null);
        IBlockData finalBlockState = blockState;
        if (customBlockState != null) {
            for (Property<?> property : customBlockState.getProperties()) {
                if (!property.name().equals("waterlogged") && property.valueClass() != Boolean.class) continue;
                finalBlockState = customBlockState.get((BooleanProperty)property) != false ? (IBlockData)customBlockState.with((BooleanProperty)property, false).customBlockState().literalObject() : blockState;
                break;
            }
        } else {
            finalBlockState = blockState.b((IBlockState)BlockProperties.C) ? (IBlockData)blockState.a((IBlockState)BlockProperties.C, (Comparable)Boolean.valueOf(false)) : blockState;
        }
        InjectedFallingBlockEntity fallingBlockEntity = new InjectedFallingBlockEntity(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, finalBlockState);
        if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)fallingBlockEntity, (BlockPosition)pos, (IBlockData)blockState.u().g())) {
            return fallingBlockEntity;
        }
        level.a(pos, blockState.u().g(), 3);
        level.b((Entity)fallingBlockEntity);
        return fallingBlockEntity;
    }

    public EntityItem a(@NotNull IMaterial item) {
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(super.u());
        if (optionalCustomState.isEmpty()) {
            return null;
        }
        ImmutableBlockState customState = optionalCustomState.get();
        BukkitWorld world = new BukkitWorld((org.bukkit.World)this.dM().getWorld());
        WorldPosition position = new WorldPosition((World)world, this.K, this.L, this.M);
        ContextHolder.Builder builder = ContextHolder.builder().withParameter(DirectContextParameters.FALLING_BLOCK, true).withParameter(DirectContextParameters.POSITION, position);
        for (Item<Object> ceitem : customState.getDrops(builder, world, null)) {
            world.dropItemNaturally(position, ceitem);
        }
        return null;
    }

    public void l() {
        if (this.g.i()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.g.b();
            ++this.b;
            if (!this.aV()) {
                this.g(this.dp().b(0.0, -0.04, 0.0));
            }
            this.a(EnumMoveType.a, this.dp());
            if (this.dM().paperConfig().fixes.fallingBlockHeightNerf.test(v -> this.dt() > (double)v)) {
                if (this.c && this.dM().Z().b(GameRules.i)) {
                    this.a((IMaterial)block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            if (!this.dM().B) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.dm();
                ConcretePowderBlockBehavior behavior = BlockStateUtils.getOptionalCustomBlockState(this.u()).map(ImmutableBlockState::behavior).map(it -> it.getAs(ConcretePowderBlockBehavior.class).orElse(null)).orElse(null);
                boolean flag = this.g.b() instanceof BlockConcretePowder || behavior != null;
                boolean flag1 = flag && this.dM().b_(blockposition).a(TagsFluid.a);
                double d0 = this.dp().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.dM().a(new RayTrace(new Vec3D(this.K, this.L, this.M), this.dk(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, (Entity)this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.dM().b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.aC() && !flag1) {
                    if (!this.dM().B && (this.b > 100 && this.autoExpire && (blockposition.v() <= this.dM().J_() || blockposition.v() > this.dM().al()) || this.b > 600 && this.autoExpire)) {
                        if (this.c && this.dM().Z().b(GameRules.i)) {
                            this.a((IMaterial)block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    IBlockData iblockdata = this.dM().a_(blockposition);
                    this.g(this.dp().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bQ)) {
                        if (this.h) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.a(block, blockposition);
                        } else {
                            boolean flag4;
                            boolean flag2 = iblockdata.a((BlockActionContext)new BlockActionContextDirectional(this.dM(), blockposition, EnumDirection.a, ItemStack.f, EnumDirection.b));
                            boolean flag3 = BlockFalling.h((IBlockData)this.dM().a_(blockposition.d())) && (!flag || !flag1);
                            boolean bl = flag4 = this.g.a((IWorldReader)this.dM(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.g.b((IBlockState)BlockProperties.C) && this.dM().b_(blockposition).a() == FluidTypes.c) {
                                    this.g = (IBlockData)this.g.a((IBlockState)BlockProperties.C, (Comparable)Boolean.valueOf(true));
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPosition)blockposition, (IBlockData)this.g)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (!this.dM().a(blockposition, this.g, 3)) {
                                    if (this.c && this.dM().Z().b(GameRules.i)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockposition);
                                        this.a((IMaterial)block);
                                    }
                                } else {
                                    TileEntity tileentity;
                                    ((WorldServer)this.dM()).l().a.a((Entity)this, (Packet)new PacketPlayOutBlockChange(blockposition, this.dM().a_(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)block).a(this.dM(), blockposition, this.g, iblockdata, (EntityFallingBlock)this);
                                    }
                                    if (this.d != null && this.g.t() && (tileentity = this.dM().c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.q();
                                        for (String s : this.d.e()) {
                                            nbttagcompound.a(s, this.d.c(s).d());
                                        }
                                        try {
                                            tileentity.a(nbttagcompound);
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.c && this.dM().Z().b(GameRules.i)) {
                                    this.a(block, blockposition);
                                    this.a((IMaterial)block);
                                }
                            }
                        }
                    }
                }
            }
            this.g(this.dp().a(0.98));
        }
    }
}

