/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_3.inventory;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.momirealms.craftengine.bukkit.block.entity.BlockEntityHolder;
import net.momirealms.craftengine.bukkit.nms.StorageContainer;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageContainer
implements IWorldInventory,
StorageContainer {
    private final NonNullList<ItemStack> items;
    private final List<HumanEntity> viewers;
    private final InventoryHolder owner;
    private final int[] slots;
    private final BlockEntity blockEntity;
    private int maxStack = 64;
    private boolean canPlaceItem;
    private boolean canTakeItem;

    public SimpleStorageContainer(InventoryHolder owner, int size, boolean canPlaceItem, boolean canTakeItem) {
        this.items = NonNullList.a((int)size, (Object)ItemStack.f);
        this.viewers = new ObjectArrayList();
        this.owner = owner;
        this.slots = IntStream.range(0, size).toArray();
        this.canPlaceItem = canPlaceItem;
        this.canTakeItem = canTakeItem;
        if (owner instanceof BlockEntityHolder) {
            BlockEntityHolder blockEntityHolder = (BlockEntityHolder)owner;
            this.blockEntity = blockEntityHolder.blockEntity();
        } else {
            this.blockEntity = null;
        }
    }

    public int b() {
        return this.items.size();
    }

    @NotNull
    public ItemStack a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack a(int slot, int amount) {
        ItemStack result;
        ItemStack stack = this.a(slot);
        if (stack == ItemStack.f) {
            return stack;
        }
        if (stack.L() <= amount) {
            this.a(slot, ItemStack.f);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)amount);
            stack.h(amount);
        }
        this.e();
        return result;
    }

    @NotNull
    public ItemStack b(int slot) {
        ItemStack result;
        ItemStack stack = this.a(slot);
        if (stack == ItemStack.f) {
            return stack;
        }
        if (stack.L() <= 1) {
            this.a(slot, ItemStack.f);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)1);
            stack.h(1);
        }
        return result;
    }

    @Override
    public void setItem(int slot, @NotNull Object stack) {
        this.a(slot, (ItemStack)stack);
    }

    public void a(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack != ItemStack.f && this.ak_() > 0 && stack.L() > this.ak_()) {
            stack.f(this.ak_());
        }
    }

    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public void e() {
    }

    @Override
    public boolean stillValid(@NotNull Object player) {
        return this.a((EntityHuman)player);
    }

    public boolean a(@NotNull EntityHuman player) {
        if (this.blockEntity == null) {
            return true;
        }
        BukkitServerPlayer serverPlayer = BukkitCraftEngine.instance().adapt((Player)((EntityPlayer)player).getBukkitEntity());
        if (serverPlayer == null) {
            return false;
        }
        return serverPlayer.canInteractWithBlock(this.blockEntity.pos(), 4.0);
    }

    @NotNull
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(@NotNull HumanEntity player) {
        this.onOpen((CraftHumanEntity)player);
    }

    public void onOpen(@NotNull CraftHumanEntity player) {
        this.viewers.add((HumanEntity)player);
    }

    @Override
    public void onClose(@NotNull HumanEntity player) {
        this.onClose((CraftHumanEntity)player);
    }

    public void onClose(@NotNull CraftHumanEntity player) {
        this.viewers.remove(player);
    }

    @Override
    @NotNull
    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.owner;
    }

    @Override
    public boolean canPlaceItem(int slot, @NotNull Object stack) {
        return this.b(slot, (ItemStack)stack);
    }

    public boolean b(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Override
    public void startOpen(@NotNull Object player) {
        this.d_((EntityHuman)player);
    }

    public void d_(@NotNull EntityHuman player) {
    }

    @Override
    public void stopOpen(@NotNull Object player) {
        this.c((EntityHuman)player);
    }

    public void c(@NotNull EntityHuman player) {
    }

    public void a() {
        this.items.clear();
    }

    @Override
    @NotNull
    public Location getLocation() {
        if (this.blockEntity == null) {
            return null;
        }
        return new Location((World)this.blockEntity.world().world().platformWorld(), (double)this.blockEntity.pos().x(), (double)this.blockEntity.pos().y(), (double)this.blockEntity.pos().z());
    }

    public boolean ai_() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public int @NotNull [] getSlotsForFace(@NotNull Object direction) {
        return this.a((EnumDirection)direction);
    }

    public int @NotNull [] a(@NotNull EnumDirection direction) {
        return this.slots;
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, @NotNull Object itemStack, @Nullable Object direction) {
        return this.a(i, (ItemStack)itemStack, (EnumDirection)direction);
    }

    public boolean a(int i, @NotNull ItemStack itemStack, @Nullable EnumDirection direction) {
        return this.canPlaceItem;
    }

    @Override
    public boolean canTakeItemThroughFace(int i, @NotNull Object itemStack, @NotNull Object direction) {
        return this.b(i, (ItemStack)itemStack, (EnumDirection)direction);
    }

    public boolean b(int i, @NotNull ItemStack itemStack, @NotNull EnumDirection direction) {
        return this.canTakeItem;
    }

    @Override
    public void setCanPlaceItem(boolean canPlaceItem) {
        this.canPlaceItem = canPlaceItem;
    }

    @Override
    public void setCanTakeItem(boolean canTakeItem) {
        this.canTakeItem = canTakeItem;
    }

    @Override
    public boolean canPlaceItem() {
        return this.canPlaceItem;
    }

    @Override
    public boolean canTakeItem() {
        return this.canTakeItem;
    }
}

