/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_3.recipe;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.World;
import net.momirealms.craftengine.bukkit.nms.v1_20_3.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapelessRecipe
extends ShapelessRecipes {
    private final CustomShapelessRecipe<ItemStack> recipe;
    private final ShapelessRecipes companionRecipe;

    public InjectedShapelessRecipe(CustomShapelessRecipe<ItemStack> recipe, String group, CraftingBookCategory category, net.minecraft.world.item.ItemStack result, NonNullList<RecipeItemStack> visualIngredients, NonNullList<RecipeItemStack> roughIngredients) {
        super(group, category, result, visualIngredients);
        this.recipe = recipe;
        this.companionRecipe = new ShapelessRecipes(group, category, result, roughIngredients);
    }

    public static InjectedShapelessRecipe of(CustomShapelessRecipe<ItemStack> recipe) {
        List<Ingredient<ItemStack>> visualIngredients = recipe.ingredientsInUse();
        NonNullList visualData = NonNullList.a((int)visualIngredients.size(), (Object)RecipeItemStack.a);
        for (int i = 0; i < visualIngredients.size(); ++i) {
            visualData.set(i, (Object)RecipeHelper.toMinecraftVisual(visualIngredients.get(i)));
        }
        List<Ingredient<ItemStack>> roughIngredients = recipe.ingredientsInUse();
        NonNullList roughData = NonNullList.a((int)roughIngredients.size(), (Object)RecipeItemStack.a);
        for (int i = 0; i < roughIngredients.size(); ++i) {
            roughData.set(i, (Object)RecipeHelper.toMinecraft(roughIngredients.get(i)));
        }
        return new InjectedShapelessRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), (net.minecraft.world.item.ItemStack)recipe.buildVisualOrActualResult(ItemBuildContext.empty()).getLiteralObject(), (NonNullList<RecipeItemStack>)visualData, (NonNullList<RecipeItemStack>)roughData);
    }

    public boolean a(@NotNull InventoryCrafting inventory, @NotNull World world) {
        boolean vanillaMatches = this.companionRecipe.a(inventory, world);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches((RecipeInput)RecipeHelper.toCraftEngine(inventory));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull InventoryCrafting inventory) {
        return RecipeHelper.getRemainingItems(inventory);
    }

    public boolean h() {
        return this.recipe.showNotification();
    }
}

