/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.entity;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.momirealms.craftengine.bukkit.block.behavior.ConcretePowderBlockBehavior;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.BooleanProperty;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class InjectedFallingBlockEntity
extends FallingBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();

    public InjectedFallingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        super(level, x, y, z, state);
    }

    public static InjectedFallingBlockEntity fall(@NotNull Level level, BlockPos pos, BlockState blockState) {
        ImmutableBlockState customBlockState = BlockStateUtils.getOptionalCustomBlockState(blockState).orElse(null);
        BlockState finalBlockState = blockState;
        if (customBlockState != null) {
            for (net.momirealms.craftengine.core.block.properties.Property<?> property : customBlockState.getProperties()) {
                if (!property.name().equals("waterlogged") && property.valueClass() != Boolean.class) continue;
                finalBlockState = customBlockState.get((BooleanProperty)property) != false ? (BlockState)customBlockState.with((BooleanProperty)property, false).customBlockState().literalObject() : blockState;
                break;
            }
        } else {
            finalBlockState = blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : blockState;
        }
        InjectedFallingBlockEntity fallingBlockEntity = new InjectedFallingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, finalBlockState);
        if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)fallingBlockEntity, (BlockPos)pos, (BlockState)blockState.getFluidState().createLegacyBlock())) {
            return fallingBlockEntity;
        }
        level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)fallingBlockEntity);
        return fallingBlockEntity;
    }

    public ItemEntity spawnAtLocation(@NotNull ItemLike item) {
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(super.getBlockState());
        if (optionalCustomState.isEmpty()) {
            return null;
        }
        ImmutableBlockState customState = optionalCustomState.get();
        BukkitWorld world = new BukkitWorld((org.bukkit.World)this.level().getWorld());
        WorldPosition position = new WorldPosition((World)world, this.xo, this.yo, this.zo);
        ContextHolder.Builder builder = ContextHolder.builder().withParameter(DirectContextParameters.FALLING_BLOCK, true).withParameter(DirectContextParameters.POSITION, position);
        for (Item<Object> ceitem : customState.getDrops(builder, world, null)) {
            world.dropItemNaturally(position, ceitem);
        }
        return null;
    }

    public void tick() {
        if (this.blockState.isAir()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.level().paperConfig().fixes.fallingBlockHeightNerf.test(v -> this.getY() > (double)v)) {
                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            if (!this.level().isClientSide) {
                BlockHitResult movingobjectpositionblock;
                BlockPos blockposition = this.blockPosition();
                ConcretePowderBlockBehavior behavior = BlockStateUtils.getOptionalCustomBlockState(this.getBlockState()).map(ImmutableBlockState::behavior).map(it -> it.getAs(ConcretePowderBlockBehavior.class).orElse(null)).orElse(null);
                boolean flag = this.blockState.getBlock() instanceof ConcretePowderBlock || behavior != null;
                boolean flag1 = flag && this.level().getFluidState(blockposition).is(FluidTags.WATER);
                double d0 = this.getDeltaMovement().lengthSqr();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.level().getFluidState(movingobjectpositionblock.getBlockPos()).is(FluidTags.WATER)) {
                    blockposition = movingobjectpositionblock.getBlockPos();
                    flag1 = true;
                }
                if (!this.onGround() && !flag1) {
                    if (!this.level().isClientSide && (this.time > 100 && this.autoExpire && (blockposition.getY() <= this.level().getMinBuildHeight() || blockposition.getY() > this.level().getMaxBuildHeight()) || this.time > 600 && this.autoExpire)) {
                        if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            this.spawnAtLocation((ItemLike)block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    BlockState iblockdata = this.level().getBlockState(blockposition);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!iblockdata.is(Blocks.MOVING_PISTON)) {
                        if (this.cancelDrop) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.callOnBrokenAfterFall(block, blockposition);
                        } else {
                            boolean flag4;
                            boolean flag2 = iblockdata.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockposition, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                            boolean flag3 = FallingBlock.isFree((BlockState)this.level().getBlockState(blockposition.below())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.canSurvive((LevelReader)this.level(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockposition).getType() == Fluids.WATER) {
                                    this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)blockposition, (BlockState)this.blockState)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (!this.level().setBlock(blockposition, this.blockState, 3)) {
                                    if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.callOnBrokenAfterFall(block, blockposition);
                                        this.spawnAtLocation((ItemLike)block);
                                    }
                                } else {
                                    BlockEntity tileentity;
                                    ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockposition, this.level().getBlockState(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)block).onLand(this.level(), blockposition, this.blockState, iblockdata, (FallingBlockEntity)this);
                                    }
                                    if (this.blockData != null && this.blockState.hasBlockEntity() && (tileentity = this.level().getBlockEntity(blockposition)) != null) {
                                        CompoundTag nbttagcompound = tileentity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess());
                                        for (String s : this.blockData.getAllKeys()) {
                                            nbttagcompound.put(s, this.blockData.get(s).copy());
                                        }
                                        try {
                                            tileentity.loadWithComponents(nbttagcompound, (HolderLookup.Provider)this.level().registryAccess());
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.setChanged();
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.callOnBrokenAfterFall(block, blockposition);
                                    this.spawnAtLocation((ItemLike)block);
                                }
                            }
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }
}

