/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapedRecipe
extends ShapedRecipe {
    private final CustomShapedRecipe<ItemStack> recipe;
    private final ShapedRecipePattern roughPattern;

    public InjectedShapedRecipe(CustomShapedRecipe<ItemStack> recipe, String group, CraftingBookCategory category, ShapedRecipePattern visualPattern, ShapedRecipePattern roughPattern, net.minecraft.world.item.ItemStack result, boolean showNotification) {
        super(group, category, visualPattern, result, showNotification);
        this.recipe = recipe;
        this.roughPattern = roughPattern;
    }

    public static InjectedShapedRecipe of(CustomShapedRecipe<ItemStack> recipe) {
        Map visualData = Maps.transformValues(recipe.pattern().ingredients(), RecipeHelper::toMinecraftVisual);
        ShapedRecipePattern visualPattern = ShapedRecipePattern.of((Map)visualData, (String[])recipe.pattern().pattern());
        Map roughData = Maps.transformValues(recipe.pattern().ingredients(), RecipeHelper::toMinecraft);
        ShapedRecipePattern roughPattern = ShapedRecipePattern.of((Map)roughData, (String[])recipe.pattern().pattern());
        return new InjectedShapedRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), visualPattern, roughPattern, (net.minecraft.world.item.ItemStack)recipe.buildVisualOrActualResult(ItemBuildContext.empty()).getLiteralObject(), recipe.showNotification());
    }

    public boolean matches(@NotNull CraftingContainer inventory, @NotNull Level world) {
        boolean vanillaMatches = this.roughPattern.matches(inventory);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches(RecipeHelper.toCraftEngine(inventory));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull CraftingContainer inventory) {
        return RecipeHelper.getRemainingItems(inventory);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

