/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe;

import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedSmeltingRecipe
extends SmeltingRecipe {
    private final CustomSmeltingRecipe<ItemStack> recipe;
    private final Ingredient roughIngredient;

    public InjectedSmeltingRecipe(CustomSmeltingRecipe<ItemStack> recipe, String group, CookingBookCategory category, Ingredient visualIngredient, Ingredient roughIngredient, net.minecraft.world.item.ItemStack result, float experience, int cookingTime) {
        super(group, category, visualIngredient, result, experience, cookingTime);
        this.recipe = recipe;
        this.roughIngredient = roughIngredient;
    }

    public static InjectedSmeltingRecipe of(CustomSmeltingRecipe<ItemStack> recipe) {
        return new InjectedSmeltingRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), RecipeHelper.toMinecraftVisual(recipe.ingredient()), RecipeHelper.toMinecraft(recipe.ingredient()), (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.empty()).getLiteralObject(), recipe.experience(), recipe.cookingTime());
    }

    public boolean matches(@NotNull Container inventory, @NotNull Level world) {
        boolean vanillaMatches = this.roughIngredient.test(inventory.getItem(0));
        if (!vanillaMatches) {
            return false;
        }
        Item<ItemStack> wrapped = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inventory.getItem(0)));
        SingleItemInput<ItemStack> singleItemInput = new SingleItemInput<ItemStack>(UniqueIdItem.of(wrapped));
        return this.recipe.matches(singleItemInput);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

