/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21_9.recipe;

import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.v1_21_9.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedSmeltingRecipe
extends SmeltingRecipe {
    private final CustomSmeltingRecipe<ItemStack> recipe;
    private final Ingredient roughInput;

    public InjectedSmeltingRecipe(CustomSmeltingRecipe<ItemStack> recipe, String group, CookingBookCategory category, Ingredient visualIngredient, Ingredient roughIngredient, net.minecraft.world.item.ItemStack result, float experience, int cookingTime) {
        super(group, category, visualIngredient, result, experience, cookingTime);
        this.recipe = recipe;
        this.roughInput = roughIngredient;
    }

    public static InjectedSmeltingRecipe of(CustomSmeltingRecipe<ItemStack> recipe) {
        return new InjectedSmeltingRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), RecipeHelper.toMinecraftVisual(recipe.ingredient()), RecipeHelper.toMinecraft(recipe.ingredient()), (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.empty()).getLiteralObject(), recipe.experience(), recipe.cookingTime());
    }

    public boolean vanillaMatches(SingleRecipeInput input, Level level) {
        return this.roughInput.test(input.item());
    }

    public boolean matches(@NotNull SingleRecipeInput input, @NotNull Level level) {
        boolean vanillaMatches = this.vanillaMatches(input, level);
        if (!vanillaMatches) {
            return false;
        }
        Item<ItemStack> wrapped = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)input.item()));
        SingleItemInput<ItemStack> singleItemInput = new SingleItemInput<ItemStack>(UniqueIdItem.of(wrapped));
        return this.recipe.matches(singleItemInput);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

