/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.pack;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.api.event.AsyncResourcePackCacheEvent;
import net.momirealms.craftengine.bukkit.api.event.AsyncResourcePackGenerateEvent;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.command.feature.ReloadCommand;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.ResourcePackUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.pack.AbstractPackManager;
import net.momirealms.craftengine.core.pack.PackCacheData;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class BukkitPackManager
extends AbstractPackManager
implements Listener {
    private final BukkitCraftEngine plugin;

    public BukkitPackManager(BukkitCraftEngine plugin) {
        super(plugin, cd -> {
            AsyncResourcePackCacheEvent cacheEvent = new AsyncResourcePackCacheEvent((PackCacheData)cd);
            EventUtils.fireAndForget(cacheEvent);
        }, (rf, zp) -> {
            AsyncResourcePackGenerateEvent endEvent = new AsyncResourcePackGenerateEvent((Path)rf, (Path)zp);
            EventUtils.fireAndForget(endEvent);
        });
        this.plugin = plugin;
    }

    @Override
    public void delayedInit() {
        super.delayedInit();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (Config.sendPackOnJoin() && !VersionHelper.isOrAbove1_20_2()) {
            BukkitServerPlayer player = BukkitAdaptors.adapt(event.getPlayer());
            if (player == null) {
                return;
            }
            this.sendResourcePack(player);
        }
    }

    @Override
    public void load() {
        if (ReloadCommand.RELOAD_PACK_FLAG || CraftEngine.instance().isInitializing()) {
            super.load();
        }
    }

    @Override
    public void unload() {
        super.unload();
    }

    @Override
    public void disable() {
        super.disable();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAsyncResourcePackGenerate(AsyncResourcePackGenerateEvent event) {
        if (!Config.autoUpload()) {
            return;
        }
        this.uploadResourcePack();
    }

    @Override
    public void uploadResourcePack() {
        this.resourcePackHost().upload(Config.fileToUpload()).whenComplete((d, e) -> {
            if (e != null) {
                CraftEngine.instance().logger().warn("Failed to upload resource pack", (Throwable)e);
                return;
            }
            if (!Config.sendPackOnUpload()) {
                return;
            }
            CraftEngine.instance().logger().info("Completed uploading resource pack");
            for (BukkitServerPlayer player : this.plugin.networkManager().onlineUsers()) {
                this.sendResourcePack(player);
            }
        });
    }

    @Override
    public void sendResourcePack(Player player) {
        CompletableFuture<List<ResourcePackDownloadData>> future = this.resourcePackHost().requestResourcePackDownloadLink(player.uuid());
        ((CompletableFuture)future.thenAccept(dataList -> {
            if (player.isOnline()) {
                player.unloadCurrentResourcePack();
                if (dataList.isEmpty()) {
                    return;
                }
                if (dataList.size() == 1) {
                    ResourcePackDownloadData data = (ResourcePackDownloadData)dataList.getFirst();
                    player.sendPacket(ResourcePackUtils.createPacket(data.uuid(), data.url(), data.sha1()), true);
                    player.addResourcePackUUID(data.uuid());
                } else {
                    ArrayList<Object> packets = new ArrayList<Object>();
                    for (ResourcePackDownloadData data : dataList) {
                        packets.add(ResourcePackUtils.createPacket(data.uuid(), data.url(), data.sha1()));
                        player.addResourcePackUUID(data.uuid());
                    }
                    player.sendPackets(packets, true);
                }
            }
        })).exceptionally(throwable -> {
            CraftEngine.instance().logger().warn("Failed to send resource pack to player " + player.name(), (Throwable)throwable);
            return null;
        });
    }
}

