/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.lang.reflect.Method;
import java.util.Objects;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.PaperCraftEnginePlugin;
import net.momirealms.craftengine.bukkit.plugin.agent.RuntimePatcher;
import net.momirealms.craftengine.bukkit.plugin.classpath.BukkitClassPathAppender;
import net.momirealms.craftengine.bukkit.plugin.classpath.PaperPluginClassPathAppender;
import net.momirealms.craftengine.core.plugin.logger.Slf4jPluginLogger;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PaperCraftEngineBootstrap
implements PluginBootstrap {
    private static final Class<?> clazz$PluginProviderContext = PluginProviderContext.class;
    private static final Class<?> clazz$ComponentLogger = Objects.requireNonNull(ReflectionUtils.getClazz("net{}kyori{}adventure{}text{}logger{}slf4j{}ComponentLogger".replace("{}", ".")));
    private static final Method method$PluginProviderContext$getLogger = Objects.requireNonNull(ReflectionUtils.getMethod(clazz$PluginProviderContext, clazz$ComponentLogger, new String[]{"getLogger"}, new Class[0]));
    protected BukkitCraftEngine plugin;

    public void bootstrap(@NotNull BootstrapContext context) {
        Slf4jPluginLogger logger;
        try {
            logger = new Slf4jPluginLogger((Logger)method$PluginProviderContext$getLogger.invoke((Object)context, new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to getLogger", e);
        }
        try {
            this.plugin = new BukkitCraftEngine(logger, context.getDataDirectory(), new BukkitClassPathAppender(), new PaperPluginClassPathAppender(this.getClass().getClassLoader()));
        }
        catch (UnsupportedOperationException e) {
            this.plugin = new BukkitCraftEngine(logger, context.getDataDirectory(), new PaperPluginClassPathAppender(this.getClass().getClassLoader()), new PaperPluginClassPathAppender(this.getClass().getClassLoader()));
        }
        this.plugin.applyDependencies();
        this.plugin.setUpConfigAndLocale();
        if (PaperCraftEngineBootstrap.isDatapackDiscoveryAvailable()) {
            new ModernEventHandler(context, this.plugin).register();
        } else {
            try {
                logger.info("Patching the server...");
                RuntimePatcher.patch(this.plugin);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to patch server", e);
            }
        }
    }

    private static boolean isDatapackDiscoveryAvailable() {
        try {
            Class<?> eventsClass = Class.forName("io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents");
            eventsClass.getField("DATAPACK_DISCOVERY");
            return true;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            return false;
        }
    }

    @NotNull
    public JavaPlugin createPlugin(@NotNull PluginProviderContext context) {
        return new PaperCraftEnginePlugin(this);
    }

    public static class ModernEventHandler {
        private final BootstrapContext context;
        private final BukkitCraftEngine plugin;

        public ModernEventHandler(BootstrapContext context, BukkitCraftEngine plugin) {
            this.context = context;
            this.plugin = plugin;
        }

        public void register() {
            this.context.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.DATAPACK_DISCOVERY, e -> {
                try {
                    this.plugin.injectRegistries();
                }
                catch (Throwable ex) {
                    this.plugin.logger().warn("Failed to inject registries", ex);
                }
            });
        }
    }
}

