/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.classpath;

import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import net.momirealms.craftengine.core.plugin.classpath.ClassPathAppender;
import net.momirealms.craftengine.core.plugin.classpath.URLClassLoaderAccess;
import org.bukkit.Bukkit;

public class BukkitClassPathAppender
implements ClassPathAppender {
    private final URLClassLoaderAccess libraryClassLoaderAccess;

    public BukkitClassPathAppender() {
        ClassLoader classLoader;
        ClassLoader bukkitClassLoader = Bukkit.class.getClassLoader();
        if (bukkitClassLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)bukkitClassLoader;
            this.libraryClassLoaderAccess = URLClassLoaderAccess.create(urlClassLoader);
        } else if (bukkitClassLoader.getClass().getName().equals("space.vectrix.ignite.launch.ember.EmberClassLoader") && (classLoader = bukkitClassLoader.getParent()) instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            this.libraryClassLoaderAccess = URLClassLoaderAccess.create(urlClassLoader);
        } else {
            throw new UnsupportedOperationException("Unsupported classloader " + String.valueOf(bukkitClassLoader.getClass()));
        }
    }

    @Override
    public void addJarToClasspath(Path file) {
        try {
            this.libraryClassLoaderAccess.addURL(file.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

