/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command;

import java.util.UUID;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.core.plugin.command.sender.Sender;
import net.momirealms.craftengine.core.plugin.command.sender.SenderFactory;
import net.momirealms.craftengine.core.util.Tristate;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;

public class BukkitSenderFactory
extends SenderFactory<BukkitCraftEngine, CommandSender> {
    public BukkitSenderFactory(BukkitCraftEngine plugin) {
        super(plugin);
    }

    @Override
    protected String name(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "Console";
    }

    @Override
    protected UUID uniqueId(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getUniqueId();
        }
        return Sender.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSender sender, Component message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            FastNMS.INSTANCE.method$Connection$send(FastNMS.INSTANCE.field$ServerGamePacketListenerImpl$connection(FastNMS.INSTANCE.field$Player$connection(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player))), FastNMS.INSTANCE.constructor$ClientboundSystemChatPacket(ComponentUtils.adventureToMinecraft(message), false), null);
        } else if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender commandSender = (ConsoleCommandSender)sender;
            commandSender.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
        } else if (sender instanceof RemoteConsoleCommandSender) {
            RemoteConsoleCommandSender commandSender = (RemoteConsoleCommandSender)sender;
            commandSender.sendMessage(LegacyComponentSerializer.legacySection().serialize(message));
        } else {
            String legacy = LegacyComponentSerializer.legacySection().serialize(message);
            ((BukkitCraftEngine)this.plugin()).scheduler().sync().run(() -> sender.sendMessage(legacy));
        }
    }

    @Override
    protected Tristate permissionState(CommandSender sender, String node) {
        if (sender.hasPermission(node)) {
            return Tristate.TRUE;
        }
        if (sender.isPermissionSet(node)) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }

    @Override
    protected boolean hasPermission(CommandSender sender, String node) {
        return sender.hasPermission(node);
    }

    @Override
    protected void performCommand(CommandSender sender, String command) {
        ((BukkitCraftEngine)this.plugin()).javaPlugin().getServer().dispatchCommand(sender, command);
    }

    @Override
    protected boolean isConsole(CommandSender sender) {
        return sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender;
    }

    @Override
    protected <C extends CommandSender> C consoleCommandSender() {
        return (C)Bukkit.getConsoleSender();
    }

    @Override
    public void close() {
        super.close();
    }
}

