/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.pack.allocator.VisualBlockStateAllocator;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEventSource;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.StringParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DebugAppearanceStateUsageCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugAppearanceStateUsageCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.required("id", StringParser.stringComponent((StringParser.StringMode)StringParser.StringMode.GREEDY_FLAG_YIELDING).suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(DebugAppearanceStateUsageCommand.this.plugin().blockManager().blockStateArranger().keySet().stream().map(it -> Suggestion.suggestion((String)it.toString())).toList());
            }
        })).handler(context -> {
            String data = (String)context.get("id");
            BukkitBlockManager blockManager = this.plugin().blockManager();
            Key baseBlockId = Key.of(data);
            List<BlockStateWrapper> appearances = blockManager.blockStateArranger().get(baseBlockId);
            if (appearances == null) {
                return;
            }
            int i = 0;
            TextComponent block = Component.text((String)(String.valueOf(baseBlockId) + ": "));
            this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage((Component)block);
            VisualBlockStateAllocator allocator = blockManager.blockParser().visualBlockStateAllocator();
            ArrayList<TextComponent> batch = new ArrayList<TextComponent>();
            for (BlockStateWrapper appearance : appearances) {
                TextComponent text = Component.text((String)"|");
                List<Integer> reals = blockManager.appearanceToRealStates(appearance.registryId());
                if (reals.isEmpty()) {
                    Component hover = Component.text((String)(baseBlockId.value() + ":" + i)).color((TextColor)NamedTextColor.GREEN);
                    hover = hover.append((Component)Component.newline()).append(Component.text((String)appearance.getAsString()).color((TextColor)NamedTextColor.GREEN));
                    text = text.color((TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
                } else {
                    boolean isFixed = allocator.isForcedState(appearance);
                    NamedTextColor namedTextColor = isFixed ? NamedTextColor.RED : NamedTextColor.YELLOW;
                    Component hover = Component.text((String)(baseBlockId.value() + ":" + i)).color((TextColor)namedTextColor);
                    ArrayList<Object> hoverChildren = new ArrayList<Object>();
                    hoverChildren.add(Component.newline());
                    hoverChildren.add(Component.text((String)appearance.getAsString()).color((TextColor)namedTextColor));
                    for (int real : reals) {
                        hoverChildren.add(Component.newline());
                        hoverChildren.add(Component.text((String)blockManager.getImmutableBlockStateUnsafe(real).toString()).color((TextColor)NamedTextColor.GRAY));
                    }
                    text = text.color((TextColor)namedTextColor).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover.children(hoverChildren)));
                }
                batch.add(text);
                ++i;
                if (batch.size() != 100) continue;
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
            if (!batch.isEmpty()) {
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_appearance_state_usage";
    }
}

