/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.font.BukkitFontManager;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.pack.allocator.IdAllocator;
import net.momirealms.craftengine.core.pack.allocator.VisualBlockStateAllocator;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.FileUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.StringParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DebugCleanCacheCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugCleanCacheCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.optional("type", StringParser.stringComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(this){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(List.of(Suggestion.suggestion((String)"custom-model-data"), Suggestion.suggestion((String)"custom-block-states"), Suggestion.suggestion((String)"visual-block-states"), Suggestion.suggestion((String)"font"), Suggestion.suggestion((String)"all")));
            }
        })).handler(context -> {
            String type;
            if (this.plugin().isReloading()) {
                ((CommandSender)context.sender()).sendMessage("The plugin is reloading. Please wait until the process is complete.");
                return;
            }
            switch (type = (String)context.getOrDefault("type", (Object)"all")) {
                case "custom-model-data": {
                    this.handleCustomModelData((CommandContext<CommandSender>)context);
                    break;
                }
                case "font": 
                case "images": {
                    this.handleFont((CommandContext<CommandSender>)context);
                    break;
                }
                case "custom-block-states": {
                    this.handleCustomBlockState((CommandContext<CommandSender>)context);
                    break;
                }
                case "visual-block-states": {
                    this.handleVisualBlockState((CommandContext<CommandSender>)context);
                    break;
                }
                case "all": {
                    this.handleCustomModelData((CommandContext<CommandSender>)context);
                    this.handleFont((CommandContext<CommandSender>)context);
                    this.handleCustomBlockState((CommandContext<CommandSender>)context);
                    this.handleVisualBlockState((CommandContext<CommandSender>)context);
                }
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_clean_cache";
    }

    private void handleVisualBlockState(CommandContext<CommandSender> context) {
        BukkitBlockManager instance = BukkitBlockManager.instance();
        HashSet<BlockStateWrapper> ids = new HashSet<BlockStateWrapper>();
        for (CustomBlock customBlock : instance.loadedBlocks().values()) {
            for (ImmutableBlockState state : customBlock.variantProvider().states()) {
                ids.add(state.vanillaBlockState());
            }
        }
        VisualBlockStateAllocator visualBlockStateAllocator = instance.blockParser().visualBlockStateAllocator();
        List<String> removed = visualBlockStateAllocator.cleanupUnusedIds(i -> !ids.contains(i));
        try {
            visualBlockStateAllocator.saveToCache();
        }
        catch (IOException e) {
            this.plugin().logger().warn("Error while saving visual block states allocation", e);
        }
        for (String id : removed) {
            this.plugin().logger().info("Cleaned unsued block appearance: " + id);
        }
        ((CommandSender)context.sender()).sendMessage("Cleaned " + removed.size() + " unused block state appearances");
    }

    private void handleCustomBlockState(CommandContext<CommandSender> context) {
        BukkitBlockManager instance = BukkitBlockManager.instance();
        HashSet<String> ids = new HashSet<String>();
        for (CustomBlock customBlock : instance.loadedBlocks().values()) {
            for (ImmutableBlockState state : customBlock.variantProvider().states()) {
                ids.add(state.toString());
            }
        }
        IdAllocator idAllocator = instance.blockParser().internalIdAllocator();
        List<String> removed = idAllocator.cleanupUnusedIds(i -> !ids.contains(i));
        try {
            idAllocator.saveToCache();
        }
        catch (IOException e) {
            this.plugin().logger().warn("Error while saving custom block states allocation", e);
        }
        for (String id : removed) {
            this.plugin().logger().info("Cleaned unsued block state: " + id);
        }
        ((CommandSender)context.sender()).sendMessage("Cleaned " + removed.size() + " unused custom block states");
    }

    private void handleFont(CommandContext<CommandSender> context) {
        BukkitFontManager instance = this.plugin().fontManager();
        HashMap idsMap = new HashMap();
        for (BitmapImage image : instance.loadedImages().values()) {
            Set ids = idsMap.computeIfAbsent(image.font(), k -> new HashSet());
            String id = image.id().toString();
            ids.add(id);
            for (int i2 = 0; i2 < image.rows(); ++i2) {
                for (int j = 0; j < image.columns(); ++j) {
                    String imageArgs = id + ":" + i2 + ":" + j;
                    ids.add(imageArgs);
                }
            }
        }
        int total = 0;
        for (Map.Entry<Key, IdAllocator> entry : this.getAllCachedFont().entrySet()) {
            Key font = entry.getKey();
            Set ids = idsMap.getOrDefault(font, Collections.emptySet());
            List<String> removed = entry.getValue().cleanupUnusedIds(i -> !ids.contains(i));
            try {
                entry.getValue().saveToCache();
            }
            catch (IOException e) {
                this.plugin().logger().warn("Error while saving codepoint allocation for font " + font.asString(), e);
                return;
            }
            for (String id : removed) {
                this.plugin().logger().info("Cleaned unsued image: " + id);
            }
            total += removed.size();
        }
        ((CommandSender)context.sender()).sendMessage("Cleaned " + total + " unused codepoints");
    }

    private void handleCustomModelData(CommandContext<CommandSender> context) {
        BukkitItemManager instance = BukkitItemManager.instance();
        HashMap idsMap = new HashMap();
        for (CustomItem item : instance.loadedItems().values()) {
            Set ids = idsMap.computeIfAbsent(item.clientBoundMaterial(), k -> new HashSet());
            ids.add(item.id().asString());
        }
        int total = 0;
        for (Map.Entry<Key, IdAllocator> entry : this.getAllCachedCustomModelData().entrySet()) {
            Set ids = idsMap.getOrDefault(entry.getKey(), Collections.emptySet());
            List<String> removed = entry.getValue().cleanupUnusedIds(i -> !ids.contains(i));
            total += removed.size();
            try {
                entry.getValue().saveToCache();
            }
            catch (IOException e) {
                this.plugin().logger().warn("Error while saving custom model data allocation for material " + entry.getKey().asString(), e);
                return;
            }
            for (String id : removed) {
                this.plugin().logger().info("Cleaned unsued item: " + id);
            }
        }
        ((CommandSender)context.sender()).sendMessage("Cleaned " + total + " unused custom model data");
    }

    public Map<Key, IdAllocator> getAllCachedCustomModelData() {
        Path cacheDir = CraftEngine.instance().dataFolderPath().resolve("cache").resolve("custom-model-data");
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            return Map.of();
        }
        HashMap<Key, IdAllocator> idAllocators = new HashMap<Key, IdAllocator>();
        try (Stream<Path> files = Files.list(cacheDir);){
            files.filter(this::isJsonFile).forEach(file -> this.processIdAllocatorFile("minecraft", (Path)file, (Map<Key, IdAllocator>)idAllocators));
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("Failed to process: " + String.valueOf(cacheDir.getFileName()), e);
        }
        return idAllocators;
    }

    public Map<Key, IdAllocator> getAllCachedFont() {
        Path cacheDir = CraftEngine.instance().dataFolderPath().resolve("cache").resolve("font");
        try {
            List<Path> namespaces = FileUtils.collectNamespaces(cacheDir);
            HashMap<Key, IdAllocator> idAllocators = new HashMap<Key, IdAllocator>();
            for (Path namespace : namespaces) {
                this.processNamespace(namespace, idAllocators);
            }
            return idAllocators;
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("Failed to load cached id allocators from: " + String.valueOf(cacheDir), e);
            return Collections.emptyMap();
        }
    }

    private void processNamespace(Path namespace, Map<Key, IdAllocator> idAllocators) {
        if (!Files.isDirectory(namespace, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(namespace);){
            files.filter(this::isJsonFile).forEach(file -> this.processIdAllocatorFile(namespace.getFileName().toString(), (Path)file, idAllocators));
        }
        catch (IOException e) {
            CraftEngine.instance().logger().warn("Failed to process namespace: " + String.valueOf(namespace.getFileName()), e);
        }
    }

    private boolean isJsonFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json");
    }

    private void processIdAllocatorFile(String namespaceName, Path file, Map<Key, IdAllocator> idAllocators) {
        try {
            String fileName = FileUtils.pathWithoutExtension(file.getFileName().toString());
            Key font = Key.of(namespaceName, fileName);
            IdAllocator allocator = new IdAllocator(file);
            allocator.loadFromCache();
            idAllocators.put(font, allocator);
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to load id allocator from: " + String.valueOf(file), e);
        }
    }
}

