/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.ArrayList;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.pack.allocator.IdAllocator;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEventSource;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.command.CommandSender;

public class DebugRealStateUsageCommand
extends BukkitCommandFeature<CommandSender> {
    public DebugRealStateUsageCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.handler(context -> {
            BukkitBlockManager blockManager = this.plugin().blockManager();
            this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage((Component)Component.text((String)"Serverside block state usage:"));
            ArrayList<Component> batch = new ArrayList<Component>(100);
            IdAllocator idAllocator = blockManager.blockParser().internalIdAllocator();
            for (int i = 0; i < Config.serverSideBlocks(); ++i) {
                ImmutableBlockState state = blockManager.getImmutableBlockStateUnsafe(i + blockManager.vanillaBlockStateCount());
                if (state.isEmpty()) {
                    Component hover = Component.text((String)BlockManager.createCustomBlockKey(i).asString()).color((TextColor)NamedTextColor.GREEN);
                    batch.add(((TextComponent)Component.text((String)"|").color((TextColor)NamedTextColor.GREEN)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover)));
                } else {
                    NamedTextColor namedTextColor = idAllocator.isForced(state.toString()) ? NamedTextColor.RED : NamedTextColor.YELLOW;
                    Component hover = Component.text((String)BlockManager.createCustomBlockKey(i).asString()).color((TextColor)namedTextColor);
                    hover = hover.append((Component)Component.newline()).append(Component.text((String)state.toString()).color((TextColor)NamedTextColor.GRAY));
                    batch.add(((TextComponent)Component.text((String)"|").color((TextColor)namedTextColor)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover)));
                }
                if (batch.size() != 100) continue;
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
            if (!batch.isEmpty()) {
                this.plugin().senderFactory().wrap((CommandSender)context.sender()).sendMessage(Component.text((String)"").children(batch));
                batch.clear();
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "debug_real_state_usage";
    }
}

