/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.IntegerParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetItemCommand
extends BukkitCommandFeature<CommandSender> {
    public GetItemCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.senderType(Player.class).flag(FlagKeys.SILENT_FLAG).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(GetItemCommand.this.plugin().itemManager().cachedCustomItemSuggestions());
            }
        })).optional("amount", IntegerParser.integerParser((int)1, (int)9999)).handler(context -> {
            BukkitServerPlayer serverPlayer;
            Item<ItemStack> builtItem;
            Player player = (Player)context.sender();
            int amount = (Integer)context.getOrDefault("amount", (Object)1);
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key itemId = Key.of(namespacedKey.namespace(), namespacedKey.value());
            CustomItem customItem = CraftEngineItems.byId(itemId);
            if (customItem == null) {
                customItem = BukkitItemManager.instance().getCustomItemByPathOnly(itemId.value()).orElse(null);
                if (customItem == null) {
                    this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GET_FAILURE_NOT_EXIST, new Component[]{Component.text((String)itemId.toString())});
                    return;
                }
                itemId = customItem.id();
            }
            if ((builtItem = customItem.buildItem(serverPlayer = BukkitAdaptors.adapt(player))) != null) {
                PlayerUtils.giveItem((net.momirealms.craftengine.core.entity.player.Player)serverPlayer, amount, builtItem);
            }
            this.handleFeedback(context, MessageConstants.COMMAND_ITEM_GET_SUCCESS, new Component[]{Component.text((int)amount), Component.text((String)itemId.toString())});
        });
    }

    @Override
    public String getFeatureID() {
        return "get_item";
    }
}

