/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Optional;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.parser.standard.EnumParser;
import org.bukkit.command.CommandSender;

public class ReloadCommand
extends BukkitCommandFeature<CommandSender> {
    public static boolean RELOAD_PACK_FLAG = false;

    public ReloadCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(manager.flagBuilder("silent").withAliases(new String[]{"s"})).optional("content", EnumParser.enumParser(ReloadArgument.class)).handler(context -> {
            if (this.plugin().isReloading()) {
                this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_FAILURE_IS_LOADING, new Component[0]);
                return;
            }
            Optional optional = context.optional("content");
            ReloadArgument argument = ReloadArgument.CONFIG;
            if (optional.isPresent()) {
                argument = (ReloadArgument)((Object)((Object)optional.get()));
            }
            if (argument == ReloadArgument.CONFIG) {
                try {
                    this.plugin().reloadPlugin(this.plugin().scheduler().async(), r -> this.plugin().scheduler().sync().run(r), false).thenAccept(reloadResult -> this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_CONFIG_SUCCESS, new Component[]{Component.text((long)(reloadResult.asyncTime() + reloadResult.syncTime())), Component.text((long)reloadResult.asyncTime()), Component.text((long)reloadResult.syncTime())}));
                }
                catch (Exception e) {
                    this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_CONFIG_FAILURE, new Component[0]);
                    this.plugin().logger().warn("Failed to reload config", e);
                }
            } else if (argument == ReloadArgument.RECIPE) {
                try {
                    this.plugin().reloadPlugin(this.plugin().scheduler().async(), r -> this.plugin().scheduler().sync().run(r), true).thenAccept(reloadResult -> this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_CONFIG_SUCCESS, new Component[]{Component.text((long)(reloadResult.asyncTime() + reloadResult.syncTime())), Component.text((long)reloadResult.asyncTime()), Component.text((long)reloadResult.syncTime())}));
                }
                catch (Exception e) {
                    this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_CONFIG_FAILURE, new Component[0]);
                    this.plugin().logger().warn("Failed to reload config", e);
                }
            } else if (argument == ReloadArgument.PACK) {
                this.plugin().scheduler().executeAsync(() -> {
                    try {
                        long time1 = System.currentTimeMillis();
                        this.plugin().packManager().generateResourcePack();
                        long time2 = System.currentTimeMillis();
                        long packTime = time2 - time1;
                        this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_PACK_SUCCESS, new Component[]{Component.text((long)packTime)});
                    }
                    catch (Exception e) {
                        this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_PACK_FAILURE, new Component[0]);
                        this.plugin().logger().warn("Failed to generate resource pack", e);
                    }
                });
            } else if (argument == ReloadArgument.ALL) {
                RELOAD_PACK_FLAG = true;
                try {
                    this.plugin().reloadPlugin(this.plugin().scheduler().async(), r -> this.plugin().scheduler().sync().run(r), !VersionHelper.isFolia()).thenAcceptAsync(reloadResult -> {
                        try {
                            long time1 = System.currentTimeMillis();
                            this.plugin().packManager().generateResourcePack();
                            long time2 = System.currentTimeMillis();
                            long packTime = time2 - time1;
                            this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_ALL_SUCCESS, new Component[]{Component.text((long)(reloadResult.asyncTime() + reloadResult.syncTime() + packTime)), Component.text((long)reloadResult.asyncTime()), Component.text((long)reloadResult.syncTime()), Component.text((long)packTime)});
                        }
                        catch (Exception e) {
                            this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_PACK_FAILURE, new Component[0]);
                            this.plugin().logger().warn("Failed to generate resource pack", e);
                        }
                        finally {
                            RELOAD_PACK_FLAG = false;
                        }
                    }, this.plugin().scheduler().async());
                }
                catch (Exception e) {
                    this.handleFeedback(context, MessageConstants.COMMAND_RELOAD_ALL_FAILURE, new Component[0]);
                    this.plugin().logger().warn("Failed to generate resource pack", e);
                }
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "reload";
    }

    public static enum ReloadArgument {
        CONFIG,
        RECIPE,
        PACK,
        ALL;

    }
}

