/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.data.MultiplePlayerSelector;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SearchUsageAdminCommand
extends BukkitCommandFeature<CommandSender> {
    public SearchUsageAdminCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.required("player", MultiplePlayerSelectorParser.multiplePlayerSelectorParser((boolean)true)).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(SearchUsageAdminCommand.this.plugin().itemManager().cachedCustomItemSuggestions());
            }
        })).handler(context -> {
            MultiplePlayerSelector selector = (MultiplePlayerSelector)context.get("player");
            Collection players = selector.values();
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            for (Player player : players) {
                BukkitServerPlayer serverPlayer = this.plugin().adapt(player);
                Key itemId = Key.of(namespacedKey.namespace(), namespacedKey.value());
                List<Recipe<Object>> inRecipes = this.plugin().recipeManager().recipeByIngredient(itemId);
                if (inRecipes.isEmpty()) continue;
                this.plugin().itemBrowserManager().openRecipePage(serverPlayer, null, inRecipes, 0, 0, false);
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "search_usage_admin";
    }
}

