/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.List;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SearchUsagePlayerCommand
extends BukkitCommandFeature<CommandSender> {
    public SearchUsagePlayerCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.senderType(Player.class).handler(context -> {
            Player player = (Player)context.sender();
            BukkitServerPlayer serverPlayer = this.plugin().adapt(player);
            Item<ItemStack> item = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
            if (ItemUtils.isEmpty(item)) {
                this.handleFeedback(context, MessageConstants.COMMAND_SEARCH_USAGE_NO_ITEM, new Component[0]);
                return;
            }
            Key itemId = item.id();
            List<Recipe<Object>> inRecipes = this.plugin().recipeManager().recipeByIngredient(itemId);
            if (!inRecipes.isEmpty()) {
                this.plugin().itemBrowserManager().openRecipePage(serverPlayer, null, inRecipes, 0, 0, false);
            } else {
                this.handleFeedback(context, MessageConstants.COMMAND_SEARCH_USAGE_NOT_FOUND, new Component[0]);
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "search_usage_player";
    }
}

