/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MSoundEvents;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.PlayerUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.FlagKeys;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.bukkit.data.MultiplePlayerSelector;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.NamespacedKeyParser;
import net.momirealms.craftengine.libraries.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.flag.CommandFlag;
import net.momirealms.craftengine.libraries.cloud.parser.standard.FloatParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TotemAnimationCommand
extends BukkitCommandFeature<CommandSender> {
    public static final Object FIX_TOTEM_SOUND_PACKET = FastNMS.INSTANCE.constructor$ClientboundSoundPacket(FastNMS.INSTANCE.method$Holder$direct(MSoundEvents.TOTEM_USE), CoreReflections.instance$SoundSource$MUSIC, 0.0, -2.147483648E9, 0.0, 0.0f, 0.0f, 0L);

    public TotemAnimationCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(FlagKeys.SILENT_FLAG).flag(CommandFlag.builder((String)"no-sound")).required("players", MultiplePlayerSelectorParser.multiplePlayerSelectorParser()).required("id", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(TotemAnimationCommand.this.plugin().itemManager().cachedTotemSuggestions());
            }
        })).optional("sound", NamespacedKeyParser.namespacedKeyComponent().suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(TotemAnimationCommand.this.plugin().soundManager().cachedSoundSuggestions());
            }
        })).optional("volume", FloatParser.floatParser((float)0.0f)).optional("pitch", FloatParser.floatParser((float)0.0f, (float)2.0f)).optional("min-volume", FloatParser.floatParser((float)0.0f)).optional("min-pitch", FloatParser.floatParser((float)0.0f, (float)2.0f)).handler(context -> {
            NamespacedKey namespacedKey = (NamespacedKey)context.get("id");
            Key key = Key.of(namespacedKey.namespace(), namespacedKey.value());
            CustomItem customItem = this.plugin().itemManager().getCustomItem(key).orElse(null);
            if (customItem == null || !VersionHelper.isOrAbove1_21_2() && customItem.material().equals(ItemKeys.TOTEM_OF_UNDYING)) {
                this.handleFeedback(context, MessageConstants.COMMAND_TOTEM_NOT_TOTEM, new Component[]{Component.text((String)key.toString())});
                return;
            }
            Optional soundKey = context.optional("sound");
            SoundData soundData = null;
            if (soundKey.isPresent()) {
                float volume = ((Float)context.getOrDefault("volume", (Object)Float.valueOf(1.0f))).floatValue();
                float pitch = ((Float)context.getOrDefault("pitch", (Object)Float.valueOf(1.0f))).floatValue();
                float minVolume = ((Float)context.getOrDefault("min-volume", (Object)Float.valueOf(1.0f))).floatValue();
                float minPitch = ((Float)context.getOrDefault("min-pitch", (Object)Float.valueOf(1.0f))).floatValue();
                soundData = SoundData.of(KeyUtils.namespacedKey2Key((NamespacedKey)soundKey.get()), SoundData.SoundValue.ranged(minVolume, volume), SoundData.SoundValue.ranged(minPitch, pitch));
            }
            boolean removeSound = context.flags().hasFlag("no-sound");
            MultiplePlayerSelector selector = (MultiplePlayerSelector)context.get("players");
            Collection players = selector.values();
            for (Player player : players) {
                BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
                Item<ItemStack> item = customItem.buildItem(serverPlayer);
                if (VersionHelper.isOrAbove1_21_2()) {
                    item.setJavaComponent(ComponentTypes.DEATH_PROTECTION, Map.of());
                }
                PlayerUtils.sendTotemAnimation(serverPlayer, item, soundData, removeSound);
            }
            if (players.size() == 1) {
                this.handleFeedback(context, MessageConstants.COMMAND_TOTEM_SUCCESS_SINGLE, new Component[]{Component.text((String)namespacedKey.toString()), Component.text((String)((Player)players.iterator().next()).getName())});
            } else if (players.size() > 1) {
                this.handleFeedback(context, MessageConstants.COMMAND_TOTEM_SUCCESS_MULTIPLE, new Component[]{Component.text((String)namespacedKey.toString()), Component.text((int)players.size())});
            }
        });
    }

    @Override
    public String getFeatureID() {
        return "totem_animation";
    }
}

