/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.bukkit.api.CraftEngineFurniture;
import net.momirealms.craftengine.bukkit.api.event.FurnitureAttemptBreakEvent;
import net.momirealms.craftengine.bukkit.api.event.FurnitureBreakEvent;
import net.momirealms.craftengine.bukkit.api.event.FurnitureInteractEvent;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.entity.data.BaseEntityData;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurniture;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureManager;
import net.momirealms.craftengine.bukkit.entity.projectile.BukkitCustomProjectile;
import net.momirealms.craftengine.bukkit.entity.projectile.BukkitProjectileManager;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.behavior.FurnitureItemBehavior;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.command.feature.TotemAnimationCommand;
import net.momirealms.craftengine.bukkit.plugin.injector.ProtectedFieldVisitor;
import net.momirealms.craftengine.bukkit.plugin.network.CancelPacketException;
import net.momirealms.craftengine.bukkit.plugin.network.PacketIds;
import net.momirealms.craftengine.bukkit.plugin.network.handler.ArmorStandPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.BlockDisplayPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.CommonItemPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.EndermanPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.FurnitureCollisionPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.FurniturePacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.ItemDisplayPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.ItemFramePacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.MinecartPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.PrimedTNTPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.ProjectilePacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.handler.TextDisplayPacketHandler;
import net.momirealms.craftengine.bukkit.plugin.network.id.PacketIds1_20;
import net.momirealms.craftengine.bukkit.plugin.network.id.PacketIds1_20_5;
import net.momirealms.craftengine.bukkit.plugin.network.id.PlayPacketIdHelper;
import net.momirealms.craftengine.bukkit.plugin.network.listener.ByteBufferPacketListener;
import net.momirealms.craftengine.bukkit.plugin.network.listener.ByteBufferPacketListenerHolder;
import net.momirealms.craftengine.bukkit.plugin.network.listener.NMSPacketListener;
import net.momirealms.craftengine.bukkit.plugin.network.payload.DiscardedPayload;
import net.momirealms.craftengine.bukkit.plugin.network.payload.Payload;
import net.momirealms.craftengine.bukkit.plugin.network.payload.PayloadHelper;
import net.momirealms.craftengine.bukkit.plugin.network.payload.UnknownPayload;
import net.momirealms.craftengine.bukkit.plugin.reflection.leaves.LeavesReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.LibraryReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBlocks;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MEntityTypes;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.plugin.user.FakeBukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.bukkit.util.LegacyAuthLibUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.util.RegistryUtils;
import net.momirealms.craftengine.bukkit.util.ResourcePackUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorldManager;
import net.momirealms.craftengine.core.advancement.network.AdvancementHolder;
import net.momirealms.craftengine.core.advancement.network.AdvancementProgress;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.furniture.Furniture;
import net.momirealms.craftengine.core.entity.furniture.Seat;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.font.FontManager;
import net.momirealms.craftengine.core.font.IllegalCharacterProcessResult;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.item.recipe.network.legacy.LegacyRecipeHolder;
import net.momirealms.craftengine.core.item.recipe.network.modern.RecipeBookEntry;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.RecipeDisplay;
import net.momirealms.craftengine.core.item.trade.MerchantOffer;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.CooldownData;
import net.momirealms.craftengine.core.plugin.context.NetworkTextReplaceContext;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.plugin.network.ByteBufPacketEvent;
import net.momirealms.craftengine.core.plugin.network.ConnectionState;
import net.momirealms.craftengine.core.plugin.network.EntityPacketHandler;
import net.momirealms.craftengine.core.plugin.network.NMSPacketEvent;
import net.momirealms.craftengine.core.plugin.network.NetWorkUser;
import net.momirealms.craftengine.core.plugin.network.NetworkManager;
import net.momirealms.craftengine.core.plugin.network.PacketFlow;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Cancellable;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.ExceptionUtils;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.IntIdentityList;
import net.momirealms.craftengine.core.util.ListMonitor;
import net.momirealms.craftengine.core.util.MarkedArrayList;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.util.TriConsumer;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockHitResult;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.EntityHitResult;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.core.world.chunk.ChunkStatus;
import net.momirealms.craftengine.core.world.chunk.PalettedContainer;
import net.momirealms.craftengine.core.world.chunk.packet.BlockEntityData;
import net.momirealms.craftengine.core.world.chunk.packet.MCSection;
import net.momirealms.craftengine.core.world.collision.AABB;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.key.Keyed;
import net.momirealms.craftengine.libraries.adventure.nbt.api.BinaryTagHolder;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTDataComponentValue;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitNetworkManager
implements NetworkManager,
Listener,
PluginMessageListener {
    private static BukkitNetworkManager instance;
    private final BukkitCraftEngine plugin;
    private final Map<Class<?>, NMSPacketListener> nmsPacketListeners = new IdentityHashMap(128);
    private final ByteBufferPacketListenerHolder[] s2cGamePacketListeners;
    private final ByteBufferPacketListenerHolder[] c2sGamePacketListeners;
    private final TriConsumer<ChannelHandler, Object, Object> packetConsumer;
    private final TriConsumer<ChannelHandler, List<Object>, Object> packetsConsumer;
    private final TriConsumer<Channel, Object, Runnable> immediatePacketConsumer;
    private final TriConsumer<Channel, List<Object>, Runnable> immediatePacketsConsumer;
    private final Map<ChannelPipeline, BukkitServerPlayer> users = new ConcurrentHashMap<ChannelPipeline, BukkitServerPlayer>();
    private final Map<UUID, BukkitServerPlayer> onlineUsers = new ConcurrentHashMap<UUID, BukkitServerPlayer>();
    private final HashSet<Channel> injectedChannels = new HashSet();
    private BukkitServerPlayer[] onlineUserArray = new BukkitServerPlayer[0];
    private final PacketIds packetIds;
    private static final String CONNECTION_HANDLER_NAME = "craftengine_connection_handler";
    private static final String SERVER_CHANNEL_HANDLER_NAME = "craftengine_server_channel_handler";
    private static final String PLAYER_CHANNEL_HANDLER_NAME = "craftengine_player_channel_handler";
    private static final String PACKET_ENCODER = "craftengine_encoder";
    private static final String PACKET_DECODER = "craftengine_decoder";
    private final boolean hasModelEngine;
    private int[] blockStateRemapper;
    private int[] modBlockStateRemapper;

    public BukkitNetworkManager(BukkitCraftEngine plugin) {
        instance = this;
        this.s2cGamePacketListeners = new ByteBufferPacketListenerHolder[PlayPacketIdHelper.count(PacketFlow.CLIENTBOUND)];
        this.c2sGamePacketListeners = new ByteBufferPacketListenerHolder[PlayPacketIdHelper.count(PacketFlow.SERVERBOUND)];
        this.hasModelEngine = Bukkit.getPluginManager().getPlugin("ModelEngine") != null;
        this.plugin = plugin;
        this.packetIds = VersionHelper.isOrAbove1_20_5() ? new PacketIds1_20_5() : new PacketIds1_20();
        this.registerPacketListeners();
        PayloadHelper.registerDataTypes();
        this.packetConsumer = FastNMS.INSTANCE::method$Connection$send;
        this.packetsConsumer = (connection, packets, sendListener) -> {
            Object bundle = FastNMS.INSTANCE.constructor$ClientboundBundlePacket((List<Object>)packets);
            this.packetConsumer.accept((ChannelHandler)connection, bundle, sendListener);
        };
        this.immediatePacketConsumer = (channel, packet, sendListener) -> {
            ChannelFuture future = channel.writeAndFlush(packet);
            if (sendListener == null) {
                return;
            }
            future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                sendListener.run();
                if (!channelFuture.isSuccess()) {
                    channelFuture.channel().pipeline().fireExceptionCaught(channelFuture.cause());
                }
            }));
        };
        this.immediatePacketsConsumer = (channel, packets, sendListener) -> {
            Object bundle = FastNMS.INSTANCE.constructor$ClientboundBundlePacket((List<Object>)packets);
            this.immediatePacketConsumer.accept((Channel)channel, bundle, (Runnable)sendListener);
        };
        this.plugin.javaPlugin().getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin.javaPlugin(), "craftengine:payload", (PluginMessageListener)this);
        this.plugin.javaPlugin().getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin.javaPlugin(), "craftengine:payload");
        try {
            Object server = FastNMS.INSTANCE.method$MinecraftServer$getServer();
            Object serverConnection = CoreReflections.field$MinecraftServer$connection.get(server);
            List channels = (List)CoreReflections.field$ServerConnectionListener$channels.get(serverConnection);
            ListMonitor<ChannelFuture> monitor = new ListMonitor<ChannelFuture>(channels, future -> {
                Channel channel = future.channel();
                this.injectServerChannel(channel);
                this.injectedChannels.add(channel);
            }, object -> {});
            CoreReflections.field$ServerConnectionListener$channels.set(serverConnection, monitor);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to init server connection", e);
        }
        if (VersionHelper.isLeaves()) {
            this.injectLeavesBotList();
        }
    }

    public static BukkitNetworkManager instance() {
        return instance;
    }

    @Override
    public int remapBlockState(int stateId, boolean enableMod) {
        return enableMod ? this.modBlockStateRemapper[stateId] : this.blockStateRemapper[stateId];
    }

    private void registerNMSPacketConsumer(NMSPacketListener listener, @Nullable Class<?> packet) {
        if (packet == null) {
            return;
        }
        this.nmsPacketListeners.put(packet, listener);
    }

    private void registerS2CGamePacketListener(ByteBufferPacketListener listener, int id, String name) {
        if (id == -1) {
            return;
        }
        if (id < 0 || id >= this.s2cGamePacketListeners.length) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        this.s2cGamePacketListeners[id] = new ByteBufferPacketListenerHolder(name, listener);
    }

    private void registerC2SGamePacketListener(ByteBufferPacketListener listener, int id, String name) {
        if (id == -1) {
            return;
        }
        if (id < 0 || id >= this.c2sGamePacketListeners.length) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        this.c2sGamePacketListeners[id] = new ByteBufferPacketListenerHolder(name, listener);
    }

    public void addFakePlayer(Player player) {
        FakeBukkitServerPlayer fakePlayer = new FakeBukkitServerPlayer(this.plugin);
        fakePlayer.setPlayer(player);
        this.onlineUsers.put(player.getUniqueId(), fakePlayer);
        this.resetUserArray();
    }

    public boolean removeFakePlayer(Player player) {
        BukkitServerPlayer fakePlayer = this.onlineUsers.get(player.getUniqueId());
        if (!(fakePlayer instanceof FakeBukkitServerPlayer)) {
            return false;
        }
        this.onlineUsers.remove(player.getUniqueId());
        this.resetUserArray();
        this.saveCooldown(player, fakePlayer.cooldown());
        return true;
    }

    private void injectLeavesBotList() {
        try {
            Object botList = LeavesReflections.field$BotList$INSTANCE.get(null);
            List bots = (List)LeavesReflections.field$BotList$bots.get(botList);
            ListMonitor<Object> monitor = new ListMonitor<Object>(bots, bot -> this.addFakePlayer(FastNMS.INSTANCE.method$ServerPlayer$getBukkitEntity(bot)), bot -> this.removeFakePlayer(FastNMS.INSTANCE.method$ServerPlayer$getBukkitEntity(bot)));
            LeavesReflections.field$BotList$bots.set(botList, monitor);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().severe("Failed to inject leaves bot list");
        }
    }

    public void registerBlockStatePacketListeners(int[] blockStateMappings) {
        int mappedId;
        int i;
        int stoneId = BlockStateUtils.blockStateToId(MBlocks.STONE$defaultState);
        int vanillaBlocks = BlockStateUtils.vanillaBlockStateCount();
        int[] newMappings = new int[blockStateMappings.length];
        int[] newMappingsMOD = new int[blockStateMappings.length];
        for (i = 0; i < vanillaBlocks; ++i) {
            mappedId = blockStateMappings[i];
            if (mappedId != -1) {
                newMappings[i] = mappedId;
                newMappingsMOD[i] = mappedId;
                continue;
            }
            newMappings[i] = i;
            newMappingsMOD[i] = i;
        }
        for (i = vanillaBlocks; i < blockStateMappings.length; ++i) {
            mappedId = blockStateMappings[i];
            newMappings[i] = mappedId != -1 ? mappedId : stoneId;
            newMappingsMOD[i] = i;
        }
        this.blockStateRemapper = newMappings;
        this.modBlockStateRemapper = newMappingsMOD;
        this.registerS2CGamePacketListener(new LevelChunkWithLightListener(newMappings, newMappingsMOD, newMappings.length, RegistryUtils.currentBiomeRegistrySize()), this.packetIds.clientboundLevelChunkWithLightPacket(), "ClientboundLevelChunkWithLightPacket");
        this.registerS2CGamePacketListener(new SectionBlockUpdateListener(newMappings, newMappingsMOD), this.packetIds.clientboundSectionBlocksUpdatePacket(), "ClientboundSectionBlocksUpdatePacket");
        this.registerS2CGamePacketListener(new BlockUpdateListener(newMappings, newMappingsMOD), this.packetIds.clientboundBlockUpdatePacket(), "ClientboundBlockUpdatePacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_21_4() ? new LevelParticleListener1_21_4(newMappings, newMappingsMOD) : (VersionHelper.isOrAbove1_20_5() ? new LevelParticleListener1_20_5(newMappings, newMappingsMOD) : new LevelParticleListener1_20(newMappings, newMappingsMOD)), this.packetIds.clientboundLevelParticlesPacket(), "ClientboundLevelParticlesPacket");
        this.registerS2CGamePacketListener(new LevelEventListener(newMappings, newMappingsMOD), this.packetIds.clientboundLevelEventPacket(), "ClientboundLevelEventPacket");
    }

    private void registerPacketListeners() {
        this.registerNMSPacketConsumer(new PlayerInfoUpdateListener(), NetworkReflections.clazz$ClientboundPlayerInfoUpdatePacket);
        this.registerNMSPacketConsumer(new PlayerActionListener(), NetworkReflections.clazz$ServerboundPlayerActionPacket);
        this.registerNMSPacketConsumer(new SwingListener(), NetworkReflections.clazz$ServerboundSwingPacket);
        this.registerNMSPacketConsumer(new HelloListener(), NetworkReflections.clazz$ServerboundHelloPacket);
        this.registerNMSPacketConsumer(new UseItemOnListener(), NetworkReflections.clazz$ServerboundUseItemOnPacket);
        this.registerNMSPacketConsumer(new PickItemFromBlockListener(), NetworkReflections.clazz$ServerboundPickItemFromBlockPacket);
        this.registerNMSPacketConsumer(new PickItemFromEntityListener(), NetworkReflections.clazz$ServerboundPickItemFromEntityPacket);
        this.registerNMSPacketConsumer(new SetCreativeSlotListener(), NetworkReflections.clazz$ServerboundSetCreativeModeSlotPacket);
        this.registerNMSPacketConsumer(new LoginListener(), NetworkReflections.clazz$ClientboundLoginPacket);
        this.registerNMSPacketConsumer(new RespawnListener(), NetworkReflections.clazz$ClientboundRespawnPacket);
        this.registerNMSPacketConsumer(new SyncEntityPositionListener(), NetworkReflections.clazz$ClientboundEntityPositionSyncPacket);
        this.registerNMSPacketConsumer(new RenameItemListener(), NetworkReflections.clazz$ServerboundRenameItemPacket);
        this.registerNMSPacketConsumer(new SignUpdateListener(), NetworkReflections.clazz$ServerboundSignUpdatePacket);
        this.registerNMSPacketConsumer(new EditBookListener(), NetworkReflections.clazz$ServerboundEditBookPacket);
        this.registerNMSPacketConsumer(new CustomPayloadListener1_20_2(), VersionHelper.isOrAbove1_20_2() ? NetworkReflections.clazz$ServerboundCustomPayloadPacket : null);
        this.registerNMSPacketConsumer(new ResourcePackResponseListener(), NetworkReflections.clazz$ServerboundResourcePackPacket);
        this.registerNMSPacketConsumer(new EntityEventListener(), NetworkReflections.clazz$ClientboundEntityEventPacket);
        this.registerNMSPacketConsumer(new MovePosAndRotateEntityListener(), NetworkReflections.clazz$ClientboundMoveEntityPacket$PosRot);
        this.registerNMSPacketConsumer(new MovePosEntityListener(), NetworkReflections.clazz$ClientboundMoveEntityPacket$Pos);
        this.registerNMSPacketConsumer(new RotateHeadListener(), NetworkReflections.clazz$ClientboundRotateHeadPacket);
        this.registerNMSPacketConsumer(new SetEntityMotionListener(), NetworkReflections.clazz$ClientboundSetEntityMotionPacket);
        this.registerNMSPacketConsumer(new FinishConfigurationListener(), NetworkReflections.clazz$ClientboundFinishConfigurationPacket);
        this.registerNMSPacketConsumer(new LoginFinishedListener(), NetworkReflections.clazz$ClientboundLoginFinishedPacket);
        this.registerNMSPacketConsumer(new UpdateTagsListener(), NetworkReflections.clazz$ClientboundUpdateTagsPacket);
        this.registerNMSPacketConsumer(new ContainerClickListener1_21_5(), VersionHelper.isOrAbove1_21_5() ? NetworkReflections.clazz$ServerboundContainerClickPacket : null);
        this.registerS2CGamePacketListener(new ForgetLevelChunkListener(), this.packetIds.clientboundForgetLevelChunkPacket(), "ClientboundForgetLevelChunkPacket");
        this.registerS2CGamePacketListener(new SetScoreListener1_20_3(), VersionHelper.isOrAbove1_20_3() ? this.packetIds.clientboundSetScorePacket() : -1, "ClientboundSetScorePacket");
        this.registerS2CGamePacketListener(new AddRecipeBookListener(), this.packetIds.clientboundRecipeBookAddPacket(), "ClientboundRecipeBookAddPacket");
        this.registerS2CGamePacketListener(new PlaceGhostRecipeListener(), this.packetIds.clientboundPlaceGhostRecipePacket(), "ClientboundPlaceGhostRecipePacket");
        this.registerS2CGamePacketListener(new UpdateRecipesListener(), this.packetIds.clientboundUpdateRecipesPacket(), "ClientboundUpdateRecipesPacket");
        this.registerS2CGamePacketListener(new UpdateAdvancementsListener(), this.packetIds.clientboundUpdateAdvancementsPacket(), "ClientboundUpdateAdvancementsPacket");
        this.registerS2CGamePacketListener(new RemoveEntityListener(), this.packetIds.clientboundRemoveEntitiesPacket(), "ClientboundRemoveEntitiesPacket");
        this.registerS2CGamePacketListener(new SoundListener(), this.packetIds.clientboundSoundPacket(), "ClientboundSoundPacket");
        this.registerS2CGamePacketListener(new ContainerSetContentListener(), this.packetIds.clientboundContainerSetContentPacket(), "ClientboundContainerSetContentPacket");
        this.registerS2CGamePacketListener(new ContainerSetSlotListener(), this.packetIds.clientboundContainerSetSlotPacket(), "ClientboundContainerSetSlotPacket");
        this.registerS2CGamePacketListener(new SetCursorItemListener(), this.packetIds.clientboundSetCursorItemPacket(), "ClientboundSetCursorItemPacket");
        this.registerS2CGamePacketListener(new SetEquipmentListener(), this.packetIds.clientboundSetEquipmentPacket(), "ClientboundSetEquipmentPacket");
        this.registerS2CGamePacketListener(new SetPlayerInventoryListener1_21_2(), VersionHelper.isOrAbove1_21_2() ? this.packetIds.clientboundSetPlayerInventoryPacket() : -1, "ClientboundSetPlayerInventoryPacket");
        this.registerS2CGamePacketListener(new SetEntityDataListener(), this.packetIds.clientboundSetEntityDataPacket(), "ClientboundSetEntityDataPacket");
        this.registerC2SGamePacketListener(new SetCreativeModeSlotListener(), this.packetIds.serverboundSetCreativeModeSlotPacket(), "ServerboundSetCreativeModeSlotPacket");
        this.registerC2SGamePacketListener(new ContainerClick1_20(), VersionHelper.isOrAbove1_21_5() ? -1 : this.packetIds.serverboundContainerClickPacket(), "ServerboundContainerClickPacket");
        this.registerC2SGamePacketListener(new InteractEntityListener(), this.packetIds.serverboundInteractPacket(), "ServerboundInteractPacket");
        this.registerC2SGamePacketListener(new CustomPayloadListener1_20(), VersionHelper.isOrAbove1_20_2() ? -1 : this.packetIds.serverboundCustomPayloadPacket(), "ServerboundCustomPayloadPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_5() ? new MerchantOffersListener1_20_5() : new MerchantOffersListener1_20(), this.packetIds.clientBoundMerchantOffersPacket(), "ClientboundMerchantOffersPacket");
        this.registerS2CGamePacketListener(new AddEntityListener(RegistryUtils.currentEntityTypeRegistrySize()), this.packetIds.clientboundAddEntityPacket(), "ClientboundAddEntityPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new OpenScreenListener1_20_3() : new OpenScreenListener1_20(), this.packetIds.clientboundOpenScreenPacket(), "ClientboundOpenScreenPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new SystemChatListener1_20_3() : new SystemChatListener1_20(), this.packetIds.clientboundSystemChatPacket(), "ClientboundSystemChatPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new SetActionBarListener1_20_3() : new SetActionBarListener1_20(), this.packetIds.clientboundSetActionBarTextPacket(), "ClientboundSetActionBarTextPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new TabListListener1_20_3() : new TabListListener1_20(), this.packetIds.clientboundTabListPacket(), "ClientboundTabListPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new SetTitleListener1_20_3() : new SetTitleListener1_20(), this.packetIds.clientboundSetTitleTextPacket(), "ClientboundSetTitleTextPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new SetSubtitleListener1_20_3() : new SetSubtitleListener1_20(), this.packetIds.clientboundSetSubtitleTextPacket(), "ClientboundSetSubtitleTextPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new BossEventListener1_20_3() : new BossEventListener1_20(), this.packetIds.clientboundBossEventPacket(), "ClientboundBossEventPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new TeamListener1_20_3() : new TeamListener1_20(), this.packetIds.clientboundSetPlayerTeamPacket(), "ClientboundSetPlayerTeamPacket");
        this.registerS2CGamePacketListener(VersionHelper.isOrAbove1_20_3() ? new SetObjectiveListener1_20_3() : new SetObjectiveListener1_20(), this.packetIds.clientboundSetObjectivePacket(), "ClientboundSetObjectivePacket");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        BukkitServerPlayer user = (BukkitServerPlayer)this.getUser(player);
        if (user != null) {
            user.setPlayer(player);
            this.onlineUsers.put(player.getUniqueId(), user);
            this.resetUserArray();
            if (VersionHelper.isFolia()) {
                player.getScheduler().runAtFixedRate((Plugin)this.plugin.javaPlugin(), t -> user.tick(), () -> {}, 1L, 1L);
            }
            user.sendPacket(TotemAnimationCommand.FIX_TOTEM_SOUND_PACKET, false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        BukkitServerPlayer serverPlayer = this.onlineUsers.remove(player.getUniqueId());
        if (serverPlayer != null) {
            this.resetUserArray();
            this.saveCooldown(player, serverPlayer.cooldown());
        }
    }

    private void saveCooldown(Player player, CooldownData cd) {
        if (cd != null && player != null) {
            try {
                byte[] data = CooldownData.toBytes(cd);
                player.getPersistentDataContainer().set(KeyUtils.toNamespacedKey(CooldownData.COOLDOWN_KEY), PersistentDataType.BYTE_ARRAY, (Object)data);
            }
            catch (IOException e) {
                player.getPersistentDataContainer().remove(KeyUtils.toNamespacedKey(CooldownData.COOLDOWN_KEY));
                this.plugin.logger().warn("Failed to save cooldown for player " + player.getName(), e);
            }
        }
    }

    private void resetUserArray() {
        this.onlineUserArray = this.onlineUsers.values().toArray(new BukkitServerPlayer[0]);
    }

    public BukkitServerPlayer[] onlineUsers() {
        return this.onlineUserArray;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
    }

    @Override
    public void init() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        for (Channel channel : this.injectedChannels) {
            this.uninjectServerChannel(channel);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.handleDisconnection(this.getChannel(player));
        }
        this.injectedChannels.clear();
    }

    @Override
    public void setUser(Channel channel, NetWorkUser user) {
        ChannelPipeline pipeline = channel.pipeline();
        this.users.put(pipeline, (BukkitServerPlayer)user);
    }

    @Override
    public NetWorkUser getUser(@NotNull Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        return this.users.get(pipeline);
    }

    @Override
    public NetWorkUser removeUser(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        return this.users.remove(pipeline);
    }

    @Override
    public Channel getChannel(net.momirealms.craftengine.core.entity.player.Player player) {
        return this.getChannel((Player)player.platformPlayer());
    }

    @Nullable
    public NetWorkUser getUser(Player player) {
        return this.getUser(this.getChannel(player));
    }

    @Nullable
    public NetWorkUser getOnlineUser(Player player) {
        return this.onlineUsers.get(player.getUniqueId());
    }

    @NotNull
    public Channel getChannel(Player player) {
        return FastNMS.INSTANCE.field$Connection$channel(FastNMS.INSTANCE.field$ServerGamePacketListenerImpl$connection(FastNMS.INSTANCE.field$Player$connection(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player))));
    }

    @Override
    public void sendPacket(@NotNull NetWorkUser player, Object packet, boolean immediately, Runnable sendListener) {
        if (player.isFakePlayer()) {
            return;
        }
        if (immediately) {
            this.immediatePacketConsumer.accept(player.nettyChannel(), packet, sendListener);
        } else {
            this.packetConsumer.accept(player.connection(), packet, sendListener != null ? FastNMS.INSTANCE.method$PacketSendListener$thenRun(sendListener) : null);
        }
    }

    @Override
    public void sendPackets(@NotNull NetWorkUser player, List<Object> packet, boolean immediately, Runnable sendListener) {
        if (player.isFakePlayer()) {
            return;
        }
        if (immediately) {
            this.immediatePacketsConsumer.accept(player.nettyChannel(), packet, sendListener);
        } else {
            this.packetsConsumer.accept(player.connection(), packet, sendListener != null ? FastNMS.INSTANCE.method$PacketSendListener$thenRun(sendListener) : null);
        }
    }

    public boolean hasModelEngine() {
        return this.hasModelEngine;
    }

    public void simulatePacket(@NotNull NetWorkUser player, Object packet) {
        Channel channel = player.nettyChannel();
        if (channel != null && channel.isOpen()) {
            List handlerNames = channel.pipeline().names();
            if (handlerNames.contains("via-encoder")) {
                channel.pipeline().context("via-decoder").fireChannelRead(packet);
            } else if (handlerNames.contains("ps_decoder_transformer")) {
                channel.pipeline().context("ps_decoder_transformer").fireChannelRead(packet);
            } else if (handlerNames.contains("decompress")) {
                channel.pipeline().context("decompress").fireChannelRead(packet);
            } else if (handlerNames.contains("decrypt")) {
                channel.pipeline().context("decrypt").fireChannelRead(packet);
            } else {
                channel.pipeline().context("splitter").fireChannelRead(packet);
            }
        } else {
            ((ByteBuf)packet).release();
        }
    }

    private void injectServerChannel(Channel serverChannel) {
        ChannelPipeline pipeline = serverChannel.pipeline();
        ChannelHandler connectionHandler = pipeline.get(CONNECTION_HANDLER_NAME);
        if (connectionHandler != null) {
            pipeline.remove(CONNECTION_HANDLER_NAME);
        }
        if (pipeline.get("SpigotNettyServerChannelHandler#0") != null) {
            pipeline.addAfter("SpigotNettyServerChannelHandler#0", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else if (pipeline.get("floodgate-init") != null) {
            pipeline.addAfter("floodgate-init", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else if (pipeline.get("MinecraftPipeline#0") != null) {
            pipeline.addAfter("MinecraftPipeline#0", CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        } else {
            pipeline.addFirst(CONNECTION_HANDLER_NAME, (ChannelHandler)new ServerChannelHandler());
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Channel channel = this.getChannel(player);
            NetWorkUser user = this.getUser(player);
            if (user != null) continue;
            user = new BukkitServerPlayer(this.plugin, channel);
            ((BukkitServerPlayer)user).setPlayer(player);
            this.injectChannel(channel, ConnectionState.PLAY);
        }
    }

    private void uninjectServerChannel(Channel channel) {
        if (channel.pipeline().get(CONNECTION_HANDLER_NAME) != null) {
            channel.pipeline().remove(CONNECTION_HANDLER_NAME);
        }
    }

    public void handleDisconnection(Channel channel) {
        NetWorkUser user = this.removeUser(channel);
        if (user == null) {
            return;
        }
        if (channel.pipeline().get(PLAYER_CHANNEL_HANDLER_NAME) != null) {
            channel.pipeline().remove(PLAYER_CHANNEL_HANDLER_NAME);
        }
        if (channel.pipeline().get(PACKET_ENCODER) != null) {
            channel.pipeline().remove(PACKET_ENCODER);
        }
        if (channel.pipeline().get(PACKET_DECODER) != null) {
            channel.pipeline().remove(PACKET_DECODER);
        }
    }

    public void injectChannel(Channel channel, ConnectionState state) {
        if (BukkitNetworkManager.isFakeChannel(channel)) {
            return;
        }
        BukkitServerPlayer user = new BukkitServerPlayer(this.plugin, channel);
        if (channel.pipeline().get("splitter") == null) {
            channel.close();
            return;
        }
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get(PACKET_ENCODER) != null) {
            pipeline.remove(PACKET_ENCODER);
        }
        if (pipeline.get(PACKET_DECODER) != null) {
            pipeline.remove(PACKET_DECODER);
        }
        for (Map.Entry entry : pipeline.toMap().entrySet()) {
            if (!NetworkReflections.clazz$Connection.isAssignableFrom(((ChannelHandler)entry.getValue()).getClass())) continue;
            pipeline.addBefore((String)entry.getKey(), PLAYER_CHANNEL_HANDLER_NAME, (ChannelHandler)new PluginChannelHandler(user));
            break;
        }
        String decoderName = pipeline.names().contains("inbound_config") ? "inbound_config" : "decoder";
        pipeline.addBefore(decoderName, PACKET_DECODER, (ChannelHandler)new PluginChannelDecoder(user));
        String encoderName = pipeline.names().contains("outbound_config") ? "outbound_config" : "encoder";
        pipeline.addBefore(encoderName, PACKET_ENCODER, (ChannelHandler)new PluginChannelEncoder(user));
        channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> this.handleDisconnection(user.nettyChannel())));
        this.setUser(channel, user);
    }

    public static boolean isFakeChannel(Object channel) {
        return channel.getClass().getSimpleName().equals("FakeChannel") || channel.getClass().getSimpleName().equals("SpoofedChannel");
    }

    private void onNMSPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
        Debugger.PACKET.debug(() -> "[C->S]" + String.valueOf(packet.getClass()));
        this.handleReceiveNMSPacket(user, event, packet);
    }

    private void onNMSPacketSend(NetWorkUser player, NMSPacketEvent event, Object packet) {
        if (NetworkReflections.clazz$ClientboundBundlePacket.isInstance(packet)) {
            Iterable<Object> packets = FastNMS.INSTANCE.method$ClientboundBundlePacket$subPackets(packet);
            for (Object p : packets) {
                this.onNMSPacketSend(player, event, p);
            }
        } else {
            Debugger.PACKET.debug(() -> "[S->C]" + String.valueOf(packet.getClass()));
            this.handleSendNMSPacket(player, event, packet);
        }
    }

    protected void handleReceiveNMSPacket(NetWorkUser user, NMSPacketEvent event, Object packet) {
        NMSPacketListener nmsPacketListener = this.nmsPacketListeners.get(packet.getClass());
        if (nmsPacketListener != null) {
            try {
                nmsPacketListener.onPacketReceive(user, event, packet);
            }
            catch (Throwable t) {
                this.plugin.logger().warn("An error occurred when handling packet " + String.valueOf(packet.getClass()), t);
            }
        }
    }

    protected void handleSendNMSPacket(NetWorkUser user, NMSPacketEvent event, Object packet) {
        NMSPacketListener nmsPacketListener = this.nmsPacketListeners.get(packet.getClass());
        if (nmsPacketListener != null) {
            try {
                nmsPacketListener.onPacketSend(user, event, packet);
            }
            catch (Throwable t) {
                this.plugin.logger().warn("An error occurred when handling packet " + String.valueOf(packet.getClass()), t);
            }
        }
    }

    protected void handleS2CByteBufPacket(NetWorkUser user, ByteBufPacketEvent event) {
        int packetID = event.packetID();
        ByteBufferPacketListenerHolder holder = this.s2cGamePacketListeners[packetID];
        if (holder != null) {
            try {
                holder.listener().onPacketSend(user, event);
            }
            catch (Throwable t) {
                this.plugin.logger().warn("An error occurred when handling packet " + holder.id(), t);
            }
        }
    }

    protected void handleC2SByteBufPacket(NetWorkUser user, ByteBufPacketEvent event) {
        int packetID = event.packetID();
        ByteBufferPacketListenerHolder holder = this.c2sGamePacketListeners[packetID];
        if (holder != null) {
            try {
                holder.listener().onPacketReceive(user, event);
            }
            catch (Throwable t) {
                this.plugin.logger().warn("An error occurred when handling packet " + holder.id(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(ChannelHandlerContext ctx, ByteBuf input) {
        ChannelHandler compressor = ctx.pipeline().get("compress");
        ByteBuf temp = ctx.alloc().buffer();
        try {
            if (compressor != null) {
                BukkitNetworkManager.callEncode(compressor, ctx, input, temp);
            }
        }
        finally {
            input.clear().writeBytes(temp);
            temp.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(ChannelHandlerContext ctx, ByteBuf input, ByteBuf output) {
        ChannelHandler decompressor = ctx.pipeline().get("decompress");
        if (decompressor != null) {
            ByteBuf temp = (ByteBuf)BukkitNetworkManager.callDecode(decompressor, ctx, input).getFirst();
            try {
                output.clear().writeBytes(temp);
            }
            finally {
                temp.release();
            }
        }
    }

    private static void callEncode(Object encoder, ChannelHandlerContext ctx, ByteBuf msg, ByteBuf output) {
        try {
            LibraryReflections.method$messageToByteEncoder$encode.invoke(encoder, ctx, msg, output);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call encode", e);
        }
    }

    public static List<Object> callDecode(Object decoder, Object ctx, Object input) {
        ArrayList<Object> output = new ArrayList<Object>();
        try {
            LibraryReflections.method$byteToMessageDecoder$decode.invoke(decoder, ctx, input, output);
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to call decode", e);
        }
        return output;
    }

    private static void pickItem(Player player, net.momirealms.craftengine.core.util.Key itemId, @Nullable Object blockPos, @Nullable Object entity) throws Throwable {
        ItemStack itemStack = BukkitCraftEngine.instance().itemManager().buildCustomItemStack(itemId, BukkitCraftEngine.instance().adapt(player));
        if (itemStack == null) {
            CraftEngine.instance().logger().warn("Item: " + String.valueOf(itemId) + " is not a valid item");
            return;
        }
        assert (CoreReflections.method$ServerGamePacketListenerImpl$tryPickItem != null);
        if (VersionHelper.isOrAbove1_21_5()) {
            CoreReflections.method$ServerGamePacketListenerImpl$tryPickItem.invoke(CoreReflections.methodHandle$ServerPlayer$connectionGetter.invokeExact(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player)), FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(itemStack), blockPos, entity, true);
        } else {
            CoreReflections.method$ServerGamePacketListenerImpl$tryPickItem.invoke(CoreReflections.methodHandle$ServerPlayer$connectionGetter.invokeExact(FastNMS.INSTANCE.method$CraftPlayer$getHandle(player)), FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(itemStack));
        }
    }

    public HoverEvent.ShowItem replaceShowItem(HoverEvent.ShowItem showItem, BukkitServerPlayer player) {
        Object nmsItemStack;
        if (VersionHelper.COMPONENT_RELEASE) {
            DataResult nmsItemStackResult;
            Optional result;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("count", showItem.count());
            itemTag.putString("id", showItem.item().asMinimalString());
            Map components = showItem.dataComponents();
            if (!components.isEmpty()) {
                CompoundTag componentsTag = new CompoundTag();
                Map componentsMap = showItem.dataComponentsAs(NBTDataComponentValue.class);
                for (Map.Entry entry : componentsMap.entrySet()) {
                    componentsTag.put(((Key)entry.getKey()).asMinimalString(), ((NBTDataComponentValue)entry.getValue()).tag());
                }
                itemTag.put("components", componentsTag);
            }
            if ((result = (nmsItemStackResult = CoreReflections.instance$ItemStack$CODEC.parse(MRegistryOps.SPARROW_NBT, (Object)itemTag)).result()).isEmpty()) {
                return showItem;
            }
            nmsItemStack = result.get();
        } else {
            Object compoundTag = FastNMS.INSTANCE.constructor$CompoundTag();
            FastNMS.INSTANCE.method$CompoundTag$put(compoundTag, "Count", FastNMS.INSTANCE.constructor$IntTag(showItem.count()));
            FastNMS.INSTANCE.method$CompoundTag$put(compoundTag, "id", FastNMS.INSTANCE.constructor$StringTag(showItem.item().asMinimalString()));
            BinaryTagHolder nbt = showItem.nbt();
            if (nbt != null) {
                try {
                    Object nmsTag = FastNMS.INSTANCE.method$TagParser$parseCompoundFully(nbt.string());
                    FastNMS.INSTANCE.method$CompoundTag$put(compoundTag, "tag", nmsTag);
                }
                catch (CommandSyntaxException ignored) {
                    return showItem;
                }
            }
            nmsItemStack = FastNMS.INSTANCE.method$ItemStack$of(compoundTag);
        }
        Item<ItemStack> wrap = this.plugin.itemManager().wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(nmsItemStack));
        Item<ItemStack> clientBoundItem = this.plugin.itemManager().s2c(wrap, player);
        if (clientBoundItem.isEmpty()) {
            return showItem;
        }
        Key id = KeyUtils.toAdventureKey(clientBoundItem.vanillaId());
        int count = clientBoundItem.count();
        if (VersionHelper.COMPONENT_RELEASE) {
            DataResult tagDataResult = CoreReflections.instance$ItemStack$CODEC.encodeStart(MRegistryOps.SPARROW_NBT, clientBoundItem.getLiteralObject());
            Optional result = tagDataResult.result();
            if (result.isEmpty()) {
                return showItem;
            }
            CompoundTag itemTag = (CompoundTag)result.get();
            CompoundTag componentsTag = itemTag.getCompound("components");
            if (componentsTag != null) {
                HashMap<Key, NBTDataComponentValue> componentsMap = new HashMap<Key, NBTDataComponentValue>();
                for (Map.Entry<String, Tag> entry : componentsTag.entrySet()) {
                    componentsMap.put(Key.key((String)entry.getKey()), NBTDataComponentValue.of(entry.getValue()));
                }
                return HoverEvent.ShowItem.showItem((Keyed)id, (int)count, componentsMap);
            }
            return HoverEvent.ShowItem.showItem((Key)id, (int)count);
        }
        Object tag = FastNMS.INSTANCE.method$ItemStack$getTag(clientBoundItem.getLiteralObject());
        if (tag != null) {
            return HoverEvent.ShowItem.showItem((Key)id, (int)count, (BinaryTagHolder)BinaryTagHolder.binaryTagHolder((String)tag.toString()));
        }
        return HoverEvent.ShowItem.showItem((Key)id, (int)count);
    }

    public static class LevelChunkWithLightListener
    implements ByteBufferPacketListener {
        private static BiConsumer<NetWorkUser, PalettedContainer<Integer>> biomeRemapper = null;
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;
        private final IntIdentityList biomeList;
        private final IntIdentityList blockList;

        public static void setBiomeRemapper(BiConsumer<NetWorkUser, PalettedContainer<Integer>> remapper) {
            biomeRemapper = remapper;
        }

        public static void remapBiomes(NetWorkUser user, PalettedContainer<Integer> biomes) {
            if (biomeRemapper != null) {
                biomeRemapper.accept(user, biomes);
            }
        }

        public LevelChunkWithLightListener(int[] blockStateMapper, int[] modBlockStateMapper, int blockRegistrySize, int biomeRegistrySize) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
            this.biomeList = new IntIdentityList(biomeRegistrySize);
            this.blockList = new IntIdentityList(blockRegistrySize);
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int chunkX = buf.readInt();
            int chunkZ = buf.readInt();
            boolean named = !VersionHelper.isOrAbove1_20_2();
            int heightmapsCount = 0;
            HashMap<Integer, long[]> heightmapsMap = null;
            Tag heightmaps = null;
            if (VersionHelper.isOrAbove1_21_5()) {
                heightmapsMap = new HashMap<Integer, long[]>();
                heightmapsCount = buf.readVarInt();
                for (int i = 0; i < heightmapsCount; ++i) {
                    int key = buf.readVarInt();
                    long[] value = buf.readLongArray();
                    heightmapsMap.put(key, value);
                }
            } else {
                heightmaps = buf.readNbt(named);
            }
            int varInt = buf.readVarInt();
            byte[] buffer = new byte[varInt];
            buf.readBytes(buffer);
            int blockEntitiesDataCount = buf.readVarInt();
            ArrayList<BlockEntityData> blockEntitiesData = new ArrayList<BlockEntityData>();
            for (int i = 0; i < blockEntitiesDataCount; ++i) {
                byte packedXZ = buf.readByte();
                short y = buf.readShort();
                int type = buf.readVarInt();
                Tag tag = buf.readNbt(named);
                BlockEntityData blockEntityData = new BlockEntityData(packedXZ, y, type, tag);
                blockEntitiesData.add(blockEntityData);
            }
            BitSet skyYMask = buf.readBitSet();
            BitSet blockYMask = buf.readBitSet();
            BitSet emptySkyYMask = buf.readBitSet();
            BitSet emptyBlockYMask = buf.readBitSet();
            List<byte[]> skyUpdates = buf.readByteArrayList(2048);
            List<byte[]> blockUpdates = buf.readByteArrayList(2048);
            if (user.clientModEnabled()) {
                byteBuf = Unpooled.copiedBuffer((byte[])buffer);
                FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf((ByteBuf)byteBuf);
                newBuf = new FriendlyByteBuf(Unpooled.buffer());
                count = player.clientSideSectionCount();
                for (i = 0; i < count; ++i) {
                    mcSection = new MCSection(user.clientBlockList(), this.blockList, this.biomeList);
                    mcSection.readPacket(friendlyByteBuf);
                    container = mcSection.blockStateContainer();
                    LevelChunkWithLightListener.remapBiomes(user, mcSection.biomeContainer());
                    palette = container.data().palette();
                    if (palette.canRemap()) {
                        palette.remap(s -> this.modBlockStateMapper[s]);
                    } else {
                        for (j = 0; j < 4096; ++j) {
                            state = container.get(j);
                            newState = this.modBlockStateMapper[state];
                            if (newState == state) continue;
                            container.set(j, newState);
                        }
                    }
                    mcSection.writePacket(newBuf);
                }
                buffer = newBuf.array();
            } else {
                byteBuf = Unpooled.copiedBuffer((byte[])buffer);
                FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf((ByteBuf)byteBuf);
                newBuf = new FriendlyByteBuf(Unpooled.buffer());
                count = player.clientSideSectionCount();
                for (i = 0; i < count; ++i) {
                    mcSection = new MCSection(user.clientBlockList(), this.blockList, this.biomeList);
                    mcSection.readPacket(friendlyByteBuf);
                    container = mcSection.blockStateContainer();
                    LevelChunkWithLightListener.remapBiomes(user, mcSection.biomeContainer());
                    palette = container.data().palette();
                    if (palette.canRemap()) {
                        palette.remap(s -> this.blockStateMapper[s]);
                    } else {
                        for (j = 0; j < 4096; ++j) {
                            state = container.get(j);
                            newState = this.blockStateMapper[state];
                            if (newState == state) continue;
                            container.set(j, newState);
                        }
                    }
                    mcSection.writePacket(newBuf);
                }
                buffer = newBuf.array();
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeInt(chunkX);
            buf.writeInt(chunkZ);
            if (VersionHelper.isOrAbove1_21_5()) {
                buf.writeVarInt(heightmapsCount);
                for (Map.Entry entry : heightmapsMap.entrySet()) {
                    buf.writeVarInt((Integer)entry.getKey());
                    buf.writeLongArray((long[])entry.getValue());
                }
            } else {
                buf.writeNbt(heightmaps, named);
            }
            buf.writeVarInt(buffer.length);
            buf.writeBytes(buffer);
            buf.writeVarInt(blockEntitiesDataCount);
            for (BlockEntityData blockEntityData : blockEntitiesData) {
                buf.writeByte(blockEntityData.packedXZ());
                buf.writeShort(blockEntityData.y());
                buf.writeVarInt(blockEntityData.type());
                buf.writeNbt(blockEntityData.tag(), named);
            }
            buf.writeBitSet(skyYMask);
            buf.writeBitSet(blockYMask);
            buf.writeBitSet(emptySkyYMask);
            buf.writeBitSet(emptyBlockYMask);
            buf.writeByteArrayList(skyUpdates);
            buf.writeByteArrayList(blockUpdates);
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            player.addTrackedChunk(chunkPos.longKey, new ChunkStatus());
            CEWorld cEWorld = BukkitWorldManager.instance().getWorld(player.world().uuid());
            CEChunk ceChunk = cEWorld.getChunkAtIfLoaded(chunkPos.longKey);
            if (ceChunk != null) {
                ceChunk.spawnBlockEntities(player);
            }
        }
    }

    public static class SectionBlockUpdateListener
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public SectionBlockUpdateListener(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (user.clientModEnabled()) {
                int i;
                FriendlyByteBuf buf = event.getBuffer();
                long pos = buf.readLong();
                int blocks = buf.readVarInt();
                short[] positions = new short[blocks];
                int[] states = new int[blocks];
                for (i = 0; i < blocks; ++i) {
                    long k = buf.readVarLong();
                    positions[i] = (short)(k & 0xFFFL);
                    states[i] = this.modBlockStateMapper[(int)(k >>> 12)];
                }
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeLong(pos);
                buf.writeVarInt(blocks);
                for (i = 0; i < blocks; ++i) {
                    buf.writeVarLong((long)states[i] << 12 | (long)positions[i]);
                }
                event.setChanged(true);
            } else {
                int i;
                FriendlyByteBuf buf = event.getBuffer();
                long pos = buf.readLong();
                int blocks = buf.readVarInt();
                short[] positions = new short[blocks];
                int[] states = new int[blocks];
                for (i = 0; i < blocks; ++i) {
                    long k = buf.readVarLong();
                    positions[i] = (short)(k & 0xFFFL);
                    states[i] = this.blockStateMapper[(int)(k >>> 12)];
                }
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeLong(pos);
                buf.writeVarInt(blocks);
                for (i = 0; i < blocks; ++i) {
                    buf.writeVarLong((long)states[i] << 12 | (long)positions[i]);
                }
                event.setChanged(true);
            }
        }
    }

    public static class BlockUpdateListener
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public BlockUpdateListener(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            int state;
            FriendlyByteBuf buf = event.getBuffer();
            BlockPos pos = buf.readBlockPos();
            int before = buf.readVarInt();
            if (user.clientModEnabled() && !BlockStateUtils.isVanillaBlock(before)) {
                return;
            }
            int n = state = user.clientModEnabled() ? this.modBlockStateMapper[before] : this.blockStateMapper[before];
            if (state == before) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeBlockPos(pos);
            buf.writeVarInt(state);
        }
    }

    public static class LevelParticleListener1_21_4
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public LevelParticleListener1_21_4(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            int remapped;
            FriendlyByteBuf buf = event.getBuffer();
            boolean overrideLimiter = buf.readBoolean();
            boolean alwaysShow = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xDist = buf.readFloat();
            float yDist = buf.readFloat();
            float zDist = buf.readFloat();
            float maxSpeed = buf.readFloat();
            int count = buf.readInt();
            Object option = FastNMS.INSTANCE.method$StreamDecoder$decode(NetworkReflections.instance$ParticleTypes$STREAM_CODEC, FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf));
            if (option == null) {
                return;
            }
            if (!CoreReflections.clazz$BlockParticleOption.isInstance(option)) {
                return;
            }
            Object blockState = FastNMS.INSTANCE.field$BlockParticleOption$blockState(option);
            int id = BlockStateUtils.blockStateToId(blockState);
            int n = remapped = user.clientModEnabled() ? this.modBlockStateMapper[id] : this.blockStateMapper[id];
            if (remapped == id) {
                return;
            }
            Object type = FastNMS.INSTANCE.method$BlockParticleOption$getType(option);
            Object remappedOption = FastNMS.INSTANCE.constructor$BlockParticleOption(type, BlockStateUtils.idToBlockState(remapped));
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeBoolean(overrideLimiter);
            buf.writeBoolean(alwaysShow);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(xDist);
            buf.writeFloat(yDist);
            buf.writeFloat(zDist);
            buf.writeFloat(maxSpeed);
            buf.writeInt(count);
            FastNMS.INSTANCE.method$StreamEncoder$encode(NetworkReflections.instance$ParticleTypes$STREAM_CODEC, FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf), remappedOption);
        }
    }

    public static class LevelParticleListener1_20_5
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public LevelParticleListener1_20_5(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            int remapped;
            FriendlyByteBuf buf = event.getBuffer();
            boolean overrideLimiter = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xDist = buf.readFloat();
            float yDist = buf.readFloat();
            float zDist = buf.readFloat();
            float maxSpeed = buf.readFloat();
            int count = buf.readInt();
            Object option = FastNMS.INSTANCE.method$StreamDecoder$decode(NetworkReflections.instance$ParticleTypes$STREAM_CODEC, FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf));
            if (option == null) {
                return;
            }
            if (!CoreReflections.clazz$BlockParticleOption.isInstance(option)) {
                return;
            }
            Object blockState = FastNMS.INSTANCE.field$BlockParticleOption$blockState(option);
            int id = BlockStateUtils.blockStateToId(blockState);
            int n = remapped = user.clientModEnabled() ? this.modBlockStateMapper[id] : this.blockStateMapper[id];
            if (remapped == id) {
                return;
            }
            Object type = FastNMS.INSTANCE.method$BlockParticleOption$getType(option);
            Object remappedOption = FastNMS.INSTANCE.constructor$BlockParticleOption(type, BlockStateUtils.idToBlockState(remapped));
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeBoolean(overrideLimiter);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(xDist);
            buf.writeFloat(yDist);
            buf.writeFloat(zDist);
            buf.writeFloat(maxSpeed);
            buf.writeInt(count);
            FastNMS.INSTANCE.method$StreamEncoder$encode(NetworkReflections.instance$ParticleTypes$STREAM_CODEC, FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf), remappedOption);
        }
    }

    public static class LevelParticleListener1_20
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public LevelParticleListener1_20(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            int remapped;
            FriendlyByteBuf buf = event.getBuffer();
            Object particleType = FastNMS.INSTANCE.method$FriendlyByteBuf$readById((Object)buf, MBuiltInRegistries.PARTICLE_TYPE);
            boolean overrideLimiter = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xDist = buf.readFloat();
            float yDist = buf.readFloat();
            float zDist = buf.readFloat();
            float maxSpeed = buf.readFloat();
            int count = buf.readInt();
            Object option = FastNMS.INSTANCE.method$ClientboundLevelParticlesPacket$readParticle((Object)buf, particleType);
            if (option == null) {
                return;
            }
            if (!CoreReflections.clazz$BlockParticleOption.isInstance(option)) {
                return;
            }
            Object blockState = FastNMS.INSTANCE.field$BlockParticleOption$blockState(option);
            int id = BlockStateUtils.blockStateToId(blockState);
            int n = remapped = user.clientModEnabled() ? this.modBlockStateMapper[id] : this.blockStateMapper[id];
            if (remapped == id) {
                return;
            }
            Object type = FastNMS.INSTANCE.method$BlockParticleOption$getType(option);
            Object remappedOption = FastNMS.INSTANCE.constructor$BlockParticleOption(type, BlockStateUtils.idToBlockState(remapped));
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            FastNMS.INSTANCE.method$FriendlyByteBuf$writeId((Object)buf, remappedOption, MBuiltInRegistries.PARTICLE_TYPE);
            buf.writeBoolean(overrideLimiter);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(xDist);
            buf.writeFloat(yDist);
            buf.writeFloat(zDist);
            buf.writeFloat(maxSpeed);
            buf.writeInt(count);
            FastNMS.INSTANCE.method$ParticleOptions$writeToNetwork(remappedOption, (Object)buf);
        }
    }

    public static class LevelEventListener
    implements ByteBufferPacketListener {
        private final int[] blockStateMapper;
        private final int[] modBlockStateMapper;

        public LevelEventListener(int[] blockStateMapper, int[] modBlockStateMapper) {
            this.blockStateMapper = blockStateMapper;
            this.modBlockStateMapper = modBlockStateMapper;
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            int eventId = buf.readInt();
            if (eventId != 2001) {
                return;
            }
            BlockPos blockPos = buf.readBlockPos();
            int state = buf.readInt();
            boolean global = buf.readBoolean();
            int newState = user.clientModEnabled() ? this.modBlockStateMapper[state] : this.blockStateMapper[state];
            Object blockState = BlockStateUtils.idToBlockState(state);
            Object soundType = FastNMS.INSTANCE.method$BlockBehaviour$BlockStateBase$getSoundType(blockState);
            Object soundEvent = FastNMS.INSTANCE.field$SoundType$breakSound(soundType);
            Object rawSoundId = FastNMS.INSTANCE.field$SoundEvent$location(soundEvent);
            if (BlockStateUtils.isVanillaBlock(state)) {
                net.momirealms.craftengine.core.util.Key mappedSoundId;
                if (BukkitBlockManager.instance().isBreakSoundMissing(rawSoundId) && (mappedSoundId = BukkitBlockManager.instance().replaceSoundIfExist(KeyUtils.resourceLocationToKey(rawSoundId))) != null) {
                    Object packet = FastNMS.INSTANCE.constructor$ClientboundSoundPacket(FastNMS.INSTANCE.method$Holder$direct(FastNMS.INSTANCE.constructor$SoundEvent(KeyUtils.toResourceLocation(mappedSoundId), Optional.empty())), CoreReflections.instance$SoundSource$BLOCKS, (double)blockPos.x() + 0.5, (double)blockPos.y() + 0.5, (double)blockPos.z() + 0.5, 1.0f, 0.8f, RandomUtils.generateRandomLong());
                    user.sendPacket(packet, true);
                }
            } else {
                net.momirealms.craftengine.core.util.Key soundId = KeyUtils.resourceLocationToKey(rawSoundId);
                net.momirealms.craftengine.core.util.Key mappedSoundId = BukkitBlockManager.instance().replaceSoundIfExist(soundId);
                Object finalSoundId = KeyUtils.toResourceLocation(mappedSoundId == null ? soundId : mappedSoundId);
                Object packet = FastNMS.INSTANCE.constructor$ClientboundSoundPacket(FastNMS.INSTANCE.method$Holder$direct(FastNMS.INSTANCE.constructor$SoundEvent(finalSoundId, Optional.empty())), CoreReflections.instance$SoundSource$BLOCKS, (double)blockPos.x() + 0.5, (double)blockPos.y() + 0.5, (double)blockPos.z() + 0.5, 1.0f, 0.8f, RandomUtils.generateRandomLong());
                user.sendPacket(packet, true);
            }
            if (newState == state) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeInt(eventId);
            buf.writeBlockPos(blockPos);
            buf.writeInt(newState);
            buf.writeBoolean(global);
        }
    }

    public static class PlayerInfoUpdateListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            EnumSet<? extends Enum> enums;
            List<Object> entries;
            block7: {
                if (!Config.interceptPlayerInfo()) {
                    return;
                }
                entries = FastNMS.INSTANCE.field$ClientboundPlayerInfoUpdatePacket$entries(packet);
                if (entries instanceof MarkedArrayList) {
                    return;
                }
                enums = FastNMS.INSTANCE.field$ClientboundPlayerInfoUpdatePacket$actions(packet);
                for (Object e : enums) {
                    if (e != NetworkReflections.instance$ClientboundPlayerInfoUpdatePacket$Action$UPDATE_DISPLAY_NAME) continue;
                    break block7;
                }
                return;
            }
            boolean isChanged = false;
            MarkedArrayList markedArrayList = new MarkedArrayList();
            for (Object entry : entries) {
                Object mcComponent = FastNMS.INSTANCE.field$ClientboundPlayerInfoUpdatePacket$Entry$displayName(entry);
                if (mcComponent == null) {
                    markedArrayList.add(entry);
                    continue;
                }
                String json = ComponentUtils.minecraftToJson(mcComponent);
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
                if (tokens.isEmpty()) {
                    markedArrayList.add(entry);
                    continue;
                }
                Object newEntry = FastNMS.INSTANCE.constructor$ClientboundPlayerInfoUpdatePacket$Entry(entry, ComponentUtils.adventureToMinecraft(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
                markedArrayList.add(newEntry);
                isChanged = true;
            }
            if (isChanged) {
                event.replacePacket(FastNMS.INSTANCE.constructor$ClientboundPlayerInfoUpdatePacket(enums, markedArrayList));
            }
        }
    }

    public static class PlayerActionListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            Player platformPlayer = player.platformPlayer();
            World world = platformPlayer.getWorld();
            Object blockPos = FastNMS.INSTANCE.field$ServerboundPlayerActionPacket$pos(packet);
            BlockPos pos = LocationUtils.fromBlockPos(blockPos);
            if (VersionHelper.isFolia()) {
                platformPlayer.getScheduler().run((Plugin)BukkitCraftEngine.instance().javaPlugin(), t -> {
                    try {
                        PlayerActionListener.handlePlayerActionPacketOnMainThread(player, world, pos, packet);
                    }
                    catch (Exception e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundPlayerActionPacket", e);
                    }
                }, () -> {});
            } else {
                PlayerActionListener.handlePlayerActionPacketOnMainThread(player, world, pos, packet);
            }
        }

        private static void handlePlayerActionPacketOnMainThread(BukkitServerPlayer player, World world, BlockPos pos, Object packet) {
            Object action = FastNMS.INSTANCE.field$ServerboundPlayerActionPacket$action(packet);
            if (action == NetworkReflections.instance$ServerboundPlayerActionPacket$Action$START_DESTROY_BLOCK) {
                Object serverLevel = FastNMS.INSTANCE.field$CraftWorld$ServerLevel(world);
                Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(serverLevel, LocationUtils.toBlockPos(pos));
                int stateId = BlockStateUtils.blockStateToId(blockState);
                if (BlockStateUtils.isVanillaBlock(stateId)) {
                    if (Config.enableSoundSystem()) {
                        Object soundType = FastNMS.INSTANCE.method$BlockBehaviour$BlockStateBase$getSoundType(blockState);
                        Object soundEvent = FastNMS.INSTANCE.field$SoundType$hitSound(soundType);
                        Object soundId = FastNMS.INSTANCE.field$SoundEvent$location(soundEvent);
                        if (BukkitBlockManager.instance().isHitSoundMissing(soundId)) {
                            player.startMiningBlock(pos, blockState, null);
                            return;
                        }
                    }
                    if (player.isMiningBlock()) {
                        player.stopMiningBlock();
                    } else {
                        player.setClientSideCanBreakBlock(true);
                    }
                    return;
                }
                if (player.isAdventureMode()) {
                    if (Config.simplifyAdventureBreakCheck()) {
                        ImmutableBlockState state = BukkitBlockManager.instance().getImmutableBlockStateUnsafe(stateId);
                        if (!player.canBreak(pos, state.vanillaBlockState().literalObject())) {
                            player.preventMiningBlock();
                            return;
                        }
                    } else if (!player.canBreak(pos, null)) {
                        player.preventMiningBlock();
                        return;
                    }
                }
                player.startMiningBlock(pos, blockState, BukkitBlockManager.instance().getImmutableBlockStateUnsafe(stateId));
            } else if (action == NetworkReflections.instance$ServerboundPlayerActionPacket$Action$ABORT_DESTROY_BLOCK) {
                if (player.isMiningBlock()) {
                    player.abortMiningBlock();
                }
            } else if (action == NetworkReflections.instance$ServerboundPlayerActionPacket$Action$STOP_DESTROY_BLOCK && player.isMiningBlock()) {
                player.stopMiningBlock();
            }
        }
    }

    public static class SwingListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            if (!player.isMiningBlock()) {
                return;
            }
            Object hand = FastNMS.INSTANCE.field$ServerboundSwingPacket$hand(packet);
            if (hand == CoreReflections.instance$InteractionHand$MAIN_HAND) {
                player.onSwingHand();
            }
        }
    }

    public static class HelloListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            String name;
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            try {
                name = NetworkReflections.methodHandle$ServerboundHelloPacket$nameGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().severe("Failed to get name from ServerboundHelloPacket", t);
                return;
            }
            player.setUnverifiedName(name);
            if (VersionHelper.isOrAbove1_20_2()) {
                UUID uuid;
                try {
                    uuid = NetworkReflections.methodHandle$ServerboundHelloPacket$uuidGetter.invokeExact(packet);
                }
                catch (Throwable t) {
                    CraftEngine.instance().logger().severe("Failed to get uuid from ServerboundHelloPacket", t);
                    return;
                }
                player.setUnverifiedUUID(uuid);
            } else {
                Optional uuid;
                try {
                    uuid = NetworkReflections.methodHandle$ServerboundHelloPacket$uuidGetter.invokeExact(packet);
                }
                catch (Throwable t) {
                    CraftEngine.instance().logger().severe("Failed to get uuid from ServerboundHelloPacket", t);
                    return;
                }
                if (uuid.isPresent()) {
                    player.setUnverifiedUUID((UUID)uuid.get());
                } else {
                    player.setUnverifiedUUID(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
                }
            }
        }
    }

    public static class UseItemOnListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            if (player.isMiningBlock()) {
                player.stopMiningBlock();
            }
        }
    }

    public static class PickItemFromBlockListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Object pos;
            Player player = (Player)user.platformPlayer();
            if (player == null) {
                return;
            }
            try {
                pos = NetworkReflections.methodHandle$ServerboundPickItemFromBlockPacket$posGetter.invokeExact(packet);
            }
            catch (Throwable e) {
                CraftEngine.instance().logger().warn("Failed to get pos from ServerboundPickItemFromBlockPacket", e);
                return;
            }
            if (VersionHelper.isFolia()) {
                int x = FastNMS.INSTANCE.field$Vec3i$x(pos);
                int z = FastNMS.INSTANCE.field$Vec3i$z(pos);
                BukkitCraftEngine.instance().scheduler().sync().run(() -> {
                    try {
                        PickItemFromBlockListener.handlePickItemFromBlockPacketOnMainThread(player, pos);
                    }
                    catch (Throwable e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundPickItemFromBlockPacket on region thread", e);
                    }
                }, player.getWorld(), x >> 4, z >> 4);
            } else {
                BukkitCraftEngine.instance().scheduler().sync().run(() -> {
                    try {
                        PickItemFromBlockListener.handlePickItemFromBlockPacketOnMainThread(player, pos);
                    }
                    catch (Throwable e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundPickItemFromBlockPacket on main thread", e);
                    }
                });
            }
        }

        private static void handlePickItemFromBlockPacketOnMainThread(Player player, Object pos) throws Throwable {
            Object serverLevel = FastNMS.INSTANCE.field$CraftWorld$ServerLevel(player.getWorld());
            Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(serverLevel, pos);
            ImmutableBlockState state = BukkitBlockManager.instance().getImmutableBlockState(BlockStateUtils.blockStateToId(blockState));
            if (state == null) {
                return;
            }
            net.momirealms.craftengine.core.util.Key itemId = state.settings().itemId();
            if (itemId == null) {
                return;
            }
            BukkitNetworkManager.pickItem(player, itemId, pos, null);
        }
    }

    public static class PickItemFromEntityListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            int entityId;
            try {
                entityId = NetworkReflections.methodHandle$ServerboundPickItemFromEntityPacket$idGetter.invokeExact(packet);
            }
            catch (Throwable e) {
                CraftEngine.instance().logger().warn("Failed to get entityId from ServerboundPickItemFromEntityPacket", e);
                return;
            }
            BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByEntityId(entityId);
            if (furniture == null) {
                return;
            }
            Player player = (Player)user.platformPlayer();
            if (player == null) {
                return;
            }
            if (VersionHelper.isFolia()) {
                player.getScheduler().run((Plugin)BukkitCraftEngine.instance().javaPlugin(), t -> {
                    try {
                        PickItemFromEntityListener.handlePickItemFromEntityOnMainThread(player, furniture);
                    }
                    catch (Throwable e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundPickItemFromEntityPacket on region thread", e);
                    }
                }, () -> {});
            } else {
                BukkitCraftEngine.instance().scheduler().sync().run(() -> {
                    try {
                        PickItemFromEntityListener.handlePickItemFromEntityOnMainThread(player, furniture);
                    }
                    catch (Throwable e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundPickItemFromEntityPacket on main thread", e);
                    }
                });
            }
        }

        private static void handlePickItemFromEntityOnMainThread(Player player, BukkitFurniture furniture) throws Throwable {
            net.momirealms.craftengine.core.util.Key itemId = furniture.config().settings().itemId();
            if (itemId == null) {
                return;
            }
            BukkitNetworkManager.pickItem(player, itemId, null, FastNMS.INSTANCE.method$CraftEntity$getHandle(furniture.baseEntity()));
        }
    }

    public static class SetCreativeSlotListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            if (VersionHelper.isOrAbove1_21_4()) {
                return;
            }
            if (!user.isOnline()) {
                return;
            }
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            if (VersionHelper.isFolia()) {
                player.platformPlayer().getScheduler().run((Plugin)BukkitCraftEngine.instance().javaPlugin(), t -> {
                    try {
                        SetCreativeSlotListener.handleSetCreativeSlotPacketOnMainThread(player, packet);
                    }
                    catch (Throwable e) {
                        CraftEngine.instance().logger().warn("Failed to handle ServerboundSetCreativeModeSlotPacket on region thread", e);
                    }
                }, () -> {});
            } else {
                try {
                    SetCreativeSlotListener.handleSetCreativeSlotPacketOnMainThread(player, packet);
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("Failed to handle ServerboundSetCreativeModeSlotPacket on main thread", e);
                }
            }
        }

        private static void handleSetCreativeSlotPacketOnMainThread(BukkitServerPlayer player, Object packet) throws Throwable {
            net.momirealms.craftengine.core.util.Key blockItemId;
            int slot;
            Player bukkitPlayer = player.platformPlayer();
            if (bukkitPlayer == null) {
                return;
            }
            if (bukkitPlayer.getGameMode() != GameMode.CREATIVE) {
                return;
            }
            int n = slot = VersionHelper.isOrAbove1_20_5() ? NetworkReflections.methodHandle$ServerboundSetCreativeModeSlotPacket$slotNumGetter.invokeExact(packet) : NetworkReflections.methodHandle$ServerboundSetCreativeModeSlotPacket$slotNumGetter.invokeExact(packet);
            if (slot < 36 || slot > 44) {
                return;
            }
            ItemStack item = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(NetworkReflections.methodHandle$ServerboundSetCreativeModeSlotPacket$itemStackGetter.invokeExact(packet));
            if (ItemStackUtils.isEmpty(item)) {
                return;
            }
            if (slot - 36 != bukkitPlayer.getInventory().getHeldItemSlot()) {
                return;
            }
            double interactionRange = player.getCachedInteractionRange();
            RayTraceResult result = bukkitPlayer.rayTraceBlocks(interactionRange, FluidCollisionMode.NEVER);
            if (result == null) {
                return;
            }
            Block hitBlock = result.getHitBlock();
            if (hitBlock == null) {
                return;
            }
            ImmutableBlockState state = CraftEngineBlocks.getCustomBlockState(hitBlock);
            if (state == null || state.isEmpty()) {
                return;
            }
            net.momirealms.craftengine.core.util.Key itemId = state.settings().itemId();
            if (itemId == null) {
                return;
            }
            Object vanillaBlock = FastNMS.INSTANCE.method$BlockState$getBlock(state.vanillaBlockState().literalObject());
            Object vanillaBlockItem = FastNMS.INSTANCE.method$Block$asItem(vanillaBlock);
            if (vanillaBlockItem == null) {
                return;
            }
            net.momirealms.craftengine.core.util.Key addItemId = KeyUtils.namespacedKey2Key(item.getType().getKey());
            if (!addItemId.equals(blockItemId = KeyUtils.resourceLocationToKey(FastNMS.INSTANCE.method$Registry$getKey(MBuiltInRegistries.ITEM, vanillaBlockItem)))) {
                return;
            }
            ItemStack itemStack = BukkitCraftEngine.instance().itemManager().buildCustomItemStack(itemId, player);
            if (ItemStackUtils.isEmpty(itemStack)) {
                CraftEngine.instance().logger().warn("Item: " + String.valueOf(itemId) + " is not a valid item");
                return;
            }
            PlayerInventory inventory = bukkitPlayer.getInventory();
            int sameItemSlot = -1;
            int emptySlot = -1;
            for (int i = 0; i < 36; ++i) {
                ItemStack invItem = inventory.getItem(i);
                if (ItemStackUtils.isEmpty(invItem)) {
                    if (emptySlot != -1 || i >= 9) continue;
                    emptySlot = i;
                    continue;
                }
                if (!invItem.getType().equals((Object)itemStack.getType()) || !invItem.getItemMeta().equals((Object)itemStack.getItemMeta()) || sameItemSlot != -1) continue;
                sameItemSlot = i;
            }
            if (sameItemSlot != -1) {
                if (sameItemSlot < 9) {
                    inventory.setHeldItemSlot(sameItemSlot);
                    ItemStack previousItem = inventory.getItem(slot - 36);
                    BukkitCraftEngine.instance().scheduler().sync().runDelayed(() -> inventory.setItem(slot - 36, previousItem));
                } else {
                    ItemStack sameItem = inventory.getItem(sameItemSlot);
                    int finalSameItemSlot = sameItemSlot;
                    BukkitCraftEngine.instance().scheduler().sync().runDelayed(() -> {
                        inventory.setItem(finalSameItemSlot, new ItemStack(Material.AIR));
                        inventory.setItem(slot - 36, sameItem);
                    });
                }
            } else if (item.getAmount() == 1) {
                if (ItemStackUtils.isEmpty(inventory.getItem(slot - 36))) {
                    BukkitCraftEngine.instance().scheduler().sync().runDelayed(() -> inventory.setItem(slot - 36, itemStack));
                    return;
                }
                if (emptySlot != -1) {
                    inventory.setHeldItemSlot(emptySlot);
                    inventory.setItem(emptySlot, itemStack);
                } else {
                    BukkitCraftEngine.instance().scheduler().sync().runDelayed(() -> inventory.setItem(slot - 36, itemStack));
                }
            }
        }
    }

    public static class LoginListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Object dimensionKey;
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            player.setConnectionState(ConnectionState.PLAY);
            try {
                if (!VersionHelper.isOrAbove1_20_2()) {
                    dimensionKey = NetworkReflections.methodHandle$ClientboundLoginPacket$dimensionGetter.invokeExact(packet);
                } else {
                    Object commonInfo = NetworkReflections.methodHandle$ClientboundLoginPacket$commonPlayerSpawnInfoGetter.invokeExact(packet);
                    dimensionKey = NetworkReflections.methodHandle$CommonPlayerSpawnInfo$dimensionGetter.invokeExact(commonInfo);
                }
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get dimensionKey from ClientboundLoginPacket", t);
                return;
            }
            Object location = FastNMS.INSTANCE.field$ResourceKey$location(dimensionKey);
            World world = Bukkit.getWorld((NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)location.toString())));
            if (world != null) {
                int sectionCount = (world.getMaxHeight() - world.getMinHeight()) / 16;
                player.setClientSideSectionCount(sectionCount);
                player.setClientSideDimension(net.momirealms.craftengine.core.util.Key.of(location.toString()));
            } else {
                CraftEngine.instance().logger().warn("Failed to handle ClientboundLoginPacket: World " + String.valueOf(location) + " does not exist");
            }
        }
    }

    public static class RespawnListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Object dimensionKey;
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            player.clearView();
            try {
                if (!VersionHelper.isOrAbove1_20_2()) {
                    dimensionKey = NetworkReflections.methodHandle$ClientboundRespawnPacket$dimensionGetter.invokeExact(packet);
                } else {
                    Object commonInfo = NetworkReflections.methodHandle$ClientboundRespawnPacket$commonPlayerSpawnInfoGetter.invokeExact(packet);
                    dimensionKey = NetworkReflections.methodHandle$CommonPlayerSpawnInfo$dimensionGetter.invokeExact(commonInfo);
                }
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get dimensionKey from ClientboundRespawnPacket", t);
                return;
            }
            Object location = FastNMS.INSTANCE.field$ResourceKey$location(dimensionKey);
            World world = Bukkit.getWorld((NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)location.toString())));
            if (world != null) {
                int sectionCount = (world.getMaxHeight() - world.getMinHeight()) / 16;
                player.setClientSideSectionCount(sectionCount);
                player.setClientSideDimension(net.momirealms.craftengine.core.util.Key.of(location.toString()));
                player.clearTrackedChunks();
            } else {
                CraftEngine.instance().logger().warn("Failed to handle ClientboundRespawnPacket: World " + String.valueOf(location) + " does not exist");
            }
        }
    }

    public static class SyncEntityPositionListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            int entityId = FastNMS.INSTANCE.method$ClientboundEntityPositionSyncPacket$id(packet);
            EntityPacketHandler handler = user.entityPacketHandlers().get(entityId);
            if (handler != null) {
                handler.handleSyncEntityPosition(user, event, packet);
            }
        }
    }

    public static class RenameItemListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            FontManager manager;
            IllegalCharacterProcessResult result;
            String message;
            if (!Config.filterAnvil()) {
                return;
            }
            if (((BukkitServerPlayer)user).hasPermission("craftengine.filter.bypass.anvil")) {
                return;
            }
            try {
                message = NetworkReflections.methodHandle$ServerboundRenameItemPacket$nameGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get message from ServerboundRenameItemPacket", t);
                return;
            }
            if (message != null && !message.isEmpty() && (result = (manager = CraftEngine.instance().fontManager()).processIllegalCharacters(message)).has()) {
                try {
                    NetworkReflections.methodHandle$ServerboundRenameItemPacket$nameSetter.invokeExact(packet, result.text());
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("Failed to set field 'name' for ServerboundRenameItemPacket", e);
                }
            }
        }
    }

    public static class SignUpdateListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            String[] lines;
            if (!Config.filterSign()) {
                return;
            }
            if (((BukkitServerPlayer)user).hasPermission("craftengine.filter.bypass.sign")) {
                return;
            }
            try {
                lines = NetworkReflections.methodHandle$ServerboundSignUpdatePacket$linesGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get lines from ServerboundSignUpdatePacket", t);
                return;
            }
            FontManager manager = CraftEngine.instance().fontManager();
            if (!manager.isDefaultFontInUse()) {
                return;
            }
            for (int i = 0; i < lines.length; ++i) {
                IllegalCharacterProcessResult result;
                String line = lines[i];
                if (line == null || line.isEmpty() || !(result = manager.processIllegalCharacters(line)).has()) continue;
                lines[i] = result.text();
            }
        }
    }

    public static class EditBookListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Optional<Object> newTitle;
            Optional title;
            List pages;
            if (!Config.filterBook()) {
                return;
            }
            FontManager manager = CraftEngine.instance().fontManager();
            if (!manager.isDefaultFontInUse()) {
                return;
            }
            if (((BukkitServerPlayer)user).hasPermission("craftengine.filter.bypass.book")) {
                return;
            }
            boolean changed = false;
            try {
                pages = NetworkReflections.methodHandle$ServerboundEditBookPacket$pagesGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get pages from ServerboundEditBookPacket", t);
                return;
            }
            ArrayList<String> newPages = new ArrayList<String>(pages.size());
            try {
                title = NetworkReflections.methodHandle$ServerboundEditBookPacket$titleGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get title from ServerboundEditBookPacket", t);
                return;
            }
            if (title.isPresent()) {
                String titleStr = (String)title.get();
                net.momirealms.craftengine.core.util.Pair<Boolean, String> result = EditBookListener.processClientString(titleStr, manager);
                newTitle = Optional.of(result.right());
                if (result.left().booleanValue()) {
                    changed = true;
                }
            } else {
                newTitle = Optional.empty();
            }
            for (String page : pages) {
                net.momirealms.craftengine.core.util.Pair<Boolean, String> result = EditBookListener.processClientString(page, manager);
                newPages.add(result.right());
                if (!result.left().booleanValue()) continue;
                changed = true;
            }
            if (changed) {
                try {
                    Object newPacket = NetworkReflections.constructor$ServerboundEditBookPacket.newInstance(NetworkReflections.methodHandle$ServerboundEditBookPacket$slotGetter.invokeExact(packet), newPages, newTitle);
                    event.replacePacket(newPacket);
                }
                catch (Throwable t) {
                    CraftEngine.instance().logger().warn("Failed to construct ServerboundEditBookPacket", t);
                }
            }
        }

        private static net.momirealms.craftengine.core.util.Pair<Boolean, String> processClientString(String original, FontManager manager) {
            if (original.isEmpty()) {
                return net.momirealms.craftengine.core.util.Pair.of(false, original);
            }
            int[] codepoints = CharacterUtils.charsToCodePoints(original.toCharArray());
            int[] newCodepoints = new int[codepoints.length];
            boolean hasIllegal = false;
            for (int i = 0; i < codepoints.length; ++i) {
                int codepoint = codepoints[i];
                if (manager.isIllegalCodepoint(codepoint)) {
                    newCodepoints[i] = 42;
                    hasIllegal = true;
                    continue;
                }
                newCodepoints[i] = codepoint;
            }
            return hasIllegal ? net.momirealms.craftengine.core.util.Pair.of(true, new String(newCodepoints, 0, newCodepoints.length)) : net.momirealms.craftengine.core.util.Pair.of(false, original);
        }
    }

    public static class CustomPayloadListener1_20_2
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Record clientPayload;
            Object payload;
            if (!VersionHelper.isOrAbove1_20_2()) {
                return;
            }
            try {
                payload = NetworkReflections.methodHandle$ServerboundCustomPayloadPacket$payloadGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get payload from ServerboundCustomPayloadPacket", t);
                return;
            }
            if (VersionHelper.isOrAbove1_20_5() && NetworkReflections.clazz$DiscardedPayload.isInstance(payload)) {
                clientPayload = DiscardedPayload.from(payload);
            } else if (!VersionHelper.isOrAbove1_20_5() && NetworkReflections.clazz$ServerboundCustomPayloadPacket$UnknownPayload.isInstance(payload)) {
                clientPayload = UnknownPayload.from(payload);
            } else {
                return;
            }
            if (clientPayload == null || !clientPayload.channel().equals(NetworkManager.MOD_CHANNEL_KEY)) {
                return;
            }
            PayloadHelper.handleReceiver((Payload)((Object)clientPayload), user);
        }
    }

    public static class ResourcePackResponseListener
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            boolean isTerminal;
            UUID uuid;
            Object action = FastNMS.INSTANCE.field$ServerboundResourcePackPacket$action(packet);
            if (VersionHelper.isOrAbove1_20_3() && !user.isResourcePackLoading(uuid = FastNMS.INSTANCE.field$ServerboundResourcePackPacket$id(packet))) {
                return;
            }
            if (action == null) {
                user.kick((Component)Component.text((String)"Corrupted ResourcePackResponse Packet"));
                return;
            }
            if (Config.kickOnDeclined() && (action == NetworkReflections.instance$ServerboundResourcePackPacket$Action$DECLINED || action == NetworkReflections.instance$ServerboundResourcePackPacket$Action$DISCARDED)) {
                user.kick((Component)Component.translatable((String)"multiplayer.requiredTexturePrompt.disconnect"));
                return;
            }
            if (Config.kickOnFailedApply() && (action == NetworkReflections.instance$ServerboundResourcePackPacket$Action$FAILED_DOWNLOAD || VersionHelper.isOrAbove1_20_3() && action == NetworkReflections.instance$ServerboundResourcePackPacket$Action$INVALID_URL)) {
                user.kick((Component)Component.translatable((String)"multiplayer.requiredTexturePrompt.disconnect"));
                return;
            }
            boolean bl = isTerminal = action != NetworkReflections.instance$ServerboundResourcePackPacket$Action$ACCEPTED && action != NetworkReflections.instance$ServerboundResourcePackPacket$Action$DOWNLOADED;
            if (isTerminal && VersionHelper.isOrAbove1_20_2()) {
                event.setCancelled(true);
                Object packetListener = FastNMS.INSTANCE.method$Connection$getPacketListener(user.connection());
                if (!CoreReflections.clazz$ServerConfigurationPacketListenerImpl.isInstance(packetListener)) {
                    return;
                }
                CraftEngine.instance().scheduler().executeSync(() -> {
                    try {
                        NetworkReflections.methodHandle$ServerCommonPacketListener$handleResourcePackResponse.invokeExact(packetListener, packet);
                        CoreReflections.methodHandle$ServerConfigurationPacketListenerImpl$finishCurrentTask.invokeExact(packetListener, CoreReflections.instance$ServerResourcePackConfigurationTask$TYPE);
                    }
                    catch (Throwable e) {
                        Debugger.RESOURCE_PACK.warn(() -> "Cannot finish current task", e);
                    }
                });
            }
        }
    }

    public static class EntityEventListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            byte eventId;
            int entityId;
            Object player = user.serverPlayer();
            if (player == null) {
                return;
            }
            try {
                entityId = NetworkReflections.methodHandle$ClientboundEntityEventPacket$entityIdGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get entity id from ClientboundEntityEventPacket", t);
                return;
            }
            if (entityId != FastNMS.INSTANCE.method$Entity$getId(player)) {
                return;
            }
            try {
                eventId = NetworkReflections.methodHandle$ClientboundEntityEventPacket$eventIdGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get event id from ClientboundEntityEventPacket", t);
                return;
            }
            if (eventId >= 24 && eventId <= 28) {
                CraftEngine.instance().fontManager().refreshEmojiSuggestions(user.uuid());
            }
        }
    }

    public static class MovePosAndRotateEntityListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            EntityPacketHandler handler;
            int entityId = ProtectedFieldVisitor.get().field$ClientboundMoveEntityPacket$entityId(packet);
            if (BukkitFurnitureManager.instance().isFurnitureRealEntity(entityId)) {
                event.setCancelled(true);
            }
            if ((handler = user.entityPacketHandlers().get(entityId)) != null) {
                handler.handleMoveAndRotate(user, event, packet);
            }
        }
    }

    public static class MovePosEntityListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            int entityId = ProtectedFieldVisitor.get().field$ClientboundMoveEntityPacket$entityId(packet);
            EntityPacketHandler handler = user.entityPacketHandlers().get(entityId);
            if (handler != null) {
                handler.handleMove(user, event, packet);
            }
        }
    }

    public static class RotateHeadListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            int entityId;
            try {
                entityId = NetworkReflections.methodHandle$ClientboundRotateHeadPacket$entityIdGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get entity id from ClientboundRotateHeadPacket", t);
                return;
            }
            if (BukkitFurnitureManager.instance().isFurnitureRealEntity(entityId)) {
                event.setCancelled(true);
            }
        }
    }

    public static class SetEntityMotionListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            int entityId;
            if (!VersionHelper.isOrAbove1_21_6()) {
                return;
            }
            try {
                entityId = NetworkReflections.methodHandle$ClientboundSetEntityMotionPacket$idGetter.invokeExact(packet);
            }
            catch (Throwable t) {
                CraftEngine.instance().logger().warn("Failed to get entity id from ClientboundSetEntityMotionPacket", t);
                return;
            }
            if (BukkitFurnitureManager.instance().isFurnitureRealEntity(entityId)) {
                event.setCancelled(true);
            }
        }
    }

    public static class FinishConfigurationListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            if (!VersionHelper.isOrAbove1_20_2() || !Config.sendPackOnJoin()) {
                user.setShouldProcessFinishConfiguration(false);
                return;
            }
            if (!user.shouldProcessFinishConfiguration()) {
                return;
            }
            Object packetListener = FastNMS.INSTANCE.method$Connection$getPacketListener(user.connection());
            if (!CoreReflections.clazz$ServerConfigurationPacketListenerImpl.isInstance(packetListener)) {
                return;
            }
            user.setShouldProcessFinishConfiguration(false);
            if (!user.isUUIDVerified()) {
                if (Config.strictPlayerUuidValidation()) {
                    TranslationManager.instance().log("warning.network.resource_pack.unverified_uuid", user.name(), user.uuid().toString());
                    user.kick((Component)Component.translatable((String)"disconnect.loginFailedInfo").arguments(new ComponentLike[]{Component.translatable((String)"argument.uuid.invalid")}));
                    return;
                }
                if (Config.debugResourcePack()) {
                    TranslationManager.instance().log("warning.network.resource_pack.unverified_uuid", user.name(), user.uuid().toString());
                }
            }
            event.setCancelled(true);
            try {
                CoreReflections.methodHandle$ServerConfigurationPacketListenerImpl$finishCurrentTask.invokeExact(packetListener, CoreReflections.instance$JoinWorldTask$TYPE);
            }
            catch (Throwable e) {
                CraftEngine.instance().logger().warn("Failed to finish current task for " + user.name(), e);
            }
            if (VersionHelper.isOrAbove1_20_5()) {
                try {
                    CoreReflections.methodHandle$ServerCommonPacketListenerImpl$closedSetter.invokeExact(packetListener, false);
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("Failed to set the 'closed' field of ServerCommonPacketListenerImpl for" + user.name(), e);
                }
            }
            ResourcePackHost host = CraftEngine.instance().packManager().resourcePackHost();
            host.requestResourcePackDownloadLink(user.uuid()).whenComplete((dataList, t) -> {
                Queue configurationTasks;
                if (t != null) {
                    CraftEngine.instance().logger().warn("Failed to get pack data for player " + user.name(), (Throwable)t);
                    FastNMS.INSTANCE.method$ServerConfigurationPacketListenerImpl$returnToWorld(packetListener);
                    return;
                }
                if (dataList.isEmpty()) {
                    FastNMS.INSTANCE.method$ServerConfigurationPacketListenerImpl$returnToWorld(packetListener);
                    return;
                }
                try {
                    configurationTasks = CoreReflections.methodHandle$ServerConfigurationPacketListenerImpl$configurationTasksGetter.invokeExact(packetListener);
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("Failed to get configuration tasks for player " + user.name(), e);
                    FastNMS.INSTANCE.method$ServerConfigurationPacketListenerImpl$returnToWorld(packetListener);
                    return;
                }
                for (ResourcePackDownloadData data : dataList) {
                    configurationTasks.add(FastNMS.INSTANCE.constructor$ServerResourcePackConfigurationTask(ResourcePackUtils.createServerResourcePackInfo(data.uuid(), data.url(), data.sha1())));
                    user.addResourcePackUUID(data.uuid());
                }
                FastNMS.INSTANCE.method$ServerConfigurationPacketListenerImpl$returnToWorld(packetListener);
            });
        }
    }

    public static class LoginFinishedListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            GameProfile gameProfile = FastNMS.INSTANCE.field$ClientboundLoginFinishedPacket$gameProfile(packet);
            if (VersionHelper.isOrAbove1_21_9()) {
                user.setVerifiedName(gameProfile.name());
                user.setVerifiedUUID(gameProfile.id());
            } else {
                user.setVerifiedName(LegacyAuthLibUtils.getName(gameProfile));
                user.setVerifiedUUID(LegacyAuthLibUtils.getId(gameProfile));
            }
        }
    }

    public static class UpdateTagsListener
    implements NMSPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, NMSPacketEvent event, Object packet) {
            Object modifiedPacket = BukkitBlockManager.instance().cachedUpdateTagsPacket();
            if (packet.equals(modifiedPacket) || modifiedPacket == null) {
                return;
            }
            event.replacePacket(modifiedPacket);
        }
    }

    public static class ContainerClickListener1_21_5
    implements NMSPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, NMSPacketEvent event, Object packet) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            int containerId = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$containerId(packet);
            int stateId = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$stateId(packet);
            short slotNum = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$slotNum(packet);
            byte buttonNum = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$buttonNum(packet);
            Object clickType = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$clickType(packet);
            Int2ObjectMap changedSlots = FastNMS.INSTANCE.field$ServerboundContainerClickPacket$changedSlots(packet);
            Int2ObjectOpenHashMap newChangedSlots = new Int2ObjectOpenHashMap(changedSlots.size());
            for (Int2ObjectMap.Entry entry : changedSlots.int2ObjectEntrySet()) {
                newChangedSlots.put(entry.getIntKey(), FastNMS.INSTANCE.constructor$InjectedHashedStack(entry.getValue(), player));
            }
            Object carriedItem = FastNMS.INSTANCE.constructor$InjectedHashedStack(FastNMS.INSTANCE.field$ServerboundContainerClickPacket$carriedItem(packet), player);
            event.replacePacket(FastNMS.INSTANCE.constructor$ServerboundContainerClickPacket(containerId, stateId, slotNum, buttonNum, clickType, Int2ObjectMaps.unmodifiable((Int2ObjectMap)newChangedSlots), carriedItem));
        }
    }

    public static class ForgetLevelChunkListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            BukkitServerPlayer player = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            CEWorld ceWorld = BukkitWorldManager.instance().getWorld(player.world().uuid());
            if (VersionHelper.isOrAbove1_20_2()) {
                long chunkPos = buf.readLong();
                user.removeTrackedChunk(chunkPos);
                CEChunk ceChunk = ceWorld.getChunkAtIfLoaded(chunkPos);
                if (ceChunk != null) {
                    ceChunk.despawnBlockEntities(player);
                }
            } else {
                int x = buf.readInt();
                int y = buf.readInt();
                user.removeTrackedChunk(ChunkPos.asLong(x, y));
                CEChunk ceChunk = ceWorld.getChunkAtIfLoaded(x, y);
                if (ceChunk != null) {
                    ceChunk.despawnBlockEntities(player);
                }
            }
        }
    }

    public static class SetScoreListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            Map<String, ComponentProvider> tokens;
            if (!Config.interceptSetScore()) {
                return;
            }
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            boolean isChanged = false;
            FriendlyByteBuf buf = event.getBuffer();
            String owner = buf.readUtf();
            String objectiveName = buf.readUtf();
            int score = buf.readVarInt();
            boolean hasDisplay = buf.readBoolean();
            Tag displayName = null;
            if (hasDisplay) {
                displayName = buf.readNbt(false);
            }
            if (displayName != null && !(tokens = CraftEngine.instance().fontManager().matchTags(displayName.getAsString())).isEmpty()) {
                Component component = AdventureHelper.tagToComponent(displayName);
                component = AdventureHelper.replaceText(component, tokens, NetworkTextReplaceContext.of(serverPlayer));
                displayName = AdventureHelper.componentToTag(component);
                isChanged = true;
            }
            boolean hasNumberFormat = buf.readBoolean();
            int format = -1;
            Tag style = null;
            Tag fixed = null;
            if (hasNumberFormat) {
                format = buf.readVarInt();
                if (format == 0) {
                    if (displayName == null) {
                        return;
                    }
                } else if (format == 1) {
                    if (displayName == null) {
                        return;
                    }
                    style = buf.readNbt(false);
                } else if (format == 2) {
                    fixed = buf.readNbt(false);
                    if (fixed == null) {
                        return;
                    }
                    Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(fixed.getAsString());
                    if (tokens2.isEmpty() && !isChanged) {
                        return;
                    }
                    if (!tokens2.isEmpty()) {
                        Component component = AdventureHelper.tagToComponent(fixed);
                        component = AdventureHelper.replaceText(component, tokens2, NetworkTextReplaceContext.of(serverPlayer));
                        fixed = AdventureHelper.componentToTag(component);
                        isChanged = true;
                    }
                }
            }
            if (isChanged) {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUtf(owner);
                buf.writeUtf(objectiveName);
                buf.writeVarInt(score);
                if (hasDisplay) {
                    buf.writeBoolean(true);
                    buf.writeNbt(displayName, false);
                } else {
                    buf.writeBoolean(false);
                }
                if (hasNumberFormat) {
                    buf.writeBoolean(true);
                    buf.writeVarInt(format);
                    if (format == 1) {
                        buf.writeNbt(style, false);
                    } else if (format == 2) {
                        buf.writeNbt(fixed, false);
                    }
                } else {
                    buf.writeBoolean(false);
                }
            }
        }
    }

    public static class AddRecipeBookListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            List entries = buf.readCollection(ArrayList::new, byteBuf -> {
                RecipeBookEntry entry = RecipeBookEntry.read(byteBuf);
                entry.applyClientboundData((BukkitServerPlayer)user);
                return entry;
            });
            boolean replace = buf.readBoolean();
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeCollection(entries, (byteBuf, recipeBookEntry) -> recipeBookEntry.write((FriendlyByteBuf)((Object)byteBuf)));
            buf.writeBoolean(replace);
        }
    }

    public static class PlaceGhostRecipeListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!VersionHelper.isOrAbove1_21_2()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readContainerId();
            RecipeDisplay display = RecipeDisplay.read(buf);
            display.applyClientboundData((BukkitServerPlayer)user);
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeContainerId(containerId);
            display.write(buf);
        }
    }

    public static class UpdateRecipesListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (VersionHelper.isOrAbove1_21_2()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            List holders = buf.readCollection(ArrayList::new, byteBuf -> {
                LegacyRecipeHolder holder = LegacyRecipeHolder.read(byteBuf);
                holder.recipe().applyClientboundData((BukkitServerPlayer)user);
                return holder;
            });
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeCollection(holders, (byteBuf, recipeHolder) -> recipeHolder.write((FriendlyByteBuf)((Object)byteBuf)));
        }
    }

    public static class UpdateAdvancementsListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            boolean reset = buf.readBoolean();
            List added = buf.readCollection(ArrayList::new, byteBuf -> {
                AdvancementHolder holder = AdvancementHolder.read(byteBuf);
                holder.applyClientboundData(serverPlayer);
                return holder;
            });
            Set removed = buf.readCollection(Sets::newLinkedHashSetWithExpectedSize, FriendlyByteBuf::readKey);
            Map progress = buf.readMap(FriendlyByteBuf::readKey, AdvancementProgress::read);
            boolean showAdvancement = false;
            if (VersionHelper.isOrAbove1_21_5()) {
                showAdvancement = buf.readBoolean();
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeBoolean(reset);
            buf.writeCollection(added, (byteBuf, advancementHolder) -> advancementHolder.write((FriendlyByteBuf)((Object)byteBuf)));
            buf.writeCollection(removed, FriendlyByteBuf::writeKey);
            buf.writeMap(progress, FriendlyByteBuf::writeKey, (byteBuf, advancementProgress) -> advancementProgress.write((FriendlyByteBuf)((Object)byteBuf)));
            if (VersionHelper.isOrAbove1_21_5()) {
                buf.writeBoolean(showAdvancement);
            }
        }
    }

    public static class RemoveEntityListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            boolean isChange = false;
            IntList intList = buf.readIntIdList();
            int size = intList.size();
            for (int i = 0; i < size; ++i) {
                int entityId = intList.getInt(i);
                EntityPacketHandler handler = user.entityPacketHandlers().remove(entityId);
                if (handler == null || !handler.handleEntitiesRemove(intList)) continue;
                isChange = true;
            }
            if (isChange) {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeIntIdList(intList);
            }
        }
    }

    public static class SoundListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            int id = buf.readVarInt();
            if (id == 0) {
                net.momirealms.craftengine.core.util.Key soundId = buf.readKey();
                Float range = null;
                if (buf.readBoolean()) {
                    range = Float.valueOf(buf.readFloat());
                }
                int source = buf.readVarInt();
                int x = buf.readInt();
                int y = buf.readInt();
                int z = buf.readInt();
                float volume = buf.readFloat();
                float pitch = buf.readFloat();
                long seed = buf.readLong();
                net.momirealms.craftengine.core.util.Key mapped = BukkitBlockManager.instance().replaceSoundIfExist(soundId);
                if (mapped != null) {
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(0);
                    buf.writeKey(mapped);
                    if (range != null) {
                        buf.writeBoolean(true);
                        buf.writeFloat(range.floatValue());
                    } else {
                        buf.writeBoolean(false);
                    }
                    buf.writeVarInt(source);
                    buf.writeInt(x);
                    buf.writeInt(y);
                    buf.writeInt(z);
                    buf.writeFloat(volume);
                    buf.writeFloat(pitch);
                    buf.writeLong(seed);
                }
            } else {
                Optional<Object> optionalSound = FastNMS.INSTANCE.method$IdMap$byId(MBuiltInRegistries.SOUND_EVENT, id - 1);
                if (optionalSound.isEmpty()) {
                    return;
                }
                Object soundEvent = optionalSound.get();
                net.momirealms.craftengine.core.util.Key soundId = KeyUtils.resourceLocationToKey(FastNMS.INSTANCE.method$SoundEvent$location(soundEvent));
                int source = buf.readVarInt();
                int x = buf.readInt();
                int y = buf.readInt();
                int z = buf.readInt();
                float volume = buf.readFloat();
                float pitch = buf.readFloat();
                long seed = buf.readLong();
                net.momirealms.craftengine.core.util.Key mapped = BukkitBlockManager.instance().replaceSoundIfExist(soundId);
                if (mapped != null) {
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(0);
                    Object newId = KeyUtils.toResourceLocation(mapped);
                    Object newSoundEvent = FastNMS.INSTANCE.constructor$SoundEvent(newId, FastNMS.INSTANCE.method$SoundEvent$fixedRange(soundEvent));
                    FastNMS.INSTANCE.method$SoundEvent$directEncode(buf, newSoundEvent);
                    buf.writeVarInt(source);
                    buf.writeInt(x);
                    buf.writeInt(y);
                    buf.writeInt(z);
                    buf.writeFloat(volume);
                    buf.writeFloat(pitch);
                    buf.writeLong(seed);
                }
            }
        }
    }

    public static class ContainerSetContentListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            ItemStack carriedItem;
            Optional<ItemStack> optional;
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readContainerId();
            int stateId = buf.readVarInt();
            int listSize = buf.readVarInt();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(listSize);
            boolean changed = false;
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            for (int i = 0; i < listSize; ++i) {
                ItemStack itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                optional = BukkitItemManager.instance().s2c(itemStack, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer);
                if (optional.isPresent()) {
                    items.add(optional.get());
                    changed = true;
                    continue;
                }
                items.add(itemStack);
            }
            ItemStack newCarriedItem = carriedItem = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            optional = BukkitItemManager.instance().s2c(carriedItem, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer);
            if (optional.isPresent()) {
                changed = true;
                newCarriedItem = optional.get();
            }
            if (!changed) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeContainerId(containerId);
            buf.writeVarInt(stateId);
            buf.writeVarInt(listSize);
            Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            for (ItemStack itemStack : items) {
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, itemStack);
            }
            FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, newCarriedItem);
        }
    }

    public static class ContainerSetSlotListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            ItemStack itemStack;
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readContainerId();
            int stateId = buf.readVarInt();
            short slot = buf.readShort();
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            try {
                itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            }
            catch (Exception e) {
                return;
            }
            BukkitItemManager.instance().s2c(itemStack, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer).ifPresent(newItemStack -> {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeContainerId(containerId);
                buf.writeVarInt(stateId);
                buf.writeShort(slot);
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)newItemStack);
            });
        }
    }

    public static class SetCursorItemListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            ItemStack itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            BukkitItemManager.instance().s2c(itemStack, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer).ifPresent(newItemStack -> {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)newItemStack);
            });
        }
    }

    public static class SetEquipmentListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            byte slotMask;
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            boolean changed = false;
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            int entity = buf.readVarInt();
            ArrayList slots = Lists.newArrayList();
            do {
                slotMask = buf.readByte();
                Object equipmentSlot = CoreReflections.instance$EquipmentSlot$values[slotMask & 0x7F];
                ItemStack itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                Optional<ItemStack> optional = BukkitItemManager.instance().s2c(itemStack, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer);
                if (optional.isPresent()) {
                    changed = true;
                    itemStack = optional.get();
                }
                slots.add(Pair.of((Object)equipmentSlot, (Object)itemStack));
            } while ((slotMask & 0xFFFFFF80) != 0);
            if (changed) {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeVarInt(entity);
                int i = slots.size();
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                for (int j = 0; j < i; ++j) {
                    Pair pair = (Pair)slots.get(j);
                    Enum equipmentSlot = (Enum)pair.getFirst();
                    boolean bl = j != i - 1;
                    int k = equipmentSlot.ordinal();
                    buf.writeByte(bl ? k | 0xFFFFFF80 : k);
                    FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)pair.getSecond());
                }
            }
        }
    }

    public static class SetPlayerInventoryListener1_21_2
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int slot = buf.readVarInt();
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            ItemStack itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            BukkitItemManager.instance().s2c(itemStack, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer).ifPresent(newItemStack -> {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeVarInt(slot);
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)newItemStack);
            });
        }
    }

    public static class SetEntityDataListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int id = buf.readVarInt();
            EntityPacketHandler handler = user.entityPacketHandlers().get(id);
            if (handler != null) {
                handler.handleSetEntityData(serverPlayer, event);
                return;
            }
            if (Config.interceptEntityName()) {
                boolean isChanged = false;
                List<Object> packedItems = FastNMS.INSTANCE.method$ClientboundSetEntityDataPacket$unpack((Object)buf);
                for (int i = 0; i < packedItems.size(); ++i) {
                    Optional optionalTextComponent;
                    Object packedItem = packedItems.get(i);
                    int entityDataId = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$id(packedItem);
                    if (entityDataId != BaseEntityData.CustomName.id() || (optionalTextComponent = (Optional)FastNMS.INSTANCE.field$SynchedEntityData$DataValue$value(packedItem)).isEmpty()) continue;
                    Object textComponent = optionalTextComponent.get();
                    String json = ComponentUtils.minecraftToJson(textComponent);
                    Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
                    if (tokens.isEmpty()) continue;
                    Component component = AdventureHelper.jsonToComponent(json);
                    component = AdventureHelper.replaceText(component, tokens, NetworkTextReplaceContext.of(serverPlayer));
                    Object serializer = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$serializer(packedItem);
                    packedItems.set(i, FastNMS.INSTANCE.constructor$SynchedEntityData$DataValue(entityDataId, serializer, Optional.of(ComponentUtils.adventureToMinecraft(component))));
                    isChanged = true;
                    break;
                }
                if (isChanged) {
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(id);
                    FastNMS.INSTANCE.method$ClientboundSetEntityDataPacket$pack(packedItems, (Object)buf);
                }
            }
        }
    }

    public static class SetCreativeModeSlotListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, ByteBufPacketEvent event) {
            ItemStack itemStack;
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            if (!serverPlayer.isCreativeMode()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            short slotNum = buf.readShort();
            try {
                itemStack = VersionHelper.isOrAbove1_20_5() ? FastNMS.INSTANCE.method$FriendlyByteBuf$readUntrustedItem(friendlyBuf) : FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            }
            catch (Exception e) {
                return;
            }
            BukkitItemManager.instance().c2s(itemStack).ifPresent(newItemStack -> {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeShort(slotNum);
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                if (VersionHelper.isOrAbove1_20_5()) {
                    FastNMS.INSTANCE.method$FriendlyByteBuf$writeUntrustedItem(newFriendlyBuf, (ItemStack)newItemStack);
                } else {
                    FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)newItemStack);
                }
            });
        }
    }

    public static class ContainerClick1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            boolean changed = false;
            Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
            int containerId = buf.readContainerId();
            int stateId = buf.readVarInt();
            short slotNum = buf.readShort();
            byte buttonNum = buf.readByte();
            int clickType = buf.readVarInt();
            int i = buf.readVarInt();
            Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap(i);
            for (int j = 0; j < i; ++j) {
                short k2 = buf.readShort();
                ItemStack itemStack = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                Optional<ItemStack> optional = BukkitItemManager.instance().c2s(itemStack);
                if (optional.isPresent()) {
                    changed = true;
                    itemStack = optional.get();
                }
                changedSlots.put((int)k2, (Object)itemStack);
            }
            ItemStack carriedItem = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
            Optional<ItemStack> optional = BukkitItemManager.instance().c2s(carriedItem);
            if (optional.isPresent()) {
                changed = true;
                carriedItem = optional.get();
            }
            if (changed) {
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeContainerId(containerId);
                buf.writeVarInt(stateId);
                buf.writeShort(slotNum);
                buf.writeByte(buttonNum);
                buf.writeVarInt(clickType);
                buf.writeVarInt(changedSlots.size());
                Object newFriendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(buf);
                changedSlots.forEach((k, v) -> {
                    buf.writeShort((int)k);
                    FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, (ItemStack)v);
                });
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(newFriendlyBuf, carriedItem);
            }
        }
    }

    public class InteractEntityListener
    implements ByteBufferPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, ByteBufPacketEvent event) {
            Runnable mainThreadTask;
            FriendlyByteBuf buf = event.getBuffer();
            int entityId = BukkitNetworkManager.this.hasModelEngine() ? BukkitNetworkManager.this.plugin.compatibilityManager().interactionToBaseEntity(buf.readVarInt()) : buf.readVarInt();
            BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByEntityId(entityId);
            if (furniture == null) {
                return;
            }
            int actionType = buf.readVarInt();
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            if (serverPlayer.isSpectatorMode()) {
                return;
            }
            Player platformPlayer = serverPlayer.platformPlayer();
            Location location = furniture.baseEntity().getLocation();
            if (actionType == 1) {
                boolean usingSecondaryAction = buf.readBoolean();
                if (entityId != furniture.baseEntityId()) {
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(furniture.baseEntityId());
                    buf.writeVarInt(actionType);
                    buf.writeBoolean(usingSecondaryAction);
                }
                mainThreadTask = () -> {
                    if (serverPlayer.isAdventureMode() || !furniture.isValid()) {
                        return;
                    }
                    if (!serverPlayer.canInteractPoint(new Vec3d(location.getX(), location.getY(), location.getZ()), 16.0)) {
                        return;
                    }
                    FurnitureAttemptBreakEvent preBreakEvent = new FurnitureAttemptBreakEvent(serverPlayer.platformPlayer(), furniture);
                    if (EventUtils.fireAndCheckCancel((Event)preBreakEvent)) {
                        return;
                    }
                    if (!BukkitCraftEngine.instance().antiGriefProvider().canBreak(platformPlayer, location)) {
                        return;
                    }
                    FurnitureBreakEvent breakEvent = new FurnitureBreakEvent(serverPlayer.platformPlayer(), furniture);
                    if (EventUtils.fireAndCheckCancel((Event)breakEvent)) {
                        return;
                    }
                    Cancellable cancellable = Cancellable.of(breakEvent::isCancelled, breakEvent::setCancelled);
                    PlayerOptionalContext context = PlayerOptionalContext.of((net.momirealms.craftengine.core.entity.player.Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.FURNITURE, furniture).withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.HAND, InteractionHand.MAIN_HAND).withParameter(DirectContextParameters.ITEM_IN_HAND, serverPlayer.getItemInHand(InteractionHand.MAIN_HAND)).withParameter(DirectContextParameters.POSITION, furniture.position()));
                    furniture.config().execute(context, EventTrigger.LEFT_CLICK);
                    furniture.config().execute(context, EventTrigger.BREAK);
                    if (cancellable.isCancelled()) {
                        return;
                    }
                    CraftEngineFurniture.remove((Furniture)furniture, serverPlayer, !serverPlayer.isCreativeMode(), true);
                };
            } else if (actionType == 2) {
                float x = buf.readFloat();
                float y = buf.readFloat();
                float z = buf.readFloat();
                Location interactionPoint = new Location(platformPlayer.getWorld(), (double)x, (double)y, (double)z);
                InteractionHand hand = buf.readVarInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                boolean usingSecondaryAction = buf.readBoolean();
                if (entityId != furniture.baseEntityId()) {
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(furniture.baseEntityId());
                    buf.writeVarInt(actionType);
                    buf.writeFloat(x).writeFloat(y).writeFloat(z);
                    buf.writeVarInt(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    buf.writeBoolean(usingSecondaryAction);
                }
                mainThreadTask = () -> {
                    if (!furniture.isValid()) {
                        return;
                    }
                    if (!serverPlayer.canInteractPoint(new Vec3d(location.getX(), location.getY(), location.getZ()), 16.0)) {
                        return;
                    }
                    FurnitureInteractEvent interactEvent = new FurnitureInteractEvent(serverPlayer.platformPlayer(), furniture, hand, interactionPoint);
                    if (EventUtils.fireAndCheckCancel((Event)interactEvent)) {
                        return;
                    }
                    Item<ItemStack> itemInHand = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
                    Cancellable cancellable = Cancellable.of(interactEvent::isCancelled, interactEvent::setCancelled);
                    PlayerOptionalContext context = PlayerOptionalContext.of((net.momirealms.craftengine.core.entity.player.Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.FURNITURE, furniture).withParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand).withParameter(DirectContextParameters.HAND, hand).withParameter(DirectContextParameters.POSITION, furniture.position()));
                    furniture.config().execute(context, EventTrigger.RIGHT_CLICK);
                    if (cancellable.isCancelled()) {
                        return;
                    }
                    if (serverPlayer.isSecondaryUseActive() && !itemInHand.isEmpty()) {
                        AABB hitBox = furniture.aabbByEntityId(entityId);
                        if (hitBox == null) {
                            return;
                        }
                        Optional<CustomItem<ItemStack>> optionalCustomItem = itemInHand.getCustomItem();
                        Location eyeLocation = platformPlayer.getEyeLocation();
                        Vector direction = eyeLocation.getDirection();
                        Location endLocation = eyeLocation.clone();
                        endLocation.add(direction.multiply(serverPlayer.getCachedInteractionRange()));
                        Optional<EntityHitResult> result = hitBox.clip(LocationUtils.toVec3d(eyeLocation), LocationUtils.toVec3d(endLocation));
                        if (result.isEmpty()) {
                            return;
                        }
                        EntityHitResult hitResult = result.get();
                        if (optionalCustomItem.isPresent() && !optionalCustomItem.get().behaviors().isEmpty()) {
                            for (ItemBehavior behavior : optionalCustomItem.get().behaviors()) {
                                if (!(behavior instanceof FurnitureItemBehavior)) continue;
                                behavior.useOnBlock(new UseOnContext(serverPlayer, InteractionHand.MAIN_HAND, new BlockHitResult(hitResult.hitLocation(), hitResult.direction(), BlockPos.fromVec3d(hitResult.hitLocation()), false)));
                                return;
                            }
                        }
                        serverPlayer.setResendSound();
                        FastNMS.INSTANCE.simulateInteraction(serverPlayer.serverPlayer(), DirectionUtils.toNMSDirection(hitResult.direction()), hitResult.hitLocation().x, hitResult.hitLocation().y, hitResult.hitLocation().z, LocationUtils.toBlockPos(hitResult.blockPos()));
                    } else if (!serverPlayer.isSecondaryUseActive()) {
                        furniture.findFirstAvailableSeat(entityId).ifPresent(seatPos -> {
                            if (furniture.tryOccupySeat((Seat)seatPos)) {
                                furniture.spawnSeatEntityForPlayer(serverPlayer, (Seat)seatPos);
                            }
                        });
                    }
                };
            } else {
                if (actionType == 0) {
                    int hand = buf.readVarInt();
                    boolean usingSecondaryAction = buf.readBoolean();
                    if (entityId != furniture.baseEntityId()) {
                        event.setChanged(true);
                        buf.clear();
                        buf.writeVarInt(event.packetID());
                        buf.writeVarInt(furniture.baseEntityId());
                        buf.writeVarInt(actionType);
                        buf.writeVarInt(hand);
                        buf.writeBoolean(usingSecondaryAction);
                    }
                    return;
                }
                return;
            }
            if (VersionHelper.isFolia()) {
                platformPlayer.getScheduler().run((Plugin)BukkitCraftEngine.instance().javaPlugin(), t -> mainThreadTask.run(), () -> {});
            } else {
                BukkitCraftEngine.instance().scheduler().executeSync(mainThreadTask);
            }
        }
    }

    public static class CustomPayloadListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketReceive(NetWorkUser user, ByteBufPacketEvent event) {
            if (VersionHelper.isOrAbove1_20_2()) {
                return;
            }
            FriendlyByteBuf byteBuf = event.getBuffer();
            net.momirealms.craftengine.core.util.Key key = byteBuf.readKey();
            if (!key.equals(NetworkManager.MOD_CHANNEL_KEY)) {
                return;
            }
            PayloadHelper.handleReceiver(new UnknownPayload(key, byteBuf.readBytes(byteBuf.readableBytes())), user);
        }
    }

    public static class MerchantOffersListener1_20_5
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readContainerId();
            BukkitItemManager manager = BukkitItemManager.instance();
            List merchantOffers = buf.readCollection(ArrayList::new, byteBuf -> {
                Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf((ByteBuf)byteBuf);
                ItemStack cost1 = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.field$ItemCost$itemStack(FastNMS.INSTANCE.method$StreamDecoder$decode(NetworkReflections.instance$ItemCost$STREAM_CODEC, friendlyBuf)));
                ItemStack result = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                Optional<ItemStack> cost2 = ((Optional)FastNMS.INSTANCE.method$StreamDecoder$decode(NetworkReflections.instance$ItemCost$OPTIONAL_STREAM_CODEC, friendlyBuf)).map(cost -> FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.field$ItemCost$itemStack(cost)));
                boolean outOfStock = byteBuf.readBoolean();
                int uses = byteBuf.readInt();
                int maxUses = byteBuf.readInt();
                int xp = byteBuf.readInt();
                int specialPrice = byteBuf.readInt();
                float priceMultiplier = byteBuf.readFloat();
                int demand = byteBuf.readInt();
                return new MerchantOffer<ItemStack>(manager.wrap(cost1), cost2.map(manager::wrap), manager.wrap(result), outOfStock, uses, maxUses, xp, specialPrice, priceMultiplier, demand);
            });
            for (MerchantOffer offer2 : merchantOffers) {
                offer2.applyClientboundData(item -> manager.s2c((Item<ItemStack>)item, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer));
            }
            int villagerLevel = buf.readVarInt();
            int villagerXp = buf.readVarInt();
            boolean showProgress = buf.readBoolean();
            boolean canRestock = buf.readBoolean();
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeContainerId(containerId);
            buf.writeCollection(merchantOffers, (byteBuf, offer) -> {
                Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf((ByteBuf)byteBuf);
                FastNMS.INSTANCE.method$StreamEncoder$encode(NetworkReflections.instance$ItemCost$STREAM_CODEC, friendlyBuf, this.itemStackToItemCost(offer.cost1().getLiteralObject(), offer.cost1().count()));
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(friendlyBuf, (ItemStack)offer.result().getItem());
                FastNMS.INSTANCE.method$StreamEncoder$encode(NetworkReflections.instance$ItemCost$OPTIONAL_STREAM_CODEC, friendlyBuf, offer.cost2().map(it -> this.itemStackToItemCost(it.getLiteralObject(), it.count())));
                byteBuf.writeBoolean(offer.outOfStock());
                byteBuf.writeInt(offer.uses());
                byteBuf.writeInt(offer.maxUses());
                byteBuf.writeInt(offer.xp());
                byteBuf.writeInt(offer.specialPrice());
                byteBuf.writeFloat(offer.priceMultiplier());
                byteBuf.writeInt(offer.demand());
            });
            buf.writeVarInt(villagerLevel);
            buf.writeVarInt(villagerXp);
            buf.writeBoolean(showProgress);
            buf.writeBoolean(canRestock);
        }

        private Object itemStackToItemCost(Object itemStack, int count) {
            return FastNMS.INSTANCE.constructor$ItemCost(FastNMS.INSTANCE.method$Item$builtInRegistryHolder(FastNMS.INSTANCE.method$ItemStack$getItem(itemStack)), count, FastNMS.INSTANCE.method$DataComponentExactPredicate$allOf(FastNMS.INSTANCE.method$ItemStack$getComponents(itemStack)));
        }
    }

    public static class MerchantOffersListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!(user instanceof BukkitServerPlayer)) {
                return;
            }
            BukkitServerPlayer serverPlayer = (BukkitServerPlayer)user;
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readContainerId();
            BukkitItemManager manager = BukkitItemManager.instance();
            List merchantOffers = buf.readCollection(ArrayList::new, byteBuf -> {
                Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf((ByteBuf)byteBuf);
                ItemStack cost1 = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                ItemStack result = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                ItemStack cost2 = FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf);
                boolean outOfStock = byteBuf.readBoolean();
                int uses = byteBuf.readInt();
                int maxUses = byteBuf.readInt();
                int xp = byteBuf.readInt();
                int specialPrice = byteBuf.readInt();
                float priceMultiplier = byteBuf.readFloat();
                int demand = byteBuf.readInt();
                return new MerchantOffer<ItemStack>(manager.wrap(cost1), Optional.of(manager.wrap(cost2)), manager.wrap(result), outOfStock, uses, maxUses, xp, specialPrice, priceMultiplier, demand);
            });
            for (MerchantOffer offer2 : merchantOffers) {
                offer2.applyClientboundData(item -> manager.s2c((Item<ItemStack>)item, (net.momirealms.craftengine.core.entity.player.Player)serverPlayer));
            }
            int villagerLevel = buf.readVarInt();
            int villagerXp = buf.readVarInt();
            boolean showProgress = buf.readBoolean();
            boolean canRestock = buf.readBoolean();
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeContainerId(containerId);
            buf.writeCollection(merchantOffers, (byteBuf, offer) -> {
                Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf((ByteBuf)byteBuf);
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(friendlyBuf, (ItemStack)offer.cost1().getItem());
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(friendlyBuf, (ItemStack)offer.result().getItem());
                FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(friendlyBuf, (ItemStack)offer.cost2().get().getItem());
                byteBuf.writeBoolean(offer.outOfStock());
                byteBuf.writeInt(offer.uses());
                byteBuf.writeInt(offer.maxUses());
                byteBuf.writeInt(offer.xp());
                byteBuf.writeInt(offer.specialPrice());
                byteBuf.writeFloat(offer.priceMultiplier());
                byteBuf.writeInt(offer.demand());
            });
            buf.writeVarInt(villagerLevel);
            buf.writeVarInt(villagerXp);
            buf.writeBoolean(showProgress);
            buf.writeBoolean(canRestock);
        }
    }

    public class AddEntityListener
    implements ByteBufferPacketListener {
        private final EntityTypeHandler[] handlers;

        public AddEntityListener(int entityTypes) {
            this.handlers = new EntityTypeHandler[entityTypes];
            Arrays.fill(this.handlers, EntityTypeHandler.DoNothing.INSTANCE);
            this.handlers[MEntityTypes.BLOCK_DISPLAY$registryId] = AddEntityListener.simpleAddEntityHandler(BlockDisplayPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.TEXT_DISPLAY$registryId] = AddEntityListener.simpleAddEntityHandler(TextDisplayPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.ARMOR_STAND$registryId] = AddEntityListener.simpleAddEntityHandler(ArmorStandPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.ITEM$registryId] = AddEntityListener.simpleAddEntityHandler(CommonItemPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.ITEM_FRAME$registryId] = AddEntityListener.simpleAddEntityHandler(ItemFramePacketHandler.INSTANCE);
            this.handlers[MEntityTypes.GLOW_ITEM_FRAME$registryId] = AddEntityListener.simpleAddEntityHandler(ItemFramePacketHandler.INSTANCE);
            this.handlers[MEntityTypes.ENDERMAN$registryId] = AddEntityListener.simpleAddEntityHandler(EndermanPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.CHEST_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.COMMAND_BLOCK_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.FURNACE_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.HOPPER_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.SPAWNER_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.TNT_MINECART$registryId] = AddEntityListener.simpleAddEntityHandler(MinecartPacketHandler.INSTANCE);
            this.handlers[MEntityTypes.FIREBALL$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.EYE_OF_ENDER$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.FIREWORK_ROCKET$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.SMALL_FIREBALL$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.EGG$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.ENDER_PEARL$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.EXPERIENCE_BOTTLE$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.SNOWBALL$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.POTION$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(true);
            this.handlers[MEntityTypes.TRIDENT$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(false);
            this.handlers[MEntityTypes.ARROW$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(false);
            this.handlers[MEntityTypes.SPECTRAL_ARROW$registryId] = AddEntityListener.createOptionalCustomProjectileEntityHandler(false);
            if (VersionHelper.isOrAbove1_20_3()) {
                this.handlers[MEntityTypes.TNT$registryId] = AddEntityListener.simpleAddEntityHandler(PrimedTNTPacketHandler.INSTANCE);
            }
            if (VersionHelper.isOrAbove1_20_5()) {
                this.handlers[MEntityTypes.OMINOUS_ITEM_SPAWNER$registryId] = AddEntityListener.simpleAddEntityHandler(CommonItemPacketHandler.INSTANCE);
            }
            this.handlers[MEntityTypes.FALLING_BLOCK$registryId] = (user, event) -> {
                FriendlyByteBuf buf = event.getBuffer();
                int id = buf.readVarInt();
                UUID uuid = buf.readUUID();
                int type = buf.readVarInt();
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                Vec3d movement = VersionHelper.isOrAbove1_21_9() ? buf.readLpVec3() : null;
                byte xRot = buf.readByte();
                byte yRot = buf.readByte();
                byte yHeadRot = buf.readByte();
                int data = buf.readVarInt();
                int remapped = BukkitNetworkManager.this.remapBlockState(data, user.clientModEnabled());
                if (remapped != data) {
                    int xa = VersionHelper.isOrAbove1_21_9() ? -1 : (int)buf.readShort();
                    int ya = VersionHelper.isOrAbove1_21_9() ? -1 : (int)buf.readShort();
                    int za = VersionHelper.isOrAbove1_21_9() ? -1 : (int)buf.readShort();
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeVarInt(id);
                    buf.writeUUID(uuid);
                    buf.writeVarInt(type);
                    buf.writeDouble(x);
                    buf.writeDouble(y);
                    buf.writeDouble(z);
                    if (VersionHelper.isOrAbove1_21_9()) {
                        buf.writeLpVec3(movement);
                    }
                    buf.writeByte(xRot);
                    buf.writeByte(yRot);
                    buf.writeByte(yHeadRot);
                    buf.writeVarInt(remapped);
                    if (!VersionHelper.isOrAbove1_21_9()) {
                        buf.writeShort(xa);
                    }
                    if (!VersionHelper.isOrAbove1_21_9()) {
                        buf.writeShort(ya);
                    }
                    if (!VersionHelper.isOrAbove1_21_9()) {
                        buf.writeShort(za);
                    }
                }
            };
            this.handlers[MEntityTypes.ITEM_DISPLAY$registryId] = (user, event) -> {
                FriendlyByteBuf buf = event.getBuffer();
                int id = buf.readVarInt();
                BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(id);
                if (furniture != null) {
                    user.entityPacketHandlers().put(id, new FurniturePacketHandler(furniture.fakeEntityIds()));
                    user.sendPacket(furniture.spawnPacket((Player)user.platformPlayer()), false);
                    if (Config.hideBaseEntity() && !furniture.hasExternalModel()) {
                        event.setCancelled(true);
                    }
                } else {
                    user.entityPacketHandlers().put(id, ItemDisplayPacketHandler.INSTANCE);
                }
            };
            this.handlers[MEntityTypes.INTERACTION$registryId] = (user, event) -> {
                if (BukkitFurnitureManager.NMS_COLLISION_ENTITY_TYPE != MEntityTypes.INTERACTION) {
                    return;
                }
                FriendlyByteBuf buf = event.getBuffer();
                int id = buf.readVarInt();
                BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(id);
                if (furniture != null) {
                    event.setCancelled(true);
                    user.entityPacketHandlers().put(id, FurnitureCollisionPacketHandler.INSTANCE);
                }
            };
            this.handlers[MEntityTypes.OAK_BOAT$registryId] = (user, event) -> {
                if (BukkitFurnitureManager.NMS_COLLISION_ENTITY_TYPE != MEntityTypes.OAK_BOAT) {
                    return;
                }
                FriendlyByteBuf buf = event.getBuffer();
                int id = buf.readVarInt();
                BukkitFurniture furniture = BukkitFurnitureManager.instance().loadedFurnitureByRealEntityId(id);
                if (furniture != null) {
                    event.setCancelled(true);
                    user.entityPacketHandlers().put(id, FurnitureCollisionPacketHandler.INSTANCE);
                }
            };
        }

        private static EntityTypeHandler simpleAddEntityHandler(EntityPacketHandler handler) {
            return (user, event) -> {
                FriendlyByteBuf buf = event.getBuffer();
                user.entityPacketHandlers().put(buf.readVarInt(), handler);
            };
        }

        private static EntityTypeHandler createOptionalCustomProjectileEntityHandler(boolean fallback) {
            return (user, event) -> {
                FriendlyByteBuf buf = event.getBuffer();
                int id = buf.readVarInt();
                BukkitProjectileManager.instance().projectileByEntityId(id).ifPresentOrElse(customProjectile -> {
                    ProjectilePacketHandler handler = new ProjectilePacketHandler((BukkitCustomProjectile)customProjectile, id);
                    handler.convertAddCustomProjectilePacket(buf, event);
                    user.entityPacketHandlers().put(id, handler);
                }, () -> {
                    if (fallback) {
                        user.entityPacketHandlers().put(id, CommonItemPacketHandler.INSTANCE);
                    }
                });
            };
        }

        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            FriendlyByteBuf buf = event.getBuffer();
            buf.readVarInt();
            buf.readUUID();
            int type = buf.readVarInt();
            this.handlers[type].handle(user, event);
        }

        public static interface EntityTypeHandler {
            public void handle(NetWorkUser var1, ByteBufPacketEvent var2);

            public static class DoNothing
            implements EntityTypeHandler {
                public static final DoNothing INSTANCE = new DoNothing();

                @Override
                public void handle(NetWorkUser user, ByteBufPacketEvent event) {
                }
            }
        }
    }

    public static class OpenScreenListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptContainer()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readVarInt();
            int type = buf.readVarInt();
            Tag nbt = buf.readNbt(false);
            if (nbt == null) {
                return;
            }
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
            if (tokens.isEmpty()) {
                return;
            }
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeVarInt(containerId);
            buf.writeVarInt(type);
            buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
        }
    }

    public static class OpenScreenListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptContainer()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            int containerId = buf.readVarInt();
            int type = buf.readVarInt();
            String json = buf.readUtf();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeVarInt(containerId);
            buf.writeVarInt(type);
            buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
        }
    }

    public class SystemChatListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            Map<String, ComponentProvider> tokens;
            FriendlyByteBuf buf = event.getBuffer();
            Tag nbt = buf.readNbt(false);
            if (nbt == null) {
                return;
            }
            boolean overlay = buf.readBoolean();
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            Component component = AdventureHelper.tagToComponent(nbt);
            if (Config.interceptSystemChat() && !(tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString())).isEmpty()) {
                component = AdventureHelper.replaceText(component, tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user));
            }
            component = AdventureHelper.replaceShowItem(component, s -> BukkitNetworkManager.this.replaceShowItem((HoverEvent.ShowItem)s, (BukkitServerPlayer)user));
            buf.writeNbt(AdventureHelper.componentToTag(component), false);
            buf.writeBoolean(overlay);
        }
    }

    public class SystemChatListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            Map<String, ComponentProvider> tokens;
            FriendlyByteBuf buf = event.getBuffer();
            String jsonOrPlainString = buf.readUtf();
            Tag tag = (Tag)MRegistryOps.JSON.convertTo(MRegistryOps.SPARROW_NBT, (Object)((JsonElement)GsonHelper.get().fromJson(jsonOrPlainString, JsonElement.class)));
            Component component = AdventureHelper.nbtToComponent(tag);
            boolean overlay = buf.readBoolean();
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            if (Config.interceptSystemChat() && !(tokens = CraftEngine.instance().fontManager().matchTags(jsonOrPlainString)).isEmpty()) {
                component = AdventureHelper.replaceText(component, tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user));
            }
            component = AdventureHelper.replaceShowItem(component, s -> BukkitNetworkManager.this.replaceShowItem((HoverEvent.ShowItem)s, (BukkitServerPlayer)user));
            buf.writeUtf(((JsonElement)MRegistryOps.SPARROW_NBT.convertTo(MRegistryOps.JSON, (Object)AdventureHelper.componentToNbt(component))).toString());
            buf.writeBoolean(overlay);
        }
    }

    public static class SetActionBarListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptActionBar()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            Tag nbt = buf.readNbt(false);
            if (nbt == null) {
                return;
            }
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
        }
    }

    public static class SetActionBarListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptActionBar()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String json = buf.readUtf();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
        }
    }

    public static class TabListListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTabList()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            Tag nbt1 = buf.readNbt(false);
            if (nbt1 == null) {
                return;
            }
            Tag nbt2 = buf.readNbt(false);
            if (nbt2 == null) {
                return;
            }
            Map<String, ComponentProvider> tokens1 = CraftEngine.instance().fontManager().matchTags(nbt1.getAsString());
            Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(nbt2.getAsString());
            if (tokens1.isEmpty() && tokens2.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            NetworkTextReplaceContext context = NetworkTextReplaceContext.of((BukkitServerPlayer)user);
            buf.writeNbt(tokens1.isEmpty() ? nbt1 : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt1), tokens1, context)), false);
            buf.writeNbt(tokens2.isEmpty() ? nbt2 : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt2), tokens2, context)), false);
        }
    }

    public static class TabListListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTabList()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String json1 = buf.readUtf();
            String json2 = buf.readUtf();
            Map<String, ComponentProvider> tokens1 = CraftEngine.instance().fontManager().matchTags(json1);
            Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(json2);
            if (tokens1.isEmpty() && tokens2.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            NetworkTextReplaceContext context = NetworkTextReplaceContext.of((BukkitServerPlayer)user);
            buf.writeUtf(tokens1.isEmpty() ? json1 : AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json1), tokens1, context)));
            buf.writeUtf(tokens2.isEmpty() ? json2 : AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json2), tokens2, context)));
        }
    }

    public static class SetTitleListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTitle()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            Tag nbt = buf.readNbt(false);
            if (nbt == null) {
                return;
            }
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
        }
    }

    public static class SetTitleListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTitle()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String json = buf.readUtf();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
        }
    }

    public static class SetSubtitleListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTitle()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            Tag nbt = buf.readNbt(false);
            if (nbt == null) {
                return;
            }
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
        }
    }

    public static class SetSubtitleListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTitle()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String json = buf.readUtf();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
        }
    }

    public static class BossEventListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptBossBar()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            UUID uuid = buf.readUUID();
            int actionType = buf.readVarInt();
            if (actionType == 0) {
                Tag nbt = buf.readNbt(false);
                if (nbt == null) {
                    return;
                }
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
                if (tokens.isEmpty()) {
                    return;
                }
                float health = buf.readFloat();
                int color = buf.readVarInt();
                int division = buf.readVarInt();
                byte flag = buf.readByte();
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUUID(uuid);
                buf.writeVarInt(actionType);
                buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                buf.writeFloat(health);
                buf.writeVarInt(color);
                buf.writeVarInt(division);
                buf.writeByte(flag);
            } else if (actionType == 3) {
                Tag nbt = buf.readNbt(false);
                if (nbt == null) {
                    return;
                }
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(nbt.getAsString());
                if (tokens.isEmpty()) {
                    return;
                }
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUUID(uuid);
                buf.writeVarInt(actionType);
                buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(nbt), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
            }
        }
    }

    public static class BossEventListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptBossBar()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            UUID uuid = buf.readUUID();
            int actionType = buf.readVarInt();
            if (actionType == 0) {
                String json = buf.readUtf();
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
                if (tokens.isEmpty()) {
                    return;
                }
                float health = buf.readFloat();
                int color = buf.readVarInt();
                int division = buf.readVarInt();
                byte flag = buf.readByte();
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUUID(uuid);
                buf.writeVarInt(actionType);
                buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
                buf.writeFloat(health);
                buf.writeVarInt(color);
                buf.writeVarInt(division);
                buf.writeByte(flag);
            } else if (actionType == 3) {
                String json = buf.readUtf();
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
                if (tokens.isEmpty()) {
                    return;
                }
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUUID(uuid);
                buf.writeVarInt(actionType);
                buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
            }
        }
    }

    public static class TeamListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTeam()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String name = buf.readUtf();
            byte method = buf.readByte();
            if (method != 2 && method != 0) {
                return;
            }
            Tag displayName = buf.readNbt(false);
            if (displayName == null) {
                return;
            }
            byte friendlyFlags = buf.readByte();
            Either eitherVisibility = VersionHelper.isOrAbove1_21_5() ? Either.right((Object)buf.readVarInt()) : Either.left((Object)buf.readUtf(40));
            Either eitherCollisionRule = VersionHelper.isOrAbove1_21_5() ? Either.right((Object)buf.readVarInt()) : Either.left((Object)buf.readUtf(40));
            int color = buf.readVarInt();
            Tag prefix = buf.readNbt(false);
            if (prefix == null) {
                return;
            }
            Tag suffix = buf.readNbt(false);
            if (suffix == null) {
                return;
            }
            Map<String, ComponentProvider> tokens1 = CraftEngine.instance().fontManager().matchTags(displayName.getAsString());
            Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(prefix.getAsString());
            Map<String, ComponentProvider> tokens3 = CraftEngine.instance().fontManager().matchTags(suffix.getAsString());
            if (tokens1.isEmpty() && tokens2.isEmpty() && tokens3.isEmpty()) {
                return;
            }
            NetworkTextReplaceContext context = NetworkTextReplaceContext.of((BukkitServerPlayer)user);
            List<String> entities = method == 0 ? buf.readStringList() : null;
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(name);
            buf.writeByte(method);
            buf.writeNbt(tokens1.isEmpty() ? displayName : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(displayName), tokens1, context)), false);
            buf.writeByte(friendlyFlags);
            eitherVisibility.ifLeft(buf::writeUtf).ifRight(buf::writeVarInt);
            eitherCollisionRule.ifLeft(buf::writeUtf).ifRight(buf::writeVarInt);
            buf.writeVarInt(color);
            buf.writeNbt(tokens2.isEmpty() ? prefix : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(prefix), tokens2, context)), false);
            buf.writeNbt(tokens3.isEmpty() ? suffix : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(suffix), tokens3, context)), false);
            if (entities != null) {
                buf.writeStringList(entities);
            }
        }
    }

    public static class TeamListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptTeam()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String name = buf.readUtf();
            byte method = buf.readByte();
            if (method != 2 && method != 0) {
                return;
            }
            String displayName = buf.readUtf();
            byte friendlyFlags = buf.readByte();
            String nameTagVisibility = buf.readUtf(40);
            String collisionRule = buf.readUtf(40);
            int color = buf.readVarInt();
            String prefix = buf.readUtf();
            String suffix = buf.readUtf();
            Map<String, ComponentProvider> tokens1 = CraftEngine.instance().fontManager().matchTags(displayName);
            Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(prefix);
            Map<String, ComponentProvider> tokens3 = CraftEngine.instance().fontManager().matchTags(suffix);
            if (tokens1.isEmpty() && tokens2.isEmpty() && tokens3.isEmpty()) {
                return;
            }
            event.setChanged(true);
            NetworkTextReplaceContext context = NetworkTextReplaceContext.of((BukkitServerPlayer)user);
            List<String> entities = method == 0 ? buf.readStringList() : null;
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(name);
            buf.writeByte(method);
            buf.writeUtf(tokens1.isEmpty() ? displayName : AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(displayName), tokens1, context)));
            buf.writeByte(friendlyFlags);
            buf.writeUtf(nameTagVisibility);
            buf.writeUtf(collisionRule);
            buf.writeVarInt(color);
            buf.writeUtf(tokens2.isEmpty() ? prefix : AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(prefix), tokens2, context)));
            buf.writeUtf(tokens3.isEmpty() ? suffix : AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(suffix), tokens3, context)));
            if (entities != null) {
                buf.writeStringList(entities);
            }
        }
    }

    public static class SetObjectiveListener1_20_3
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptScoreboard()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String objective = buf.readUtf();
            byte mode = buf.readByte();
            if (mode != 0 && mode != 2) {
                return;
            }
            Tag displayName = buf.readNbt(false);
            if (displayName == null) {
                return;
            }
            int renderType = buf.readVarInt();
            boolean optionalNumberFormat = buf.readBoolean();
            if (optionalNumberFormat) {
                int format = buf.readVarInt();
                if (format == 0) {
                    Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(displayName.getAsString());
                    if (tokens.isEmpty()) {
                        return;
                    }
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeUtf(objective);
                    buf.writeByte(mode);
                    buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(displayName), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                    buf.writeVarInt(renderType);
                    buf.writeBoolean(true);
                    buf.writeVarInt(0);
                } else if (format == 1) {
                    Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(displayName.getAsString());
                    if (tokens.isEmpty()) {
                        return;
                    }
                    Tag style = buf.readNbt(false);
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeUtf(objective);
                    buf.writeByte(mode);
                    buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(displayName), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                    buf.writeVarInt(renderType);
                    buf.writeBoolean(true);
                    buf.writeVarInt(1);
                    buf.writeNbt(style, false);
                } else if (format == 2) {
                    Tag fixed = buf.readNbt(false);
                    if (fixed == null) {
                        return;
                    }
                    Map<String, ComponentProvider> tokens1 = CraftEngine.instance().fontManager().matchTags(displayName.getAsString());
                    Map<String, ComponentProvider> tokens2 = CraftEngine.instance().fontManager().matchTags(fixed.getAsString());
                    if (tokens1.isEmpty() && tokens2.isEmpty()) {
                        return;
                    }
                    event.setChanged(true);
                    buf.clear();
                    buf.writeVarInt(event.packetID());
                    buf.writeUtf(objective);
                    buf.writeByte(mode);
                    buf.writeNbt(tokens1.isEmpty() ? displayName : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(displayName), tokens1, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                    buf.writeVarInt(renderType);
                    buf.writeBoolean(true);
                    buf.writeVarInt(2);
                    buf.writeNbt(tokens2.isEmpty() ? fixed : AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(fixed), tokens2, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                }
            } else {
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(displayName.getAsString());
                if (tokens.isEmpty()) {
                    return;
                }
                event.setChanged(true);
                buf.clear();
                buf.writeVarInt(event.packetID());
                buf.writeUtf(objective);
                buf.writeByte(mode);
                buf.writeNbt(AdventureHelper.componentToTag(AdventureHelper.replaceText(AdventureHelper.tagToComponent(displayName), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))), false);
                buf.writeVarInt(renderType);
                buf.writeBoolean(false);
            }
        }
    }

    public static class SetObjectiveListener1_20
    implements ByteBufferPacketListener {
        @Override
        public void onPacketSend(NetWorkUser user, ByteBufPacketEvent event) {
            if (!Config.interceptScoreboard()) {
                return;
            }
            FriendlyByteBuf buf = event.getBuffer();
            String objective = buf.readUtf();
            byte mode = buf.readByte();
            if (mode != 0 && mode != 2) {
                return;
            }
            String displayName = buf.readUtf();
            int renderType = buf.readVarInt();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(displayName);
            if (tokens.isEmpty()) {
                return;
            }
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeUtf(objective);
            buf.writeByte(mode);
            buf.writeUtf(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(displayName), tokens, NetworkTextReplaceContext.of((BukkitServerPlayer)user))));
            buf.writeVarInt(renderType);
        }
    }

    public class ServerChannelHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object c) throws Exception {
            Channel channel = (Channel)c;
            channel.pipeline().addLast(BukkitNetworkManager.SERVER_CHANNEL_HANDLER_NAME, (ChannelHandler)new PreChannelInitializer());
            super.channelRead(context, c);
        }
    }

    public class PluginChannelHandler
    extends ChannelDuplexHandler {
        private final NetWorkUser player;

        public PluginChannelHandler(NetWorkUser player) {
            this.player = player;
        }

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) throws Exception {
            try {
                NMSPacketEvent event = new NMSPacketEvent(packet);
                BukkitNetworkManager.this.onNMSPacketSend(this.player, event, packet);
                if (event.isCancelled()) {
                    return;
                }
                if (event.isUsingNewPacket()) {
                    super.write(context, event.optionalNewPacket(), channelPromise);
                } else {
                    super.write(context, packet, channelPromise);
                }
            }
            catch (Throwable e) {
                BukkitNetworkManager.this.plugin.logger().severe("An error occurred when reading packets. Packet class: " + String.valueOf(packet.getClass()), e);
                super.write(context, packet, channelPromise);
            }
        }

        public void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object packet) throws Exception {
            NMSPacketEvent event = new NMSPacketEvent(packet);
            BukkitNetworkManager.this.onNMSPacketReceive(this.player, event, packet);
            if (event.isCancelled()) {
                return;
            }
            if (event.isUsingNewPacket()) {
                super.channelRead(context, event.optionalNewPacket());
            } else {
                super.channelRead(context, packet);
            }
        }
    }

    public class PluginChannelDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        private final NetWorkUser player;
        public boolean relocated = false;

        public PluginChannelDecoder(NetWorkUser player) {
            this.player = player;
        }

        public PluginChannelDecoder(PluginChannelDecoder decoder) {
            this.player = decoder.player;
            this.relocated = decoder.relocated;
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            this.onByteBufReceive(byteBuf);
            if (byteBuf.isReadable()) {
                list.add(byteBuf.retain());
            }
        }

        private void onByteBufReceive(ByteBuf buffer) {
            if (this.player.decoderState() != ConnectionState.PLAY) {
                return;
            }
            int size = buffer.readableBytes();
            if (size != 0) {
                FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
                int preProcessIndex = buf.readerIndex();
                int packetId = buf.readVarInt();
                int preIndex = buf.readerIndex();
                try {
                    ByteBufPacketEvent event = new ByteBufPacketEvent(packetId, buf, preIndex);
                    BukkitNetworkManager.this.handleC2SByteBufPacket(this.player, event);
                    if (event.isCancelled()) {
                        buf.clear();
                    } else if (!event.changed()) {
                        buf.readerIndex(preProcessIndex);
                    }
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("An error occurred when reading packet " + packetId, e);
                    buf.readerIndex(preProcessIndex);
                }
            }
        }
    }

    public class PluginChannelEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        private final NetWorkUser player;
        private boolean handledCompression = false;

        public PluginChannelEncoder(NetWorkUser player) {
            this.player = player;
        }

        public PluginChannelEncoder(PluginChannelEncoder encoder) {
            this.player = encoder.player;
            this.handledCompression = encoder.handledCompression;
        }

        protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            boolean needCompression = !this.handledCompression && this.handleCompression(channelHandlerContext, byteBuf);
            this.onByteBufSend(byteBuf);
            if (needCompression) {
                BukkitNetworkManager.this.compress(channelHandlerContext, byteBuf);
            }
            if (!byteBuf.isReadable()) {
                throw CancelPacketException.INSTANCE;
            }
            list.add(byteBuf.retain());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ExceptionUtils.hasException(cause, CancelPacketException.INSTANCE)) {
                return;
            }
            super.exceptionCaught(ctx, cause);
        }

        private boolean handleCompression(ChannelHandlerContext ctx, ByteBuf buffer) {
            if (this.handledCompression) {
                return false;
            }
            int compressIndex = ctx.pipeline().names().indexOf("compress");
            if (compressIndex == -1) {
                return false;
            }
            this.handledCompression = true;
            int encoderIndex = ctx.pipeline().names().indexOf(BukkitNetworkManager.PACKET_ENCODER);
            if (encoderIndex == -1) {
                return false;
            }
            if (compressIndex > encoderIndex) {
                BukkitNetworkManager.this.decompress(ctx, buffer, buffer);
                PluginChannelDecoder decoder = (PluginChannelDecoder)ctx.pipeline().get(BukkitNetworkManager.PACKET_DECODER);
                if (decoder != null) {
                    if (decoder.relocated) {
                        return true;
                    }
                    decoder.relocated = true;
                }
                PluginChannelEncoder encoder = (PluginChannelEncoder)ctx.pipeline().remove(BukkitNetworkManager.PACKET_ENCODER);
                String encoderName = ctx.pipeline().names().contains("outbound_config") ? "outbound_config" : "encoder";
                ctx.pipeline().addBefore(encoderName, BukkitNetworkManager.PACKET_ENCODER, (ChannelHandler)new PluginChannelEncoder(encoder));
                decoder = (PluginChannelDecoder)ctx.pipeline().remove(BukkitNetworkManager.PACKET_DECODER);
                String decoderName = ctx.pipeline().names().contains("inbound_config") ? "inbound_config" : "decoder";
                ctx.pipeline().addBefore(decoderName, BukkitNetworkManager.PACKET_DECODER, (ChannelHandler)new PluginChannelDecoder(decoder));
                return true;
            }
            return false;
        }

        private void onByteBufSend(ByteBuf buffer) {
            if (this.player.encoderState() != ConnectionState.PLAY) {
                return;
            }
            int size = buffer.readableBytes();
            if (size != 0) {
                FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
                int preProcessIndex = buf.readerIndex();
                int packetId = buf.readVarInt();
                int preIndex = buf.readerIndex();
                try {
                    ByteBufPacketEvent event = new ByteBufPacketEvent(packetId, buf, preIndex);
                    BukkitNetworkManager.this.handleS2CByteBufPacket(this.player, event);
                    if (event.isCancelled()) {
                        buf.clear();
                    } else if (!event.changed()) {
                        buf.readerIndex(preProcessIndex);
                    }
                }
                catch (Throwable e) {
                    CraftEngine.instance().logger().warn("An error occurred when writing packet " + packetId, e);
                    buf.readerIndex(preProcessIndex);
                }
            }
        }
    }

    public class PreChannelInitializer
    extends ChannelInboundHandlerAdapter {
        private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);

        public void channelRegistered(ChannelHandlerContext context) {
            try {
                BukkitNetworkManager.this.injectChannel(context.channel(), ConnectionState.HANDSHAKING);
            }
            catch (Throwable t) {
                this.exceptionCaught(context, t);
            }
            finally {
                ChannelPipeline pipeline = context.pipeline();
                if (pipeline.context((ChannelHandler)this) != null) {
                    pipeline.remove((ChannelHandler)this);
                }
            }
            context.pipeline().fireChannelRegistered();
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable t) {
            logger.warn("Failed to inject channel: " + String.valueOf(context.channel()), t);
            context.close();
        }
    }
}

