/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network.id;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.network.PacketFlow;
import net.momirealms.craftengine.core.util.VersionHelper;

public class PlayPacketIdHelper {
    private static final Map<PacketFlow, Map<String, Integer>> byName = new EnumMap<PacketFlow, Map<String, Integer>>(PacketFlow.class);
    private static final Map<PacketFlow, String[]> byId = new EnumMap<PacketFlow, String[]>(PacketFlow.class);
    private static final Map<PacketFlow, Map<Class<?>, Integer>> byClazz = new EnumMap(PacketFlow.class);

    public static int count(PacketFlow direction) {
        if (VersionHelper.isOrAbove1_20_5()) {
            return byName.getOrDefault((Object)direction, Collections.emptyMap()).size();
        }
        return byClazz.getOrDefault((Object)direction, Collections.emptyMap()).size();
    }

    public static String byId(int id, PacketFlow direction) {
        return byId.get((Object)direction)[id];
    }

    public static int byName(String packetName, PacketFlow direction) {
        return byName.get((Object)direction).getOrDefault(packetName, -1);
    }

    public static int byClazz(Class<?> clazz, PacketFlow direction) {
        return byClazz.get((Object)direction).getOrDefault(clazz, -1);
    }

    static {
        try {
            if (VersionHelper.isOrAbove1_21()) {
                Iterator<Map.Entry<Object, Map<Object, Integer>>> packetReport = CoreReflections.constructor$PacketReport.newInstance(new Object[]{null});
                JsonObject jsonObject = ((JsonElement)CoreReflections.method$PacketReport$serializePackets.invoke(packetReport, new Object[0])).getAsJsonObject();
                JsonObject playData = jsonObject.get("play").getAsJsonObject();
                for (Map.Entry entry : playData.entrySet()) {
                    HashMap<String, Integer> ids = new HashMap<String, Integer>();
                    byName.put(PacketFlow.valueOf(((String)entry.getKey()).toUpperCase(Locale.ROOT)), ids);
                    for (Map.Entry entry2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                        ids.put((String)entry2.getKey(), ((JsonElement)entry2.getValue()).getAsJsonObject().get("protocol_id").getAsInt());
                    }
                }
            } else if (VersionHelper.isOrAbove1_20_5()) {
                for (Map.Entry<String, Map<Object, Integer>> entry : FastNMS.INSTANCE.gamePacketIdsByName().entrySet()) {
                    byName.put(PacketFlow.valueOf(entry.getKey().toUpperCase(Locale.ROOT)), entry.getValue());
                }
            } else {
                for (Map.Entry<String, Map<Object, Integer>> entry : FastNMS.INSTANCE.gamePacketIdsByClazz().entrySet()) {
                    byClazz.put(PacketFlow.valueOf(entry.getKey().toUpperCase(Locale.ROOT)), entry.getValue());
                }
            }
            if (!byName.isEmpty()) {
                for (Map.Entry<Object, Map<Object, Integer>> entry : byName.entrySet()) {
                    String[] ids = new String[entry.getValue().size()];
                    for (Map.Entry entry2 : entry.getValue().entrySet()) {
                        ids[((Integer)entry2.getValue()).intValue()] = (String)entry2.getKey();
                    }
                    byId.put((PacketFlow)((Object)entry.getKey()), ids);
                }
            }
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to init packet registry", e);
        }
    }
}

