/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.reflection.minecraft;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import net.momirealms.craftengine.bukkit.plugin.reflection.ReflectionInitException;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;

public final class MBuiltInRegistries {
    public static final Object BLOCK;
    public static final Object ITEM;
    public static final Object ATTRIBUTE;
    public static final Object MOB_EFFECT;
    public static final Object SOUND_EVENT;
    public static final Object ENTITY_TYPE;
    public static final Object FLUID;
    public static final Object RECIPE_TYPE;
    public static final Object PARTICLE_TYPE;
    public static final Object DATA_COMPONENT_TYPE;
    public static final Object LOOT_POOL_ENTRY_TYPE;
    public static final Object GAME_EVENT;

    private MBuiltInRegistries() {
    }

    static {
        Field[] fields = CoreReflections.clazz$BuiltInRegistries.getDeclaredFields();
        try {
            Object registries$Block = null;
            Object registries$Attribute = null;
            Object registries$MobEffect = null;
            Object registries$SoundEvent = null;
            Object registries$ParticleType = null;
            Object registries$EntityType = null;
            Object registries$Item = null;
            Object registries$Fluid = null;
            Object registries$RecipeType = null;
            Object registries$DataComponentType = null;
            Object registries$LootPoolEntryType = null;
            Object registries$GameEvent = null;
            for (Field field : fields) {
                Type fieldType = field.getGenericType();
                if (!(fieldType instanceof ParameterizedType)) continue;
                ParameterizedType paramType = (ParameterizedType)fieldType;
                Type type = paramType.getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type rawType = parameterizedType.getRawType();
                    if (rawType == CoreReflections.clazz$ParticleType) {
                        registries$ParticleType = field.get(null);
                        continue;
                    }
                    if (rawType == CoreReflections.clazz$EntityType) {
                        registries$EntityType = field.get(null);
                        continue;
                    }
                    if (rawType == CoreReflections.clazz$RecipeType) {
                        registries$RecipeType = field.get(null);
                        continue;
                    }
                    if (rawType != CoreReflections.clazz$DataComponentType || registries$DataComponentType != null) continue;
                    registries$DataComponentType = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$Block) {
                    registries$Block = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$Attribute) {
                    registries$Attribute = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$MobEffect) {
                    registries$MobEffect = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$SoundEvent) {
                    registries$SoundEvent = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$Item) {
                    registries$Item = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$Fluid) {
                    registries$Fluid = field.get(null);
                    continue;
                }
                if (type == CoreReflections.clazz$LootPoolEntryType) {
                    registries$LootPoolEntryType = field.get(null);
                    continue;
                }
                if (type != CoreReflections.clazz$GameEvent) continue;
                registries$GameEvent = field.get(null);
            }
            BLOCK = Objects.requireNonNull(registries$Block);
            ITEM = Objects.requireNonNull(registries$Item);
            ATTRIBUTE = Objects.requireNonNull(registries$Attribute);
            MOB_EFFECT = Objects.requireNonNull(registries$MobEffect);
            SOUND_EVENT = Objects.requireNonNull(registries$SoundEvent);
            PARTICLE_TYPE = Objects.requireNonNull(registries$ParticleType);
            ENTITY_TYPE = Objects.requireNonNull(registries$EntityType);
            FLUID = Objects.requireNonNull(registries$Fluid);
            RECIPE_TYPE = Objects.requireNonNull(registries$RecipeType);
            LOOT_POOL_ENTRY_TYPE = Objects.requireNonNull(registries$LootPoolEntryType);
            DATA_COMPONENT_TYPE = registries$DataComponentType;
            GAME_EVENT = Objects.requireNonNull(registries$GameEvent);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionInitException("Failed to init BuiltInRegistries", e);
        }
    }
}

