/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.scheduler.impl;

import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.scheduler.impl.BukkitTask;
import net.momirealms.craftengine.core.plugin.scheduler.DummyTask;
import net.momirealms.craftengine.core.plugin.scheduler.RegionExecutor;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerTask;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitExecutor
implements RegionExecutor<World> {
    private final BukkitCraftEngine plugin;

    public BukkitExecutor(BukkitCraftEngine plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run(Runnable runnable, World world, int x, int z) {
        this.execute(runnable);
    }

    @Override
    public void runDelayed(Runnable r, World world, int x, int z) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin.javaPlugin(), r);
    }

    @Override
    public SchedulerTask runAsyncRepeating(Runnable runnable, long delay, long period) {
        return new BukkitTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin.javaPlugin(), runnable, delay, period));
    }

    @Override
    public SchedulerTask runAsyncLater(Runnable runnable, long delay) {
        return new BukkitTask(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin.javaPlugin(), runnable, delay));
    }

    @Override
    public SchedulerTask runLater(Runnable runnable, long delay, World world, int x, int z) {
        if (delay <= 0L) {
            if (Bukkit.isPrimaryThread()) {
                runnable.run();
                return new DummyTask();
            }
            return new BukkitTask(Bukkit.getScheduler().runTask((Plugin)this.plugin.javaPlugin(), runnable));
        }
        return new BukkitTask(Bukkit.getScheduler().runTaskLater((Plugin)this.plugin.javaPlugin(), runnable, delay));
    }

    @Override
    public SchedulerTask runRepeating(Runnable runnable, long delay, long period, World world, int x, int z) {
        return new BukkitTask(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin.javaPlugin(), runnable, delay, period));
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin.javaPlugin(), runnable);
    }
}

