/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.sound.Sounds;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void giveItem(Player player, int amount, Item<ItemStack> original) {
        int perStackSize;
        int maxStack = original.maxStackSize();
        for (int amountToGive = amount; amountToGive > 0; amountToGive -= perStackSize) {
            perStackSize = Math.min(maxStack, amountToGive);
            PlayerUtils.giveItem(player, original, original.copyWithCount(perStackSize));
        }
    }

    public static void giveItem(Player player, Item<ItemStack> original, Item<ItemStack> item) {
        Object serverPlayer = player.serverPlayer();
        Object inventory = FastNMS.INSTANCE.method$Player$getInventory(serverPlayer);
        boolean flag = FastNMS.INSTANCE.method$Inventory$add(inventory, item.getLiteralObject());
        if (flag && item.isEmpty()) {
            Object droppedItem = FastNMS.INSTANCE.method$ServerPlayer$drop(serverPlayer, original.copyWithCount(1).getLiteralObject(), false, false, false, null);
            if (droppedItem != null) {
                FastNMS.INSTANCE.method$ItemEntity$makeFakeItem(droppedItem);
            }
            player.world().playSound(player.position(), Sounds.ENTITY_ITEM_PICKUP, 0.2f, ((RandomUtils.generateRandomFloat(0.0f, 1.0f) - RandomUtils.generateRandomFloat(0.0f, 1.0f)) * 0.7f + 1.0f) * 2.0f, SoundSource.PLAYER);
            FastNMS.INSTANCE.method$AbstractContainerMenu$broadcastChanges(FastNMS.INSTANCE.field$Player$containerMenu(serverPlayer));
        } else {
            Object droppedItem = FastNMS.INSTANCE.method$ServerPlayer$drop(serverPlayer, item.getLiteralObject(), false, false, !VersionHelper.isOrAbove1_21_5(), null);
            if (droppedItem != null) {
                FastNMS.INSTANCE.method$ItemEntity$setNoPickUpDelay(droppedItem);
                FastNMS.INSTANCE.method$ItemEntity$setTarget(droppedItem, player.uuid());
            }
        }
    }

    public static void sendTotemAnimation(Player player, Item<ItemStack> totem, @Nullable SoundData sound, boolean removeSound) {
        ArrayList<Object> packets = new ArrayList<Object>();
        try {
            Object totemItem = totem.getLiteralObject();
            Item<?> previousMainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            boolean isMainHandTotem = VersionHelper.isOrAbove1_21_2() ? previousMainHandItem.hasComponent(ComponentTypes.DEATH_PROTECTION) : previousMainHandItem.id().equals(ItemKeys.TOTEM_OF_UNDYING);
            Object previousOffHandItem = player.getItemInHand(InteractionHand.OFF_HAND).getLiteralObject();
            if (isMainHandTotem) {
                packets.add(NetworkReflections.constructor$ClientboundSetEquipmentPacket.newInstance(player.entityID(), List.of(Pair.of((Object)CoreReflections.instance$EquipmentSlot$MAINHAND, (Object)BukkitItemManager.instance().uniqueEmptyItem().item().getLiteralObject()))));
            }
            packets.add(NetworkReflections.constructor$ClientboundSetEquipmentPacket.newInstance(player.entityID(), List.of(Pair.of((Object)CoreReflections.instance$EquipmentSlot$OFFHAND, (Object)totemItem))));
            packets.add(NetworkReflections.constructor$ClientboundEntityEventPacket.newInstance(player.serverPlayer(), (byte)35));
            if (isMainHandTotem) {
                packets.add(NetworkReflections.constructor$ClientboundSetEquipmentPacket.newInstance(player.entityID(), List.of(Pair.of((Object)CoreReflections.instance$EquipmentSlot$MAINHAND, (Object)previousMainHandItem.getLiteralObject()))));
            }
            packets.add(NetworkReflections.constructor$ClientboundSetEquipmentPacket.newInstance(player.entityID(), List.of(Pair.of((Object)CoreReflections.instance$EquipmentSlot$OFFHAND, (Object)previousOffHandItem))));
            if (sound != null || removeSound) {
                packets.add(NetworkReflections.constructor$ClientboundStopSoundPacket.newInstance(FastNMS.INSTANCE.method$ResourceLocation$fromNamespaceAndPath("minecraft", "item.totem.use"), CoreReflections.instance$SoundSource$PLAYERS));
            }
            if (sound != null) {
                packets.add(FastNMS.INSTANCE.constructor$ClientboundSoundPacket(FastNMS.INSTANCE.method$Holder$direct(FastNMS.INSTANCE.constructor$SoundEvent(KeyUtils.toResourceLocation(sound.id()), Optional.empty())), CoreReflections.instance$SoundSource$PLAYERS, player.x(), player.y(), player.z(), ((Float)sound.volume().get()).floatValue(), ((Float)sound.pitch().get()).floatValue(), RandomUtils.generateRandomLong()));
            }
            player.sendPackets(packets, false);
        }
        catch (ReflectiveOperationException e) {
            BukkitCraftEngine.instance().logger().warn("Failed to send totem animation");
        }
    }
}

