/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import net.momirealms.craftengine.core.block.AbstractCustomBlock;
import net.momirealms.craftengine.core.block.AutoStateGroup;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.block.BlockRegistryMirror;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateAppearance;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.DelegatingBlock;
import net.momirealms.craftengine.core.block.DelegatingBlockState;
import net.momirealms.craftengine.core.block.EmptyBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.InactiveCustomBlock;
import net.momirealms.craftengine.core.block.behavior.EntityBlockBehavior;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElement;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfig;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfigs;
import net.momirealms.craftengine.core.block.parser.BlockNbtParser;
import net.momirealms.craftengine.core.block.properties.Properties;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.pack.PendingConfigSection;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.allocator.BlockStateCandidate;
import net.momirealms.craftengine.core.pack.allocator.IdAllocator;
import net.momirealms.craftengine.core.pack.allocator.VisualBlockStateAllocator;
import net.momirealms.craftengine.core.pack.model.generation.AbstractModelGenerator;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.config.IdSectionConfigParser;
import net.momirealms.craftengine.core.plugin.config.SectionConfigParser;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventFunctions;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.CompletableFutures;
import net.momirealms.craftengine.core.util.EnumUtils;
import net.momirealms.craftengine.core.util.ExceptionCollector;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockManager
extends AbstractModelGenerator
implements BlockManager {
    protected final BlockParser blockParser;
    protected final BlockStateMappingParser blockStateMappingParser;
    protected final Map<Key, CustomBlock> byId = new HashMap<Key, CustomBlock>();
    protected final List<Suggestion> cachedSuggestions = new ArrayList<Suggestion>();
    protected final Set<String> namespacesInUse = new HashSet<String>();
    protected final Map<Key, Map<String, JsonElement>> blockStateOverrides = new HashMap<Key, Map<String, JsonElement>>();
    protected final Map<Key, JsonElement> modBlockStateOverrides = new HashMap<Key, JsonElement>();
    protected final Map<Integer, List<Integer>> appearanceToRealState = new Int2ObjectOpenHashMap();
    protected final Map<Key, List<BlockStateWrapper>> blockStateArranger = new HashMap<Key, List<BlockStateWrapper>>();
    protected final int[] blockStateMappings;
    protected final int vanillaBlockStateCount;
    protected final DelegatingBlock[] customBlocks;
    protected final DelegatingBlockState[] customBlockStates;
    protected final Object[] customBlockHolders;
    protected final ImmutableBlockState[] immutableBlockStates;
    protected final BlockStateCandidate[] autoVisualBlockStateCandidates;
    protected final JsonElement[] tempVanillaBlockStateModels;
    protected final Set<BlockStateWrapper> tempVisualBlockStatesInUse = new HashSet<BlockStateWrapper>();
    protected final Set<Key> tempVisualBlocksInUse = new HashSet<Key>();
    protected Map<Key, Key> soundReplacements = Map.of();

    protected AbstractBlockManager(CraftEngine plugin, int vanillaBlockStateCount, int customBlockCount) {
        super(plugin);
        this.vanillaBlockStateCount = vanillaBlockStateCount;
        this.customBlocks = new DelegatingBlock[customBlockCount];
        this.customBlockHolders = new Object[customBlockCount];
        this.customBlockStates = new DelegatingBlockState[customBlockCount];
        this.immutableBlockStates = new ImmutableBlockState[customBlockCount];
        this.blockStateMappings = new int[customBlockCount + vanillaBlockStateCount];
        this.autoVisualBlockStateCandidates = new BlockStateCandidate[vanillaBlockStateCount];
        this.tempVanillaBlockStateModels = new JsonElement[vanillaBlockStateCount];
        this.blockParser = new BlockParser(this.autoVisualBlockStateCandidates);
        this.blockStateMappingParser = new BlockStateMappingParser();
        Arrays.fill(this.blockStateMappings, -1);
    }

    @Override
    @NotNull
    public ImmutableBlockState getImmutableBlockStateUnsafe(int stateId) {
        return this.immutableBlockStates[stateId - this.vanillaBlockStateCount];
    }

    @Override
    @Nullable
    public ImmutableBlockState getImmutableBlockState(int stateId) {
        if (!this.isVanillaBlockState(stateId)) {
            return this.immutableBlockStates[stateId - this.vanillaBlockStateCount];
        }
        return null;
    }

    @Override
    public void unload() {
        super.clearModelsToGenerate();
        this.clearCache();
        this.cachedSuggestions.clear();
        this.namespacesInUse.clear();
        this.blockStateOverrides.clear();
        this.modBlockStateOverrides.clear();
        this.byId.clear();
        this.blockStateArranger.clear();
        this.appearanceToRealState.clear();
        Arrays.fill(this.blockStateMappings, -1);
        Arrays.fill(this.immutableBlockStates, EmptyBlock.STATE);
        Arrays.fill(this.autoVisualBlockStateCandidates, null);
        for (AutoStateGroup autoStateGroup : AutoStateGroup.values()) {
            autoStateGroup.reset();
        }
    }

    @Override
    public void delayedLoad() {
        this.initSuggestions();
        this.resendTags();
        this.processSounds();
        this.clearCache();
    }

    @Override
    public Map<Key, CustomBlock> loadedBlocks() {
        return Collections.unmodifiableMap(this.byId);
    }

    @Override
    public Optional<CustomBlock> blockById(Key id) {
        return Optional.ofNullable(this.byId.get(id));
    }

    public Map<Key, List<BlockStateWrapper>> blockStateArranger() {
        return this.blockStateArranger;
    }

    protected abstract void applyPlatformSettings(ImmutableBlockState var1);

    @Override
    public ConfigParser[] parsers() {
        return new ConfigParser[]{this.blockParser, this.blockStateMappingParser};
    }

    @Override
    public Map<Key, JsonElement> modBlockStates() {
        return Collections.unmodifiableMap(this.modBlockStateOverrides);
    }

    @Override
    public Map<Key, Map<String, JsonElement>> blockOverrides() {
        return Collections.unmodifiableMap(this.blockStateOverrides);
    }

    @Override
    public Collection<Suggestion> cachedSuggestions() {
        return Collections.unmodifiableCollection(this.cachedSuggestions);
    }

    @Nullable
    public Key replaceSoundIfExist(Key id) {
        return this.soundReplacements.get(id);
    }

    @Override
    public Map<Key, Key> soundReplacements() {
        return Collections.unmodifiableMap(this.soundReplacements);
    }

    public Set<String> namespacesInUse() {
        return Collections.unmodifiableSet(this.namespacesInUse);
    }

    protected void clearCache() {
        Arrays.fill(this.tempVanillaBlockStateModels, null);
        this.tempVisualBlockStatesInUse.clear();
        this.tempVisualBlocksInUse.clear();
    }

    protected void initSuggestions() {
        this.cachedSuggestions.clear();
        this.namespacesInUse.clear();
        HashSet<String> states = new HashSet<String>();
        for (CustomBlock block : this.byId.values()) {
            states.add(block.id().toString());
            this.namespacesInUse.add(block.id().namespace());
            for (ImmutableBlockState state : block.variantProvider().states()) {
                states.add(state.toString());
            }
        }
        for (String state : states) {
            this.cachedSuggestions.add(Suggestion.suggestion((String)state));
        }
    }

    @NotNull
    public List<Integer> appearanceToRealStates(int appearanceStateId) {
        return Optional.ofNullable(this.appearanceToRealState.get(appearanceStateId)).orElse(List.of());
    }

    public abstract BlockBehavior createBlockBehavior(CustomBlock var1, List<Map<String, Object>> var2);

    protected abstract void resendTags();

    protected abstract boolean isVanillaBlock(Key var1);

    protected abstract Key getBlockOwnerId(int var1);

    protected abstract void setVanillaBlockTags(Key var1, List<String> var2);

    protected abstract int vanillaBlockStateCount();

    protected abstract void processSounds();

    protected abstract CustomBlock createCustomBlock(@NotNull Holder.Reference<CustomBlock> var1, @NotNull BlockStateVariantProvider var2, @NotNull Map<EventTrigger, List<Function<PlayerOptionalContext>>> var3, @Nullable LootTable<?> var4);

    public boolean isVanillaBlockState(int id) {
        return id < this.vanillaBlockStateCount && id >= 0;
    }

    public BlockParser blockParser() {
        return this.blockParser;
    }

    public BlockStateMappingParser blockStateMappingParser() {
        return this.blockStateMappingParser;
    }

    public class BlockParser
    extends IdSectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"blocks", "block"};
        private final IdAllocator internalIdAllocator;
        private final VisualBlockStateAllocator visualBlockStateAllocator;
        private final List<PendingConfigSection> pendingConfigSections = new ArrayList<PendingConfigSection>();

        public BlockParser(BlockStateCandidate[] candidates) {
            this.internalIdAllocator = new IdAllocator(AbstractBlockManager.this.plugin.dataFolderPath().resolve("cache").resolve("custom-block-states.json"));
            this.visualBlockStateAllocator = new VisualBlockStateAllocator(AbstractBlockManager.this.plugin.dataFolderPath().resolve("cache").resolve("visual-block-states.json"), candidates, AbstractBlockManager.this::createVanillaBlockState);
        }

        public void addPendingConfigSection(PendingConfigSection section) {
            this.pendingConfigSections.add(section);
        }

        public IdAllocator internalIdAllocator() {
            return this.internalIdAllocator;
        }

        public VisualBlockStateAllocator visualBlockStateAllocator() {
            return this.visualBlockStateAllocator;
        }

        @Override
        public void postProcess() {
            this.internalIdAllocator.processPendingAllocations();
            try {
                this.internalIdAllocator.saveToCache();
            }
            catch (IOException e) {
                AbstractBlockManager.this.plugin.logger().warn("Error while saving custom block states allocation", e);
            }
            this.visualBlockStateAllocator.processPendingAllocations();
            try {
                this.visualBlockStateAllocator.saveToCache();
            }
            catch (IOException e) {
                AbstractBlockManager.this.plugin.logger().warn("Error while saving visual block states allocation", e);
            }
        }

        @Override
        public void preProcess() {
            this.internalIdAllocator.reset(0, Config.serverSideBlocks() - 1);
            this.visualBlockStateAllocator.reset();
            try {
                this.visualBlockStateAllocator.loadFromCache();
            }
            catch (IOException e) {
                AbstractBlockManager.this.plugin.logger().warn("Error while loading visual block states allocation cache", e);
            }
            try {
                this.internalIdAllocator.loadFromCache();
            }
            catch (IOException e) {
                AbstractBlockManager.this.plugin.logger().warn("Error while loading custom block states allocation cache", e);
            }
            for (PendingConfigSection section : this.pendingConfigSections) {
                ResourceConfigUtils.runCatching(section.path(), section.node(), () -> this.parseSection(section.pack(), section.path(), section.node(), section.id(), section.config()), () -> GsonHelper.get().toJson(section.config()));
            }
            this.pendingConfigSections.clear();
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 60;
        }

        @Override
        public void parseSection(Pack pack, Path path, String node, Key id, Map<String, Object> section) {
            if (AbstractBlockManager.this.isVanillaBlock(id)) {
                this.parseVanillaBlock(id, section);
            } else {
                if (AbstractBlockManager.this.byId.containsKey(id)) {
                    throw new LocalizedResourceConfigException("warning.config.block.duplicate", new String[0]);
                }
                this.parseCustomBlock(path, node, id, section);
            }
        }

        private void parseVanillaBlock(Key id, Map<String, Object> section) {
            Object clientBoundTags;
            Map<String, Object> settings = MiscUtils.castToMap(section.get("settings"), true);
            if (settings != null && (clientBoundTags = settings.get("client-bound-tags")) instanceof List) {
                List list = (List)clientBoundTags;
                List<String> clientSideTags = MiscUtils.getAsStringList(list).stream().filter(ResourceLocation::isValid).toList();
                AbstractBlockManager.this.setVanillaBlockTags(id, clientSideTags);
            }
        }

        private void parseCustomBlock(Path path, String node, Key id, Map<String, Object> section) {
            BlockSettings settings = BlockSettings.fromMap(id, MiscUtils.castToMap(section.get("settings"), true));
            Map<String, Object> stateSection = MiscUtils.castToMap(ResourceConfigUtils.requireNonNullOrThrow(ResourceConfigUtils.get(section, "state", "states"), "warning.config.block.missing_state"), true);
            boolean singleState = !stateSection.containsKey("properties");
            Map<String, Property<?>> properties = singleState ? Map.of() : this.parseBlockProperties(ResourceConfigUtils.getAsMap(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("properties"), "warning.config.block.state.missing_properties"), "properties"));
            Holder.Reference<CustomBlock> holder = ((WritableRegistry)BuiltInRegistries.BLOCK).getOrRegisterForHolder(ResourceKey.create(BuiltInRegistries.BLOCK.key().location(), id));
            holder.bindValue(new InactiveCustomBlock(holder));
            BlockStateVariantProvider variantProvider = new BlockStateVariantProvider(holder, (owner, propertyMap) -> {
                ImmutableBlockState blockState = new ImmutableBlockState((Holder.Reference<CustomBlock>)owner, (Reference2ObjectArrayMap<Property<?>, Comparable<?>>)propertyMap);
                blockState.setSettings(settings);
                return blockState;
            }, properties);
            ImmutableList<ImmutableBlockState> states = variantProvider.states();
            ArrayList<CompletableFuture<Integer>> internalIdAllocators = new ArrayList<CompletableFuture<Integer>>(states.size());
            if (stateSection.containsKey("id")) {
                int startingId = ResourceConfigUtils.getAsInt(stateSection.get("id"), "id");
                int endingId = startingId + states.size() - 1;
                if (startingId < 0 || endingId >= Config.serverSideBlocks()) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_id", startingId + "~" + endingId, String.valueOf(Config.serverSideBlocks() - 1));
                }
                List<Pair<String, Integer>> conflicts = this.internalIdAllocator.getFixedIdsBetween(startingId, endingId);
                if (!conflicts.isEmpty()) {
                    ExceptionCollector<LocalizedResourceConfigException> exceptionCollector = new ExceptionCollector<LocalizedResourceConfigException>();
                    for (Pair<String, Integer> conflict : conflicts) {
                        int internalId = conflict.right();
                        int index = internalId - startingId;
                        exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block.state.id.conflict", ((ImmutableBlockState)states.get(index)).toString(), conflict.left(), BlockManager.createCustomBlockKey(internalId).toString()));
                    }
                    exceptionCollector.throwIfPresent();
                }
                for (ImmutableBlockState blockState : states) {
                    String blockStateId = blockState.toString();
                    internalIdAllocators.add(this.internalIdAllocator.assignFixedId(blockStateId, startingId++));
                }
            } else {
                for (ImmutableBlockState blockState : states) {
                    String blockStateId = blockState.toString();
                    internalIdAllocators.add(this.internalIdAllocator.requestAutoId(blockStateId));
                }
            }
            CompletableFutures.allOf(internalIdAllocators).whenComplete((v1, t1) -> ResourceConfigUtils.runCatching(path, node, () -> {
                Map<String, Map> appearanceConfigs;
                if (t1 != null) {
                    if (t1 instanceof CompletionException) {
                        CompletionException e = (CompletionException)t1;
                        Throwable cause = e.getCause();
                        if (cause instanceof IdAllocator.IdExhaustedException) {
                            throw new LocalizedResourceConfigException("warning.config.block.state.id.exhausted", new String[0]);
                        }
                        Debugger.BLOCK.warn(() -> "Unknown error while allocating internal block state id.", cause);
                        return;
                    }
                    throw new RuntimeException("Unknown error occurred", (Throwable)t1);
                }
                for (int i = 0; i < internalIdAllocators.size(); ++i) {
                    CompletableFuture future = (CompletableFuture)internalIdAllocators.get(i);
                    try {
                        int internalId = (Integer)future.get();
                        ((ImmutableBlockState)states.get(i)).setCustomBlockState(BlockRegistryMirror.byId(internalId + AbstractBlockManager.this.vanillaBlockStateCount));
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        AbstractBlockManager.this.plugin.logger().warn("Interrupted while allocating internal block state for block " + id.asString(), e);
                        return;
                    }
                }
                AbstractCustomBlock customBlock = (AbstractCustomBlock)AbstractBlockManager.this.createCustomBlock(holder, variantProvider, EventFunctions.parseEvents(ResourceConfigUtils.get(section, "events", "event")), LootTable.fromMap(ResourceConfigUtils.getAsMapOrNull(section.get("loot"), "loot")));
                BlockBehavior blockBehavior = AbstractBlockManager.this.createBlockBehavior(customBlock, MiscUtils.getAsMapList(ResourceConfigUtils.get(section, "behavior", "behaviors")));
                HashMap<String, CompletableFuture<BlockStateWrapper>> futureVisualStates = new HashMap<String, CompletableFuture<BlockStateWrapper>>();
                if (singleState) {
                    appearanceConfigs = Map.of("", stateSection);
                } else {
                    Map<String, Object> rawAppearancesSection = ResourceConfigUtils.getAsMap(ResourceConfigUtils.requireNonNullOrThrow(stateSection.get("appearances"), "warning.config.block.state.missing_appearances"), "appearances");
                    appearanceConfigs = new LinkedHashMap<String, Map>(4);
                    for (Map.Entry<String, Object> entry : rawAppearancesSection.entrySet()) {
                        appearanceConfigs.put(entry.getKey(), ResourceConfigUtils.getAsMap(entry.getValue(), entry.getKey()));
                    }
                }
                for (Map.Entry<String, Map> entry : appearanceConfigs.entrySet()) {
                    Map appearanceSection = entry.getValue();
                    if (appearanceSection.containsKey("state")) {
                        String appearanceName;
                        futureVisualStates.put(appearanceName, this.visualBlockStateAllocator.assignFixedBlockState((String)((appearanceName = entry.getKey()).isEmpty() ? id.asString() : id.asString() + ":" + appearanceName), this.parsePluginFormattedBlockState(appearanceSection.get("state").toString())));
                        continue;
                    }
                    if (appearanceSection.containsKey("auto-state")) {
                        String appearanceName;
                        String autoStateId = appearanceSection.get("auto-state").toString();
                        AutoStateGroup group = AutoStateGroup.byId(autoStateId);
                        if (group == null) {
                            throw new LocalizedResourceConfigException("warning.config.block.state.invalid_auto_state", autoStateId, EnumUtils.toString(AutoStateGroup.values()));
                        }
                        futureVisualStates.put(appearanceName, this.visualBlockStateAllocator.requestAutoState((String)((appearanceName = entry.getKey()).isEmpty() ? id.asString() : id.asString() + ":" + appearanceName), group));
                        continue;
                    }
                    throw new LocalizedResourceConfigException("warning.config.block.state.missing_state", new String[0]);
                }
                CompletableFutures.allOf(futureVisualStates.values()).whenComplete((v2, t2) -> ResourceConfigUtils.runCatching(path, node, () -> {
                    EntityBlockBehavior entityBlockBehavior;
                    Map<String, Object> variantsSection;
                    if (t2 != null) {
                        if (t2 instanceof CompletionException) {
                            CompletionException e = (CompletionException)t2;
                            Throwable cause = e.getCause();
                            if (cause instanceof VisualBlockStateAllocator.StateExhaustedException) {
                                VisualBlockStateAllocator.StateExhaustedException exhausted = (VisualBlockStateAllocator.StateExhaustedException)cause;
                                throw new LocalizedResourceConfigException("warning.config.block.state.auto_state.exhausted", exhausted.group().id(), String.valueOf(exhausted.group().candidateCount()));
                            }
                            Debugger.BLOCK.warn(() -> "Unknown error while allocating visual block state.", cause);
                            return;
                        }
                        throw new RuntimeException("Unknown error occurred", (Throwable)t2);
                    }
                    BlockStateAppearance anyAppearance = null;
                    HashMap<Object, BlockStateAppearance> appearances = new HashMap<Object, BlockStateAppearance>();
                    for (Map.Entry entry : appearanceConfigs.entrySet()) {
                        BlockStateWrapper visualBlockState;
                        String appearanceName = (String)entry.getKey();
                        Map map = (Map)entry.getValue();
                        try {
                            visualBlockState = (BlockStateWrapper)((CompletableFuture)futureVisualStates.get(appearanceName)).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            AbstractBlockManager.this.plugin.logger().warn("Interrupted while allocating visual block state for block " + id.asString(), e);
                            return;
                        }
                        this.arrangeModelForStateAndVerify(visualBlockState, ResourceConfigUtils.get(map, "model", "models"));
                        BlockStateAppearance blockStateAppearance = new BlockStateAppearance(visualBlockState, this.parseBlockEntityRender(map.get("entity-renderer")));
                        appearances.put(appearanceName, blockStateAppearance);
                        if (anyAppearance != null) continue;
                        anyAppearance = blockStateAppearance;
                    }
                    Objects.requireNonNull(anyAppearance, "any appearance should not be null");
                    ExceptionCollector<LocalizedResourceConfigException> exceptionCollector = new ExceptionCollector<LocalizedResourceConfigException>();
                    if (!singleState && (variantsSection = ResourceConfigUtils.getAsMapOrNull(stateSection.get("variants"), "variants")) != null) {
                        for (Map.Entry entry : variantsSection.entrySet()) {
                            String appearanceName;
                            Map<String, Object> variantSection = ResourceConfigUtils.getAsMap(entry.getValue(), (String)entry.getKey());
                            String variantNBT = (String)entry.getKey();
                            CompoundTag tag = BlockNbtParser.deserialize(variantProvider, variantNBT);
                            if (tag == null) {
                                exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block.state.property.invalid_format", variantNBT));
                                continue;
                            }
                            List<ImmutableBlockState> possibleStates = variantProvider.getPossibleStates(tag);
                            Map<String, Object> anotherSetting = ResourceConfigUtils.getAsMapOrNull(variantSection.get("settings"), "settings");
                            if (anotherSetting != null) {
                                for (ImmutableBlockState possibleState : possibleStates) {
                                    possibleState.setSettings(BlockSettings.ofFullCopy(possibleState.settings(), anotherSetting));
                                }
                            }
                            if ((appearanceName = ResourceConfigUtils.getAsString(variantSection.get("appearance"))) == null) continue;
                            BlockStateAppearance appearance = (BlockStateAppearance)appearances.get(appearanceName);
                            if (appearance == null) {
                                exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block.state.variant.invalid_appearance", variantNBT, appearanceName));
                                continue;
                            }
                            for (ImmutableBlockState possibleState : possibleStates) {
                                possibleState.setVanillaBlockState(appearance.blockState());
                                appearance.blockEntityRenderer().ifPresent(possibleState::setConstantRenderers);
                            }
                        }
                    }
                    boolean isEntityBlock = (entityBlockBehavior = blockBehavior.getEntityBehavior()) != null;
                    for (ImmutableBlockState state : states) {
                        if (isEntityBlock) {
                            state.setBlockEntityType(entityBlockBehavior.blockEntityType());
                        }
                        state.setBehavior(blockBehavior);
                        int internalId = state.customBlockState().registryId();
                        BlockStateWrapper visualState = state.vanillaBlockState();
                        if (visualState == null) {
                            visualState = anyAppearance.blockState();
                            state.setVanillaBlockState(visualState);
                            anyAppearance.blockEntityRenderer().ifPresent(state::setConstantRenderers);
                        }
                        int appearanceId = visualState.registryId();
                        int index = internalId - AbstractBlockManager.this.vanillaBlockStateCount;
                        AbstractBlockManager.this.immutableBlockStates[index] = state;
                        AbstractBlockManager.this.blockStateMappings[internalId] = appearanceId;
                        AbstractBlockManager.this.appearanceToRealState.computeIfAbsent(appearanceId, k -> new IntArrayList()).add(internalId);
                        AbstractBlockManager.this.tempVisualBlockStatesInUse.add(visualState);
                        AbstractBlockManager.this.tempVisualBlocksInUse.add(AbstractBlockManager.this.getBlockOwnerId(visualState));
                        AbstractBlockManager.this.applyPlatformSettings(state);
                        if (!Config.generateModAssets()) continue;
                        AbstractBlockManager.this.modBlockStateOverrides.put(BlockManager.createCustomBlockKey(index), Optional.ofNullable(AbstractBlockManager.this.tempVanillaBlockStateModels[appearanceId]).orElseGet(() -> {
                            JsonObject json = new JsonObject();
                            json.addProperty("model", "minecraft:block/air");
                            return json;
                        }));
                    }
                    customBlock.setBehavior(blockBehavior);
                    holder.bindValue(customBlock);
                    AbstractBlockManager.this.byId.put(customBlock.id(), customBlock);
                    exceptionCollector.throwIfPresent();
                }, () -> GsonHelper.get().toJson((Object)section)));
            }, () -> GsonHelper.get().toJson((Object)section)));
        }

        private Optional<BlockEntityElementConfig<? extends BlockEntityElement>[]> parseBlockEntityRender(Object arguments) {
            if (arguments == null) {
                return Optional.empty();
            }
            List<BlockEntityElementConfig> blockEntityElementConfigs = ResourceConfigUtils.parseConfigAsList(arguments, BlockEntityElementConfigs::fromMap);
            if (blockEntityElementConfigs.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(blockEntityElementConfigs.toArray(new BlockEntityElementConfig[0]));
        }

        @NotNull
        private Map<String, Property<?>> parseBlockProperties(Map<String, Object> propertiesSection) {
            HashMap properties = new HashMap();
            for (Map.Entry<String, Object> entry : propertiesSection.entrySet()) {
                Property<?> property = Properties.fromMap(entry.getKey(), ResourceConfigUtils.getAsMap(entry.getValue(), entry.getKey()));
                properties.put(entry.getKey(), property);
            }
            return properties;
        }

        private void arrangeModelForStateAndVerify(BlockStateWrapper blockStateWrapper, Object modelOrModels) {
            List<JsonObject> variants;
            if (modelOrModels == null) {
                return;
            }
            if (modelOrModels instanceof String) {
                String model = (String)modelOrModels;
                JsonObject json = new JsonObject();
                json.addProperty("model", model);
                variants = Collections.singletonList(json);
            } else {
                variants = ResourceConfigUtils.parseConfigAsList(modelOrModels, this::parseAppearanceModelSectionAsJson);
                if (variants.isEmpty()) {
                    return;
                }
            }
            String blockState = blockStateWrapper.getAsString();
            int firstIndex = blockState.indexOf(91);
            Key blockId = firstIndex == -1 ? Key.of(blockState) : Key.of(blockState.substring(0, firstIndex));
            String propertyNBT = firstIndex == -1 ? "" : blockState.substring(firstIndex + 1, blockState.lastIndexOf(93));
            JsonElement combinedVariant = GsonHelper.combine(variants);
            Map overrideMap = AbstractBlockManager.this.blockStateOverrides.computeIfAbsent(blockId, k -> new HashMap());
            JsonElement previous = (JsonElement)overrideMap.get(propertyNBT);
            if (previous != null && !previous.equals(combinedVariant)) {
                throw new LocalizedResourceConfigException("warning.config.block.state.model.conflict", GsonHelper.get().toJson(combinedVariant), blockState, GsonHelper.get().toJson(previous));
            }
            overrideMap.put(propertyNBT, combinedVariant);
            AbstractBlockManager.this.tempVanillaBlockStateModels[blockStateWrapper.registryId()] = combinedVariant;
        }

        private JsonObject parseAppearanceModelSectionAsJson(Map<String, Object> section) {
            Map<String, Object> generationMap;
            JsonObject json = new JsonObject();
            String modelPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(section.get("path"), "warning.config.block.state.model.missing_path");
            if (!ResourceLocation.isValid(modelPath)) {
                throw new LocalizedResourceConfigException("warning.config.block.state.model.invalid_path", modelPath);
            }
            json.addProperty("model", modelPath);
            if (section.containsKey("x")) {
                json.addProperty("x", (Number)ResourceConfigUtils.getAsInt(section.get("x"), "x"));
            }
            if (section.containsKey("y")) {
                json.addProperty("y", (Number)ResourceConfigUtils.getAsInt(section.get("y"), "y"));
            }
            if (section.containsKey("uvlock")) {
                json.addProperty("uvlock", Boolean.valueOf(ResourceConfigUtils.getAsBoolean(section.get("uvlock"), "uvlock")));
            }
            if (section.containsKey("weight")) {
                json.addProperty("weight", (Number)ResourceConfigUtils.getAsInt(section.get("weight"), "weight"));
            }
            if ((generationMap = MiscUtils.castToMap(section.get("generation"), true)) != null) {
                AbstractBlockManager.this.prepareModelGeneration(ModelGeneration.of(Key.of(modelPath), generationMap));
            }
            return json;
        }

        private BlockStateWrapper parsePluginFormattedBlockState(String blockState) {
            BlockStateWrapper wrapper;
            String[] split = blockState.split(":", 3);
            if (split.length >= 4) {
                throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
            }
            String stateOrId = split[split.length - 1];
            boolean isId = false;
            int arrangerIndex = 0;
            try {
                arrangerIndex = Integer.parseInt(stateOrId);
                if (arrangerIndex < 0) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                isId = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (isId) {
                if (split.length == 1) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                Key block = split.length == 2 ? Key.of(split[0]) : Key.of(split[0], split[1]);
                try {
                    List<BlockStateWrapper> arranger = AbstractBlockManager.this.blockStateArranger.get(block);
                    if (arranger == null) {
                        throw new LocalizedResourceConfigException("warning.config.block.state.unavailable_vanilla", blockState);
                    }
                    if (arrangerIndex >= arranger.size()) {
                        throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla_id", blockState, String.valueOf(arranger.size() - 1));
                    }
                    wrapper = arranger.get(arrangerIndex);
                }
                catch (NumberFormatException e) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", e, blockState);
                }
            } else {
                BlockStateWrapper packedBlockState = AbstractBlockManager.this.createBlockState(blockState);
                if (packedBlockState == null) {
                    throw new LocalizedResourceConfigException("warning.config.block.state.invalid_vanilla", blockState);
                }
                wrapper = packedBlockState;
            }
            return wrapper;
        }
    }

    public class BlockStateMappingParser
    extends SectionConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"block-state-mappings", "block-state-mapping"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 10;
        }

        @Override
        public void parseSection(Pack pack, Path path, Map<String, Object> section) throws LocalizedException {
            ExceptionCollector<LocalizedResourceConfigException> exceptionCollector = new ExceptionCollector<LocalizedResourceConfigException>();
            for (Map.Entry<String, Object> entry : section.entrySet()) {
                String before = entry.getKey();
                String after = entry.getValue().toString();
                BlockStateWrapper beforeState = AbstractBlockManager.this.createVanillaBlockState(before);
                BlockStateWrapper afterState = AbstractBlockManager.this.createVanillaBlockState(after);
                if (beforeState == null) {
                    exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block_state_mapping.invalid_state", before));
                    continue;
                }
                if (afterState == null) {
                    exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block_state_mapping.invalid_state", after));
                    continue;
                }
                int previous = AbstractBlockManager.this.blockStateMappings[beforeState.registryId()];
                if (previous != -1 && previous != afterState.registryId()) {
                    exceptionCollector.add(new LocalizedResourceConfigException("warning.config.block_state_mapping.conflict", beforeState.toString(), afterState.toString(), BlockRegistryMirror.byId(previous).toString()));
                    continue;
                }
                AbstractBlockManager.this.blockStateMappings[beforeState.registryId()] = afterState.registryId();
                Key blockOwnerId = AbstractBlockManager.this.getBlockOwnerId(beforeState);
                List blockStateWrappers = AbstractBlockManager.this.blockStateArranger.computeIfAbsent(blockOwnerId, k -> new ArrayList());
                blockStateWrappers.add(beforeState);
                AbstractBlockManager.this.autoVisualBlockStateCandidates[beforeState.registryId()] = this.createVisualBlockCandidate(beforeState);
            }
            exceptionCollector.throwIfPresent();
        }

        @Nullable
        public BlockStateCandidate createVisualBlockCandidate(BlockStateWrapper blockState) {
            List<AutoStateGroup> groups = AutoStateGroup.findGroups(blockState);
            if (!groups.isEmpty()) {
                BlockStateCandidate candidate = new BlockStateCandidate(blockState);
                for (AutoStateGroup group : groups) {
                    group.addCandidate(candidate);
                }
                return candidate;
            }
            return null;
        }
    }
}

