/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomBlock
implements CustomBlock {
    protected final Key id;
    protected final Holder.Reference<CustomBlock> holder;
    protected final BlockStateVariantProvider variantProvider;
    protected final BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> placementFunction;
    protected final ImmutableBlockState defaultState;
    protected final Map<EventTrigger, List<Function<PlayerOptionalContext>>> events;
    @Nullable
    protected final LootTable<?> lootTable;
    protected BlockBehavior behavior = EmptyBlockBehavior.INSTANCE;

    protected AbstractCustomBlock(@NotNull Holder.Reference<CustomBlock> holder, @NotNull BlockStateVariantProvider variantProvider, @NotNull Map<EventTrigger, List<Function<PlayerOptionalContext>>> events, @Nullable LootTable<?> lootTable) {
        this.id = holder.key().location();
        this.holder = holder;
        this.lootTable = lootTable;
        this.events = events;
        this.variantProvider = variantProvider;
        this.defaultState = this.variantProvider.getDefaultState();
        ArrayList<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>> placements = new ArrayList<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>>(4);
        for (Map.Entry propertyEntry : this.variantProvider.properties().entrySet()) {
            placements.add(Property.createStateForPlacement((String)propertyEntry.getKey(), (Property)propertyEntry.getValue()));
        }
        this.placementFunction = AbstractCustomBlock.composite(placements);
    }

    private static BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> composite(List<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>> placements) {
        return switch (placements.size()) {
            case 0 -> (c, i) -> i;
            case 1 -> placements.get(0);
            case 2 -> {
                BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> f1 = placements.get(0);
                BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> f2 = placements.get(1);
                yield (c, i) -> (ImmutableBlockState)f2.apply((BlockPlaceContext)c, (ImmutableBlockState)f1.apply((BlockPlaceContext)c, (ImmutableBlockState)i));
            }
            default -> (c, i) -> {
                for (BiFunction f : placements) {
                    i = (ImmutableBlockState)f.apply(c, i);
                }
                return i;
            };
        };
    }

    @Override
    @Nullable
    public LootTable<?> lootTable() {
        return this.lootTable;
    }

    @Override
    public void execute(PlayerOptionalContext context, EventTrigger trigger) {
        for (Function function : Optional.ofNullable(this.events.get((Object)trigger)).orElse(Collections.emptyList())) {
            function.run(context);
        }
    }

    @Override
    @NotNull
    public BlockStateVariantProvider variantProvider() {
        return this.variantProvider;
    }

    @Override
    @NotNull
    public final Key id() {
        return this.id;
    }

    public void setBehavior(@Nullable BlockBehavior behavior) {
        this.behavior = behavior;
    }

    @Override
    public List<ImmutableBlockState> getPossibleStates(CompoundTag nbt) {
        return this.variantProvider.getPossibleStates(nbt);
    }

    @Override
    public ImmutableBlockState getBlockState(CompoundTag nbt) {
        ImmutableBlockState state = this.defaultState();
        for (Map.Entry<String, Tag> entry : nbt.tags.entrySet()) {
            Property<?> property = this.variantProvider.getProperty(entry.getKey());
            if (property == null) continue;
            try {
                state = ImmutableBlockState.with(state, property, property.unpack(entry.getValue()));
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to parse block state: " + entry.getKey(), e);
            }
        }
        return state;
    }

    @Override
    @Nullable
    public Property<?> getProperty(String name) {
        return this.variantProvider.getProperty(name);
    }

    @Override
    @NotNull
    public Collection<Property<?>> properties() {
        return this.variantProvider.properties().values();
    }

    @Override
    public final ImmutableBlockState defaultState() {
        return this.defaultState;
    }

    @Override
    public ImmutableBlockState getStateForPlacement(BlockPlaceContext context) {
        ImmutableBlockState state = this.placementFunction.apply(context, this.defaultState());
        return this.behavior.updateStateForPlacement(context, state);
    }

    @Override
    public void setPlacedBy(BlockPlaceContext context, ImmutableBlockState state) {
        this.behavior.setPlacedBy(context, state);
    }
}

