/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.block.BlockKeys;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.pack.allocator.BlockStateCandidate;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AutoStateGroup {
    LEAVES("leaves", Set.of(BlockKeys.OAK_LEAVES, BlockKeys.SPRUCE_LEAVES, BlockKeys.BIRCH_LEAVES, BlockKeys.JUNGLE_LEAVES, BlockKeys.ACACIA_LEAVES, BlockKeys.DARK_OAK_LEAVES, BlockKeys.MANGROVE_LEAVES, BlockKeys.CHERRY_LEAVES, BlockKeys.PALE_OAK_LEAVES, BlockKeys.AZALEA_LEAVES, BlockKeys.FLOWERING_AZALEA_LEAVES), w -> (Boolean)w.getProperty("waterlogged") == false),
    WATERLOGGED_LEAVES("waterlogged_leaves", Set.of(BlockKeys.OAK_LEAVES, BlockKeys.SPRUCE_LEAVES, BlockKeys.BIRCH_LEAVES, BlockKeys.JUNGLE_LEAVES, BlockKeys.ACACIA_LEAVES, BlockKeys.DARK_OAK_LEAVES, BlockKeys.MANGROVE_LEAVES, BlockKeys.CHERRY_LEAVES, BlockKeys.PALE_OAK_LEAVES, BlockKeys.AZALEA_LEAVES, BlockKeys.FLOWERING_AZALEA_LEAVES), w -> (Boolean)w.getProperty("waterlogged")),
    LOWER_TRIPWIRE("lower_tripwire", Set.of(BlockKeys.TRIPWIRE), w -> (Boolean)w.getProperty("attached")),
    HIGHER_TRIPWIRE("higher_tripwire", Set.of(BlockKeys.TRIPWIRE), w -> (Boolean)w.getProperty("attached") == false),
    NOTE_BLOCK("note_block", Set.of(BlockKeys.NOTE_BLOCK), w -> true),
    BROWN_MUSHROOM("brown_mushroom", Set.of(BlockKeys.BROWN_MUSHROOM_BLOCK), w -> true),
    RED_MUSHROOM("red_mushroom", Set.of(BlockKeys.RED_MUSHROOM_BLOCK), w -> true),
    MUSHROOM_STEM("mushroom_stem", Set.of(BlockKeys.MUSHROOM_STEM), w -> true),
    TRIPWIRE("tripwire", Set.of(BlockKeys.TRIPWIRE), w -> true),
    SUGAR_CANE("sugar_cane", Set.of(BlockKeys.SUGAR_CANE), w -> true),
    CACTUS("cactus", Set.of(BlockKeys.CACTUS), w -> true),
    SAPLING("sapling", Set.of(BlockKeys.OAK_SAPLING, BlockKeys.SPRUCE_SAPLING, BlockKeys.BIRCH_SAPLING, BlockKeys.JUNGLE_SAPLING, BlockKeys.ACACIA_SAPLING, BlockKeys.DARK_OAK_SAPLING, BlockKeys.CHERRY_SAPLING, BlockKeys.PALE_OAK_SAPLING), w -> true),
    MUSHROOM("mushroom", Set.of(BlockKeys.BROWN_MUSHROOM_BLOCK, BlockKeys.RED_MUSHROOM_BLOCK, BlockKeys.MUSHROOM_STEM), w -> true),
    SOLID("solid", Set.of(BlockKeys.BROWN_MUSHROOM_BLOCK, BlockKeys.RED_MUSHROOM_BLOCK, BlockKeys.MUSHROOM_STEM, BlockKeys.NOTE_BLOCK), w -> true);

    private final Set<Key> blocks;
    private final String id;
    private final Predicate<BlockStateWrapper> predicate;
    private final List<BlockStateCandidate> candidates = new ArrayList<BlockStateCandidate>();
    private int pointer;
    private static final Map<String, AutoStateGroup> BY_ID;
    private static final Map<Key, List<AutoStateGroup>> BY_BLOCKS;

    private AutoStateGroup(String id, Set<Key> blocks, Predicate<BlockStateWrapper> predicate) {
        this.id = id;
        this.blocks = blocks;
        this.predicate = predicate;
    }

    public void reset() {
        this.pointer = 0;
        this.candidates.clear();
    }

    public void addCandidate(@NotNull BlockStateCandidate candidate) {
        this.candidates.add(candidate);
    }

    public int candidateCount() {
        return this.candidates.size();
    }

    @Nullable
    public BlockStateCandidate findNextCandidate() {
        while (this.pointer < this.candidates.size()) {
            BlockStateCandidate state = this.candidates.get(this.pointer);
            if (!state.isUsed()) {
                return state;
            }
            ++this.pointer;
        }
        return null;
    }

    public boolean test(BlockStateWrapper state) {
        if (!this.blocks.contains(state.ownerId())) {
            return false;
        }
        return this.predicate.test(state);
    }

    public Set<Key> blocks() {
        return this.blocks;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public static AutoStateGroup byId(String id) {
        return BY_ID.get(id);
    }

    public static List<AutoStateGroup> findGroups(BlockStateWrapper wrapper) {
        return AutoStateGroup.findGroups(wrapper.ownerId(), wrapper);
    }

    public static List<AutoStateGroup> findGroups(Key id, BlockStateWrapper wrapper) {
        List<AutoStateGroup> groups = BY_BLOCKS.get(id);
        if (groups == null) {
            return Collections.emptyList();
        }
        ArrayList<AutoStateGroup> result = new ArrayList<AutoStateGroup>(groups.size());
        for (AutoStateGroup group : groups) {
            if (!group.predicate.test(wrapper)) continue;
            result.add(group);
        }
        return result;
    }

    static {
        BY_ID = new HashMap<String, AutoStateGroup>();
        BY_BLOCKS = new HashMap<Key, List<AutoStateGroup>>();
        for (AutoStateGroup group : AutoStateGroup.values()) {
            BY_ID.put(group.id(), group);
            BY_ID.put(group.id().toUpperCase(Locale.ROOT), group);
            for (Key key : group.blocks) {
                BY_BLOCKS.computeIfAbsent(key, k -> new ArrayList(4)).add(group);
            }
        }
    }
}

