/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.Map;
import net.momirealms.craftengine.core.sound.SoundData;

public final class BlockSounds {
    public static final BlockSounds EMPTY = new BlockSounds(SoundData.EMPTY, SoundData.EMPTY, SoundData.EMPTY, SoundData.EMPTY, SoundData.EMPTY);
    private final SoundData breakSound;
    private final SoundData stepSound;
    private final SoundData placeSound;
    private final SoundData hitSound;
    private final SoundData fallSound;

    public BlockSounds(SoundData breakSound, SoundData stepSound, SoundData placeSound, SoundData hitSound, SoundData fallSound) {
        this.breakSound = breakSound;
        this.stepSound = stepSound;
        this.placeSound = placeSound;
        this.hitSound = hitSound;
        this.fallSound = fallSound;
    }

    public static BlockSounds fromMap(Map<String, Object> map) {
        if (map == null) {
            return EMPTY;
        }
        return new BlockSounds(SoundData.create(map.getOrDefault("break", "minecraft:intentionally_empty"), SoundData.SoundValue.FIXED_1, SoundData.SoundValue.FIXED_0_8), SoundData.create(map.getOrDefault("step", "minecraft:intentionally_empty"), SoundData.SoundValue.FIXED_0_15, SoundData.SoundValue.FIXED_1), SoundData.create(map.getOrDefault("place", "minecraft:intentionally_empty"), SoundData.SoundValue.FIXED_1, SoundData.SoundValue.FIXED_0_8), SoundData.create(map.getOrDefault("hit", "minecraft:intentionally_empty"), SoundData.SoundValue.FIXED_0_5, SoundData.SoundValue.FIXED_0_5), SoundData.create(map.getOrDefault("fall", "minecraft:intentionally_empty"), SoundData.SoundValue.FIXED_0_5, SoundData.SoundValue.FIXED_0_75));
    }

    public SoundData breakSound() {
        return this.breakSound;
    }

    public SoundData stepSound() {
        return this.stepSound;
    }

    public SoundData placeSound() {
        return this.placeSound;
    }

    public SoundData hitSound() {
        return this.hitSound;
    }

    public SoundData fallSound() {
        return this.fallSound;
    }
}

